/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.jumpmeter;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PlayerRideableJumping;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeJumpMeterElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation JUMP_BAR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/jump_bar_background");
    private static final ResourceLocation JUMP_BAR_COOLDOWN_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/jump_bar_cooldown");
    private static final ResourceLocation JUMP_BAR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/jump_bar_progress");
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private final Minecraft minecraft = Minecraft.getInstance();

    public VanillaLikeJumpMeterElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.renderJumpMeter(graphics, elementX, elementY, elementWidth, elementHeight);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderJumpMeter(GuiGraphics graphics, int elementX, int elementY, int elementWidth, int elementHeight) {
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        PlayerRideableJumping rideable = Objects.requireNonNull(this.minecraft.player).jumpableVehicle();
        float jumpScale = this.minecraft.player.getJumpRidingScale();
        int fillWidth = (int)(jumpScale * (float)elementWidth);
        if (VanillaLikeJumpMeterElement.isEditor()) {
            fillWidth = 91;
        }
        graphics.blitSprite(JUMP_BAR_BACKGROUND_SPRITE, elementX, elementY, elementWidth, elementHeight);
        if (rideable != null && rideable.getJumpCooldown() > 0 && !VanillaLikeJumpMeterElement.isEditor()) {
            graphics.blitSprite(JUMP_BAR_COOLDOWN_SPRITE, elementX, elementY, elementWidth, elementHeight);
        } else if (fillWidth > 0) {
            graphics.blitSprite(JUMP_BAR_PROGRESS_SPRITE, elementWidth, elementHeight, 0, 0, elementX, elementY, fillWidth, elementHeight);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public int getAbsoluteWidth() {
        return 182;
    }

    public int getAbsoluteHeight() {
        return 5;
    }
}

