/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.mounthealth;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeMountHealthElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation HEART_VEHICLE_CONTAINER_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/vehicle_container");
    private static final ResourceLocation HEART_VEHICLE_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/vehicle_full");
    private static final ResourceLocation HEART_VEHICLE_HALF_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/heart/vehicle_half");
    private final Minecraft minecraft = Minecraft.getInstance();
    protected int tickCount;
    private int barWidth = 100;
    private int barHeight = 100;
    private boolean shouldRenderBar = false;
    public boolean isUsedAsDummy = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeMountHealthElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderVehicleHealth(graphics, 0, 0);
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedBody = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.barWidth, this.barHeight);
        int barRenderX = alignedBody[0];
        int barRenderY = alignedBody[1];
        RenderSystem.enableBlend();
        this.shouldRenderBar = true;
        this.renderVehicleHealth(graphics, barRenderX, barRenderY);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderVehicleHealth(GuiGraphics graphics, int baseX, int baseY) {
        LivingEntity mount = this.getPlayerVehicleWithHealth();
        int totalHearts = mount != null ? this.getVehicleMaxHearts(mount) : 10;
        int currentHealth = (int)Math.ceil(mount != null ? (double)mount.getHealth() : 0.0);
        if (VanillaLikeMountHealthElement.isEditor()) {
            totalHearts = 20;
            currentHealth = 9;
        }
        if (this.isUsedAsDummy) {
            totalHearts = 10;
            currentHealth = 9;
        }
        if (totalHearts == 0) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        int heartsPerRow = 10;
        int fixedRowWidth = 80;
        int totalRows = (int)Math.ceil((double)totalHearts / 10.0);
        int computedBarWidth = 80;
        int computedBarHeight = totalRows * 10;
        this.barWidth = computedBarWidth;
        this.barHeight = computedBarHeight;
        boolean isTopAlignment = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT;
        boolean isRightAlignment = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT;
        boolean mirrorHearts = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED;
        for (int row = 0; row < totalRows; ++row) {
            int naturalRow = row;
            int rowY = isTopAlignment ? naturalRow * 10 : (totalRows - 1 - naturalRow) * 10;
            int heartsThisRow = naturalRow == totalRows - 1 ? totalHearts - (totalRows - 1) * 10 : 10;
            int rowStartX = 0;
            if (!isRightAlignment) {
                rowStartX = this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED ? (80 - heartsThisRow * 8) / 2 : 0;
            }
            for (int col = 0; col < heartsThisRow; ++col) {
                int heartX;
                int effectiveCol;
                if (isRightAlignment) {
                    effectiveCol = heartsThisRow - 1 - col;
                    heartX = baseX + 80 - (effectiveCol + 1) * 8;
                } else {
                    effectiveCol = col;
                    heartX = baseX + rowStartX + effectiveCol * 8;
                }
                int overallHeartIndex = naturalRow * 10 + effectiveCol;
                int heartY = baseY + rowY;
                if (!this.shouldRenderBar) continue;
                if (mirrorHearts) {
                    SpiffyRenderUtils.blitSpriteMirrored(graphics, HEART_VEHICLE_CONTAINER_SPRITE, heartX, heartY, 9, 9);
                } else {
                    graphics.blitSprite(HEART_VEHICLE_CONTAINER_SPRITE, heartX, heartY, 9, 9);
                }
                int heartThreshold = overallHeartIndex * 2 + 1;
                if (heartThreshold < currentHealth) {
                    if (mirrorHearts) {
                        SpiffyRenderUtils.blitSpriteMirrored(graphics, HEART_VEHICLE_FULL_SPRITE, heartX, heartY, 9, 9);
                        continue;
                    }
                    graphics.blitSprite(HEART_VEHICLE_FULL_SPRITE, heartX, heartY, 9, 9);
                    continue;
                }
                if (heartThreshold != currentHealth) continue;
                if (mirrorHearts) {
                    SpiffyRenderUtils.blitSpriteMirrored(graphics, HEART_VEHICLE_HALF_SPRITE, heartX, heartY, 9, 9);
                    continue;
                }
                graphics.blitSprite(HEART_VEHICLE_HALF_SPRITE, heartX, heartY, 9, 9);
            }
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private int getVehicleMaxHearts(@Nullable LivingEntity vehicle) {
        if (vehicle == null || !vehicle.showVehicleHealth()) {
            return 0;
        }
        float maxHealth = vehicle.getMaxHealth();
        int hearts = (int)(maxHealth + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        return hearts;
    }

    @Nullable
    private LivingEntity getPlayerVehicleWithHealth() {
        Entity vehicle;
        Player player = this.getCameraPlayer();
        if (player != null && (vehicle = player.getVehicle()) instanceof LivingEntity) {
            return (LivingEntity)vehicle;
        }
        return null;
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

