/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.scoreboard;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Comparator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeScoreboardElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SPACER = ": ";
    private static final Comparator<PlayerScoreEntry> SCORE_DISPLAY_ORDER = Comparator.comparing(PlayerScoreEntry::value).reversed().thenComparing(PlayerScoreEntry::owner, String.CASE_INSENSITIVE_ORDER);
    private final Minecraft minecraft = Minecraft.getInstance();
    private int sidebarWidth = 100;
    private int sidebarHeight = 100;
    private int sidebarOriginalX = 0;
    private int sidebarOriginalY = 0;
    private boolean renderSidebar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;
    @Nullable
    public DrawableColor customTitleBackgroundColor = null;
    @Nullable
    public DrawableColor customLineBackgroundColor = null;

    public VanillaLikeScoreboardElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        this.renderSidebar = false;
        this.renderScoreboard(graphics, 0, 0, false);
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.sidebarWidth, this.sidebarHeight);
        int offsetX = alignedPosition[0] - this.sidebarOriginalX;
        int offsetY = alignedPosition[1] - this.sidebarOriginalY;
        RenderSystem.enableBlend();
        this.renderSidebar = true;
        this.renderScoreboard(graphics, offsetX, offsetY, true);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderScoreboard(GuiGraphics graphics, int offsetX, int offsetY, boolean applyOffset) {
        Objective objectiveToRender;
        DisplaySlot displaySlot;
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        Scoreboard scoreboard = this.minecraft.level.getScoreboard();
        Objective objective = null;
        PlayerTeam playerTeam = scoreboard.getPlayersTeam(this.minecraft.player.getScoreboardName());
        if (playerTeam != null && (displaySlot = DisplaySlot.teamColorToSlot((ChatFormatting)playerTeam.getColor())) != null) {
            objective = scoreboard.getDisplayObjective(displaySlot);
        }
        Objective objective2 = objectiveToRender = objective != null ? objective : scoreboard.getDisplayObjective(DisplaySlot.SIDEBAR);
        if (VanillaLikeScoreboardElement.isEditor()) {
            objectiveToRender = new DummyObjective(scoreboard);
        }
        if (objectiveToRender != null) {
            this.displayScoreboardSidebar(graphics, objectiveToRender, offsetX, offsetY, applyOffset);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void displayScoreboardSidebar(GuiGraphics guiGraphics, Objective objective, int offsetX, int offsetY, boolean applyOffset) {
        int titleWidth;
        DisplayEntry[] displayEntries;
        Scoreboard scoreboard = objective.getScoreboard();
        Component title = objective.getDisplayName();
        if (VanillaLikeScoreboardElement.isEditor()) {
            title = Component.translatable((String)"spiffyhud.elements.dummy.scoreboard_sidebar.title").withStyle(ChatFormatting.BOLD);
            String dummyLineText = I18n.get((String)"spiffyhud.elements.dummy.scoreboard_sidebar.line", (Object[])new Object[0]);
            displayEntries = new DisplayEntry[6];
            for (int i = 0; i < 6; ++i) {
                MutableComponent name = Component.literal((String)dummyLineText);
                DisplayEntry[] score = Component.literal((String)("" + i));
                displayEntries[i] = new DisplayEntry((Component)name, (Component)score, this.getFont().width((FormattedText)score));
            }
        } else {
            displayEntries = (DisplayEntry[])scoreboard.listPlayerScores(objective).stream().filter(entry -> !entry.isHidden()).sorted(SCORE_DISPLAY_ORDER).limit(15L).map(entry -> {
                PlayerTeam team = scoreboard.getPlayersTeam(entry.owner());
                Component name = entry.ownerName();
                MutableComponent formattedName = PlayerTeam.formatNameForTeam((Team)team, (Component)name);
                MutableComponent scoreText = entry.formatValue(objective.numberFormatOrDefault((NumberFormat)StyledFormat.SIDEBAR_DEFAULT));
                int scoreWidth = this.getFont().width((FormattedText)scoreText);
                return new DisplayEntry((Component)formattedName, (Component)scoreText, scoreWidth);
            }).toArray(DisplayEntry[]::new);
        }
        int maxEntryWidth = titleWidth = this.getFont().width((FormattedText)title);
        int spacerWidth = this.getFont().width(SPACER);
        for (DisplayEntry entry2 : displayEntries) {
            int entryWidth = this.getFont().width((FormattedText)entry2.name) + (entry2.scoreWidth > 0 ? spacerWidth + entry2.scoreWidth : 0);
            maxEntryWidth = Math.max(maxEntryWidth, entryWidth);
        }
        int numberOfLines = displayEntries.length;
        int lineHeight = 9;
        int totalLineHeight = numberOfLines * lineHeight;
        int baseY = VanillaLikeScoreboardElement.getScreenHeight() / 2 + totalLineHeight / 3;
        int baseX = VanillaLikeScoreboardElement.getScreenWidth() - maxEntryWidth - 3;
        int lineBackgroundColor = this.minecraft.options.getBackgroundColor(0.3f);
        if (this.customLineBackgroundColor != null) {
            lineBackgroundColor = this.customLineBackgroundColor.getColorInt();
        }
        int titleBackgroundColor = this.minecraft.options.getBackgroundColor(0.4f);
        if (this.customTitleBackgroundColor != null) {
            titleBackgroundColor = this.customTitleBackgroundColor.getColorInt();
        }
        int topY = baseY - numberOfLines * lineHeight;
        this.sidebarWidth = Math.max(1, maxEntryWidth + 4);
        this.sidebarHeight = Math.max(1, baseY - (topY - lineHeight - 1));
        this.sidebarOriginalX = baseX - 2;
        this.sidebarOriginalY = topY - lineHeight - 1;
        int effectiveBaseX = baseX + (applyOffset ? offsetX : 0);
        int effectiveBaseY = baseY + (applyOffset ? offsetY : 0);
        if (this.renderSidebar) {
            guiGraphics.pose().pushPose();
            int finalLineBackgroundColor = lineBackgroundColor;
            int finalTitleBackgroundColor = titleBackgroundColor;
            int finalMaxEntryWidth = maxEntryWidth;
            Component finalTitle = title;
            guiGraphics.drawManaged(() -> {
                int rightX = VanillaLikeScoreboardElement.getScreenWidth() - 3 + 2 + (applyOffset ? offsetX : 0);
                for (int i = 0; i < displayEntries.length; ++i) {
                    DisplayEntry entry = displayEntries[i];
                    int lineY = effectiveBaseY - (i + 1) * lineHeight;
                    guiGraphics.fill(effectiveBaseX - 2, lineY, rightX, lineY + lineHeight, finalLineBackgroundColor);
                    guiGraphics.drawString(this.getFont(), entry.name, effectiveBaseX, lineY, -1, false);
                    guiGraphics.drawString(this.getFont(), entry.score, rightX - entry.scoreWidth, lineY, -1, false);
                    if (i != displayEntries.length - 1) continue;
                    guiGraphics.fill(effectiveBaseX - 2, lineY - lineHeight - 1, rightX, lineY - 1, finalTitleBackgroundColor);
                    guiGraphics.fill(effectiveBaseX - 2, lineY - 1, rightX, lineY, finalLineBackgroundColor);
                    Font font = this.getFont();
                    int titleX = effectiveBaseX + finalMaxEntryWidth / 2 - titleWidth / 2;
                    guiGraphics.drawString(font, finalTitle, titleX, lineY - lineHeight, -1, false);
                }
            });
            guiGraphics.pose().popPose();
        }
    }

    private Font getFont() {
        return Minecraft.getInstance().font;
    }

    public int getAbsoluteWidth() {
        return this.sidebarWidth;
    }

    public int getAbsoluteHeight() {
        return this.sidebarHeight;
    }

    private static class DummyObjective
    extends Objective {
        public DummyObjective(Scoreboard scoreboard) {
            super(scoreboard, "dummy", ObjectiveCriteria.DUMMY, (Component)Component.literal((String)"Scoreboard"), ObjectiveCriteria.RenderType.INTEGER, false, null);
        }
    }

    private record DisplayEntry(Component name, Component score, int scoreWidth) {
    }
}

