/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.placeholders;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.spiffyhud.mixin.mixins.common.client.IMixinSpectatorGui;
import de.keksuccino.spiffyhud.util.ComponentUtils;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.spectator.SpectatorMenu;
import net.minecraft.client.gui.spectator.SpectatorMenuItem;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotItemDisplayNamePlaceholder
extends Placeholder {
    public SlotItemDisplayNamePlaceholder() {
        super("slot_item_display_name");
    }

    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String slot = (String)dps.values.get("slot");
        boolean ignoreSpectator = SerializationUtils.deserializeBoolean((boolean)false, (String)((String)dps.values.get("ignore_spectator")));
        if (slot != null && MathUtils.isInteger((String)slot) && Minecraft.getInstance().player != null) {
            int slotInt = Integer.parseInt(slot);
            ItemStack stack = Minecraft.getInstance().player.getInventory().getItem(slotInt);
            if (Minecraft.getInstance().player.isSpectator() && slotInt >= 0 && slotInt <= 8 && !ignoreSpectator) {
                IMixinSpectatorGui accessor = (IMixinSpectatorGui)Minecraft.getInstance().gui.getSpectatorGui();
                SpectatorMenu menu = accessor.get_menu_Spiffy();
                if (menu != null) {
                    SpectatorMenuItem spectatorMenuItem = menu.getSelectedItem();
                    MutableComponent mutableComponent = (MutableComponent)(spectatorMenuItem == SpectatorMenu.EMPTY_SLOT ? menu.getSelectedCategory().getPrompt() : spectatorMenuItem.getName());
                    return ComponentUtils.toJson((Component)mutableComponent);
                }
            } else if (!stack.isEmpty()) {
                MutableComponent mutableComponent = Component.empty().append(stack.getHoverName()).withStyle(stack.getRarity().color());
                return ComponentUtils.toJson((Component)mutableComponent);
            }
        }
        return "";
    }

    @Nullable
    public List<String> getValueNames() {
        return List.of("slot", "ignore_spectator");
    }

    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"spiffyhud.placeholders.slot_item_display_name", (Object[])new Object[0]);
    }

    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines((String)"spiffyhud.placeholders.slot_item_display_name.desc", (String[])new String[0]));
    }

    public String getCategory() {
        return I18n.get((String)"fancymenu.placeholders.categories.world", (Object[])new Object[0]);
    }

    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("slot", "slot_number");
        values.put("ignore_spectator", "false");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

