/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util;

import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SpiffyAlignment implements LocalizedCycleEnum<SpiffyAlignment>
{
    TOP_LEFT("top_left"),
    TOP_CENTERED("top_centered"),
    TOP_RIGHT("top_right"),
    BOTTOM_LEFT("bottom_left"),
    BOTTOM_CENTERED("bottom_centered"),
    BOTTOM_RIGHT("bottom_right"),
    MID_LEFT("mid_left"),
    MID_CENTERED("mid_centered"),
    MID_RIGHT("mid_right");

    private final String name;

    private SpiffyAlignment(String name) {
        this.name = name;
    }

    @NotNull
    public String getLocalizationKeyBase() {
        return "spiffyhud.alignment";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Style getValueComponentStyle() {
        return (Style)WARNING_TEXT_STYLE.get();
    }

    @NotNull
    public SpiffyAlignment[] getValues() {
        return SpiffyAlignment.values();
    }

    @Nullable
    public SpiffyAlignment getByNameInternal(@NotNull String name) {
        return SpiffyAlignment.getByName(name);
    }

    @Nullable
    public static SpiffyAlignment getByName(@NotNull String name) {
        for (SpiffyAlignment a : SpiffyAlignment.values()) {
            if (!a.name.equals(name)) continue;
            return a;
        }
        return null;
    }

    public static Integer[] calculateElementBodyPosition(@NotNull SpiffyAlignment spiffyAlignment, int elementX, int elementY, int elementWidth, int elementHeight, int bodyWidth, int bodyHeight) {
        int fixedX = elementX;
        int fixedY = elementY;
        if (spiffyAlignment == TOP_CENTERED) {
            fixedX = fixedX + elementWidth / 2 - bodyWidth / 2;
        } else if (spiffyAlignment == TOP_RIGHT) {
            fixedX = fixedX + elementWidth - bodyWidth;
        } else if (spiffyAlignment == MID_LEFT) {
            fixedY = fixedY + elementHeight / 2 - bodyHeight / 2;
        } else if (spiffyAlignment == MID_CENTERED) {
            fixedX = fixedX + elementWidth / 2 - bodyWidth / 2;
            fixedY = fixedY + elementHeight / 2 - bodyHeight / 2;
        } else if (spiffyAlignment == MID_RIGHT) {
            fixedX = fixedX + elementWidth - bodyWidth;
            fixedY = fixedY + elementHeight / 2 - bodyHeight / 2;
        } else if (spiffyAlignment == BOTTOM_LEFT) {
            fixedY = fixedY + elementHeight - bodyHeight;
        } else if (spiffyAlignment == BOTTOM_CENTERED) {
            fixedX = fixedX + elementWidth / 2 - bodyWidth / 2;
            fixedY = fixedY + elementHeight - bodyHeight;
        } else if (spiffyAlignment == BOTTOM_RIGHT) {
            fixedX = fixedX + elementWidth - bodyWidth;
            fixedY = fixedY + elementHeight - bodyHeight;
        }
        return new Integer[]{fixedX, fixedY};
    }
}

