/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.level;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityNbtUtils {
    @Nullable
    public static String getNbtString(@NotNull Entity entity, @NotNull String path) {
        try {
            CompoundTag entityData = new CompoundTag();
            entity.saveWithoutId(entityData);
            NbtPathArgument.NbtPath nbtPath = NbtPathArgument.nbtPath().parse(new StringReader(path));
            List results = nbtPath.get((Tag)entityData);
            if (results.isEmpty()) {
                return null;
            }
            Tag tag = (Tag)results.get(0);
            if (tag instanceof NumericTag) {
                NumericTag numericTag = (NumericTag)tag;
                if (tag.getAsString().endsWith("d") || tag.getAsString().endsWith("f") || tag.getAsString().endsWith("b") || tag.getAsString().endsWith("s") || tag.getAsString().endsWith("L")) {
                    if (tag.getAsString().contains(".")) {
                        return String.valueOf(numericTag.getAsDouble());
                    }
                    return String.valueOf(numericTag.getAsLong());
                }
            }
            return tag.getAsString();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    @NotNull
    public static List<String> getAllNbtPaths(@NotNull Entity entity) {
        CompoundTag entityData = new CompoundTag();
        entity.saveWithoutId(entityData);
        ArrayList<String> paths = new ArrayList<String>();
        EntityNbtUtils.collectPaths("", (Tag)entityData, paths);
        Collections.sort(paths);
        return paths;
    }

    private static void collectPaths(String prefix, Tag tag, List<String> paths) {
        block10: {
            block11: {
                block9: {
                    if (prefix != null && !prefix.isEmpty()) {
                        paths.add(prefix);
                    }
                    if (!(tag instanceof CompoundTag)) break block9;
                    CompoundTag compound = (CompoundTag)tag;
                    for (String key : compound.getAllKeys()) {
                        String newPrefix = prefix.isEmpty() ? key : prefix + "." + key;
                        EntityNbtUtils.collectPaths(newPrefix, compound.get(key), paths);
                    }
                    break block10;
                }
                if (!(tag instanceof ListTag)) break block11;
                ListTag list = (ListTag)tag;
                for (int i = 0; i < list.size(); ++i) {
                    String newPrefix = prefix + "[" + i + "]";
                    EntityNbtUtils.collectPaths(newPrefix, list.get(i), paths);
                }
                break block10;
            }
            if (!(tag instanceof ByteArrayTag) && !(tag instanceof IntArrayTag) && !(tag instanceof LongArrayTag)) break block10;
            int size = 0;
            if (tag instanceof ByteArrayTag) {
                size = ((ByteArrayTag)tag).getAsByteArray().length;
            } else if (tag instanceof IntArrayTag) {
                size = ((IntArrayTag)tag).getAsIntArray().length;
            } else if (tag instanceof LongArrayTag) {
                size = ((LongArrayTag)tag).getAsLongArray().length;
            }
            for (int i = 0; i < size; ++i) {
                paths.add(prefix + "[" + i + "]");
            }
        }
    }
}

