/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class GuiEntityRenderer {
    private static final float DEFAULT_FACING = 180.0f;
    private static final float MAX_BODY_DELTA = 30.0f;
    private static final float MAX_HEAD_DELTA = 30.0f;
    private float lastOriginalBodyRotation = Float.NaN;
    private float renderedBodyRotation = 180.0f;
    private float lastOriginalHeadRotation = Float.NaN;
    private float renderedHeadRotation = 180.0f;

    public void renderEntity(GuiGraphics graphics, int posX, int posY, int boxWidth, int boxHeight, float opacity, LivingEntity entity) {
        EntityDimensions dimensions = entity.getDimensions(Pose.STANDING);
        float scaleFromWidth = (float)boxWidth / dimensions.width();
        float scaleFromHeight = (float)boxHeight / dimensions.height();
        float uniformScale = Math.min(scaleFromWidth, scaleFromHeight);
        float origYBodyRot = entity.yBodyRot;
        float origYRot = entity.getYRot();
        float origXRot = entity.getXRot();
        float origYHeadRot = entity.yHeadRot;
        float origYHeadRotO = entity.yHeadRotO;
        float currentOriginalBody = origYBodyRot;
        if (Float.isNaN(this.lastOriginalBodyRotation)) {
            this.lastOriginalBodyRotation = currentOriginalBody;
            this.renderedBodyRotation = currentOriginalBody;
        }
        float bodyDelta = Mth.wrapDegrees((float)(currentOriginalBody - this.lastOriginalBodyRotation));
        this.renderedBodyRotation += bodyDelta;
        this.renderedBodyRotation = Mth.clamp((float)this.renderedBodyRotation, (float)150.0f, (float)210.0f);
        this.lastOriginalBodyRotation = currentOriginalBody;
        entity.yBodyRot = this.renderedBodyRotation;
        float currentOriginalHead = origYHeadRot;
        if (Float.isNaN(this.lastOriginalHeadRotation)) {
            this.lastOriginalHeadRotation = currentOriginalHead;
            this.renderedHeadRotation = currentOriginalHead;
        }
        float headDelta = Mth.wrapDegrees((float)(currentOriginalHead - this.lastOriginalHeadRotation));
        float newRenderedHead = this.renderedHeadRotation + headDelta;
        newRenderedHead = Mth.clamp((float)newRenderedHead, (float)(this.renderedBodyRotation - 30.0f), (float)(this.renderedBodyRotation + 30.0f));
        this.lastOriginalHeadRotation = currentOriginalHead;
        this.renderedHeadRotation = newRenderedHead;
        entity.yHeadRot = newRenderedHead;
        entity.yHeadRotO = newRenderedHead;
        entity.setYRot(newRenderedHead);
        graphics.pose().pushPose();
        graphics.pose().translate((double)posX + (double)boxWidth / 2.0, (double)posY + (double)boxHeight / 2.0, 50.0);
        graphics.pose().mulPose(new Matrix4f().scaling(uniformScale, uniformScale, -uniformScale));
        Quaternionf baseRotation = new Quaternionf().rotateZ((float)Math.PI);
        graphics.pose().mulPose(baseRotation);
        graphics.pose().translate(0.0, (double)(-(dimensions.height() / 2.0f)), 0.0);
        Lighting.setupForEntityInInventory();
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, opacity);
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        dispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> dispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, graphics.pose(), (MultiBufferSource)graphics.bufferSource(), 0xF000F0));
        graphics.flush();
        dispatcher.setRenderShadow(true);
        graphics.pose().popPose();
        Lighting.setupFor3DItems();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        entity.yBodyRot = origYBodyRot;
        entity.setYRot(origYRot);
        entity.setXRot(origXRot);
        entity.yHeadRot = origYHeadRot;
        entity.yHeadRotO = origYHeadRotO;
    }
}

