/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class SpiffyRenderUtils {
    private static boolean blendLocked = false;

    public static void lockBlend(boolean lock) {
        blendLocked = true;
    }

    public static boolean isBlendLocked() {
        return blendLocked;
    }

    public static void blitMirrored(GuiGraphics graphics, ResourceLocation atlasLocation, int x, int y, int blitOffset, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        float minU = (float)(u + width) / (float)textureWidth;
        float maxU = (float)u / (float)textureWidth;
        float minV = (float)v / (float)textureHeight;
        float maxV = (float)(v + height) / (float)textureHeight;
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, (float)x, (float)y, (float)blitOffset).setUv(minU, minV);
        bufferBuilder.addVertex(matrix, (float)x, (float)(y + height), (float)blitOffset).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix, (float)(x + width), (float)(y + height), (float)blitOffset).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix, (float)(x + width), (float)y, (float)blitOffset).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void blitSpriteMirrored(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        TextureAtlasSprite atlasSprite = Minecraft.getInstance().getGuiSprites().getSprite(sprite);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasSprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        float minU = atlasSprite.getU1();
        float maxU = atlasSprite.getU0();
        float minV = atlasSprite.getV0();
        float maxV = atlasSprite.getV1();
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv(minU, minV);
        bufferBuilder.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

