/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ObjectHolder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.gui.Renderable;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import de.keksuccino.spiffyhud.customization.elements.Elements;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.air.VanillaLikePlayerAirElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.armor.VanillaLikePlayerArmorElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.bossbars.VanillaLikeBossOverlayElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.effects.VanillaLikeEffectsElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.experience.VanillaLikeExperienceElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.food.VanillaLikePlayerFoodElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.hotbar.VanillaLikeHotbarElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.jumpmeter.VanillaLikeJumpMeterElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.mounthealth.VanillaLikeMountHealthElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.playerhealth.VanillaLikePlayerHealthElement;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SpiffyOverlayScreen
extends ModernScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static final VanillaLikeHotbarElement HOTBAR_ELEMENT = Elements.VANILLA_LIKE_HOTBAR.buildDefaultInstance();
    private static final VanillaLikeJumpMeterElement JUMP_METER_ELEMENT = Elements.VANILLA_LIKE_JUMP_METER.buildDefaultInstance();
    private static final VanillaLikeExperienceElement EXPERIENCE_ELEMENT = Elements.VANILLA_LIKE_EXPERIENCE.buildDefaultInstance();
    private static final VanillaLikePlayerFoodElement FOOD_ELEMENT = Elements.VANILLA_LIKE_PLAYER_FOOD.buildDefaultInstance();
    private static final VanillaLikePlayerArmorElement ARMOR_ELEMENT = Elements.VANILLA_LIKE_PLAYER_ARMOR.buildDefaultInstance();
    private static final VanillaLikePlayerAirElement AIR_ELEMENT = Elements.VANILLA_LIKE_PLAYER_AIR.buildDefaultInstance();
    private static final VanillaLikeMountHealthElement MOUNT_HEALTH_ELEMENT = Elements.VANILLA_LIKE_MOUNT_HEALTH.buildDefaultInstance();
    private static final VanillaLikePlayerHealthElement PLAYER_HEALTH_ELEMENT = Elements.VANILLA_LIKE_PLAYER_HEALTH.buildDefaultInstance();
    private static final VanillaLikeBossOverlayElement BOSS_OVERLAY_ELEMENT = Elements.VANILLA_LIKE_BOSS_OVERLAY.buildDefaultInstance();
    private static final VanillaLikeEffectsElement EFFECTS_ELEMENT = Elements.VANILLA_LIKE_EFFECTS.buildDefaultInstance();
    public final boolean showFancyMenuOverlay;
    protected final Font font;
    protected final Minecraft minecraft;

    public SpiffyOverlayScreen(boolean showFancyMenuOverlay) {
        super((Component)Component.m_237119_());
        this.font = Minecraft.m_91087_().f_91062_;
        this.minecraft = Minecraft.m_91087_();
        this.forceEnableCustomizations();
        this.showFancyMenuOverlay = showFancyMenuOverlay;
    }

    protected void forceEnableCustomizations() {
        if (!ScreenCustomization.isCustomizationEnabledForScreen((Screen)this)) {
            LOGGER.info("[SPIFFY HUD] Force-enabling customizations for SpiffyOverlayScreen..");
            ScreenCustomization.setCustomizationForScreenEnabled((Screen)this, (boolean)true);
        }
    }

    protected void m_7856_() {
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildHotbarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.hotbar"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildJumpMeterWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.jump_meter"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildExperienceBarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.experience_bar"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildSelectedItemNameWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.selected_item_name"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildScoreboardSidebarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.scoreboard_sidebar"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildFoodBarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.food_bar"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildArmorBarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.armor_bar"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildAirBarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.air_bar"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildHealthBarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.health_bar"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildMountHealthBarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.mount_health_bar"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildOverlayMessageWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.overlay_message"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildCrosshairWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.crosshair"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildAttackIndicatorWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.attack_indicator"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildTitleWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.title"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildSubtitleWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.subtitle"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildBossBarWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.boss_bars"));
        ((RendererWidget)this.m_142416_((GuiEventListener)this.buildEffectsWidget())).m_93666_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.effects"));
    }

    public void render(@NotNull GuiGraphics $$0, int $$1, int $$2, float $$3) {
        if (!(Minecraft.m_91087_().f_91080_ instanceof LayoutEditorScreen)) {
            return;
        }
        this.m_6702_().forEach(guiEventListener -> {
            if (guiEventListener instanceof Renderable) {
                Renderable renderable = (Renderable)guiEventListener;
                renderable.render($$0, $$1, $$2, $$3);
            } else if (guiEventListener instanceof Widget) {
                Widget w = (Widget)guiEventListener;
                w.m_6305_($$0.pose(), $$1, $$2, $$3);
            }
        });
    }

    public void renderBackground(@NotNull GuiGraphics $$0) {
    }

    protected RendererWidget buildHotbarWidget() {
        int screenCenter = this.f_96543_ / 2;
        int x = screenCenter - 91;
        int y = this.f_96544_ - 22;
        int widgetWidth = 182;
        int widgetHeight = 22;
        return new SpiffyRendererWidget(x, y, widgetWidth, widgetHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.HOTBAR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.HOTBAR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.HOTBAR_ELEMENT.posOffsetY = gy - 2;
            HOTBAR_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_hotbar_dummy");
    }

    protected RendererWidget buildJumpMeterWidget() {
        int screenCenter = this.f_96543_ / 2;
        int x = screenCenter - 91;
        int y = this.f_96544_ - 32 + 3 - 5;
        int width = 182;
        int height = 5;
        return new SpiffyRendererWidget(x, y, width, height, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.JUMP_METER_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.JUMP_METER_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.JUMP_METER_ELEMENT.posOffsetY = gy;
            JUMP_METER_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_jump_meter_dummy");
    }

    protected RendererWidget buildExperienceBarWidget() {
        int screenCenter = this.f_96543_ / 2;
        int x = screenCenter - 91;
        int y = this.f_96544_ - 32 + 3;
        int width = 182;
        int height = 5;
        return new SpiffyRendererWidget(x, y, width, height, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.EXPERIENCE_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.EXPERIENCE_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.EXPERIENCE_ELEMENT.posOffsetY = gy;
            EXPERIENCE_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_experience_bar_dummy");
    }

    protected RendererWidget buildSelectedItemNameWidget() {
        MutableComponent mutableComponent = Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"spiffyhud.elements.dummy.selected_item_name")).m_130940_(ChatFormatting.LIGHT_PURPLE);
        int textWidth = this.font.m_92852_((FormattedText)mutableComponent);
        int textX = (this.f_96543_ - textWidth) / 2;
        int textY = this.f_96544_ - 59 - 18;
        Objects.requireNonNull(this.font);
        return new SpiffyRendererWidget(textX, textY, textWidth, 9, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            RenderSystem.m_69478_();
            Objects.requireNonNull(this.font);
            graphics.fill(textX - 2, textY - 2, textX + textWidth + 2, textY + 9 + 2, Minecraft.m_91087_().f_91066_.m_92143_(0));
            graphics.drawString(this.font, (Component)mutableComponent, textX, textY, -1);
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        }).setWidgetIdentifierFancyMenu("spiffy_selected_item_name_dummy");
    }

    protected RendererWidget buildScoreboardSidebarWidget() {
        int titleWidth;
        String spacer = ": ";
        ArrayList<DisplayEntry> entryList = new ArrayList<DisplayEntry>();
        MutableComponent name = Component.m_237115_((String)"spiffyhud.elements.dummy.scoreboard_sidebar.line");
        MutableComponent score = Component.m_237113_((String)"0").m_130940_(ChatFormatting.RED);
        int scoreWidth = this.font.m_92852_((FormattedText)score);
        record DisplayEntry(Component name, Component score, int scoreWidth) {
        }
        entryList.add(new DisplayEntry((Component)Component.m_237119_(), (Component)Component.m_237119_(), scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        DisplayEntry[] entries = entryList.toArray(new DisplayEntry[0]);
        MutableComponent title = Component.m_237115_((String)"spiffyhud.elements.dummy.scoreboard_sidebar.title").m_130940_(ChatFormatting.BOLD);
        int totalSidebarWidth = titleWidth = this.font.m_92852_((FormattedText)title);
        int spacerWidth = this.font.m_92895_(spacer);
        for (DisplayEntry entry : entries) {
            totalSidebarWidth = Math.max(totalSidebarWidth, this.font.m_92852_((FormattedText)entry.name) + (entry.scoreWidth > 0 ? spacerWidth + entry.scoreWidth : 0));
        }
        int linesCount = entries.length;
        Objects.requireNonNull(this.font);
        int linesHeight = linesCount * 9;
        int sidebarYEnd = this.f_96544_ / 2 + linesHeight / 3;
        int sidebarXStart = this.f_96543_ - totalSidebarWidth - 3;
        int sidebarXEnd = this.f_96543_ - 3 + 2;
        int backgroundColorNormal = this.minecraft.f_91066_.m_92170_(0.3f);
        int backgroundColorTitle = this.minecraft.f_91066_.m_92170_(0.4f);
        Objects.requireNonNull(this.font);
        int sidebarYBase = sidebarYEnd - linesCount * 9;
        int finalTotalSidebarWidth = totalSidebarWidth;
        Objects.requireNonNull(this.font);
        int sidebarY = sidebarYBase - 9 - 1;
        int sidebarHeight = Math.max(1, sidebarYEnd - sidebarY);
        return new SpiffyRendererWidget(sidebarXStart, sidebarY, totalSidebarWidth, sidebarHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildScoreboardSidebarWidget$5(sidebarXStart, sidebarYBase, sidebarXEnd, backgroundColorTitle, sidebarYEnd, backgroundColorNormal, (Component)title, finalTotalSidebarWidth, titleWidth, linesCount, entries, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_scoreboard_sidebar_dummy");
    }

    protected RendererWidget buildFoodBarWidget() {
        int barX = this.f_96543_ / 2 + 91;
        int barY = this.f_96544_ - 39 - 5;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.FOOD_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.FOOD_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.FOOD_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.FOOD_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            FOOD_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_food_bar_dummy");
    }

    protected RendererWidget buildArmorBarWidget() {
        int barX = this.f_96543_ / 2 - 91;
        int barY = this.f_96544_ - 39 - 10 - 5;
        return new SpiffyRendererWidget(barX, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.ARMOR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.ARMOR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.ARMOR_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.ARMOR_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_LEFT;
            ARMOR_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_armor_bar_dummy");
    }

    protected RendererWidget buildAirBarWidget() {
        int barX = this.f_96543_ / 2 + 91;
        int barY = this.f_96544_ - 39 - 10 - 5;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.AIR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.AIR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.AIR_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.AIR_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            AIR_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_air_bar_dummy");
    }

    protected RendererWidget buildMountHealthBarWidget() {
        int barX = this.f_96543_ / 2 + 91;
        int barY = this.f_96544_ - 39 - 10 - 15;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.isUsedAsDummy = true;
            MOUNT_HEALTH_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_mount_health_bar_dummy");
    }

    protected RendererWidget buildHealthBarWidget() {
        int barX = this.f_96543_ / 2 - 91;
        int barY = this.f_96544_ - 39 - 5;
        return new SpiffyRendererWidget(barX, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_LEFT;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.isUsedAsDummy = true;
            PLAYER_HEALTH_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_health_bar_dummy");
    }

    protected RendererWidget buildOverlayMessageWidget() {
        MutableComponent message = Component.m_237113_((String)"Overlay Message");
        int messageWidth = this.font.m_92852_((FormattedText)message);
        int textX = this.f_96543_ / 2 - messageWidth / 2;
        int textY = this.f_96544_ - 68 - 4 - 18;
        ObjectHolder animatedTickHolder = ObjectHolder.of((Object)Float.valueOf(0.0f));
        Objects.requireNonNull(this.font);
        return new SpiffyRendererWidget(textX - 2, textY - 2, messageWidth + 4, 9 + 4, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> SpiffyOverlayScreen.lambda$buildOverlayMessageWidget$11(animatedTickHolder, (Component)message, textX, textY, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_overlay_message_dummy");
    }

    protected RendererWidget buildCrosshairWidget() {
        int crosshairX = (this.f_96543_ - 15) / 2;
        int crosshairY = (this.f_96544_ - 15) / 2;
        return new SpiffyRendererWidget(crosshairX, crosshairY, 15, 15, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            graphics.blit(GUI_ICONS_LOCATION, crosshairX, crosshairY, 0.0f, 0.0f, 15, 15, 256, 256);
            RenderSystem.m_69453_();
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        }).setWidgetIdentifierFancyMenu("spiffy_crosshair_dummy");
    }

    protected RendererWidget buildAttackIndicatorWidget() {
        int crossX = this.f_96543_ / 2 + 1;
        int crossY = this.f_96544_ / 2 - 7 + 16 + 40;
        int hotX = crossX - 2 - 18;
        int hotY = crossY - 6;
        float progress = 0.5f;
        return new SpiffyRendererWidget(hotX, hotY, 36, 18, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            RenderSystem.m_69478_();
            int l = (int)(progress * 17.0f);
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            graphics.blit(GUI_ICONS_LOCATION, crossX, crossY, 36, 94, 16, 4);
            graphics.blit(GUI_ICONS_LOCATION, crossX, crossY, 52, 94, l, 4);
            RenderSystem.m_69453_();
            RenderSystem.m_69478_();
            int p = (int)(progress * 19.0f);
            graphics.blit(GUI_ICONS_LOCATION, hotX, hotY, 0, 94, 18, 18);
            graphics.blit(GUI_ICONS_LOCATION, hotX, hotY + 18 - p, 18, 112 - p, 18, p);
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        }).setWidgetIdentifierFancyMenu("spiffy_attack_indicator_dummy");
    }

    protected RendererWidget buildTitleWidget() {
        MutableComponent title = Component.m_237115_((String)"spiffyhud.elements.dummy.title");
        int titleWidth = this.font.m_92852_((FormattedText)title);
        int totalWidth = titleWidth * 4;
        Objects.requireNonNull(this.font);
        int totalHeight = 9 * 4;
        int textX = this.f_96543_ / 2 - totalWidth / 2;
        int textY = this.f_96544_ / 2 - 48;
        return new SpiffyRendererWidget(textX, textY, totalWidth, totalHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildTitleWidget$14((Component)title, titleWidth, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_title_dummy");
    }

    protected RendererWidget buildSubtitleWidget() {
        MutableComponent subtitle = Component.m_237113_((String)"Subtitle");
        int subtitleWidth = this.font.m_92852_((FormattedText)subtitle);
        int totalWidth = subtitleWidth * 2;
        Objects.requireNonNull(this.font);
        int totalHeight = 9 * 2;
        int textX = this.f_96543_ / 2 - totalWidth / 2;
        int textY = this.f_96544_ / 2 + 12;
        return new SpiffyRendererWidget(textX, textY, totalWidth, totalHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildSubtitleWidget$15((Component)subtitle, subtitleWidth, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_subtitle_dummy");
    }

    protected RendererWidget buildBossBarWidget() {
        int barX = this.f_96543_ / 2 - 91;
        int barY = 12;
        int totalY = barY - 9;
        int totalHeight = 53;
        return new SpiffyRendererWidget(barX, totalY, 182, totalHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.spiffyAlignment = SpiffyAlignment.TOP_CENTERED;
            BOSS_OVERLAY_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_boss_bars_dummy");
    }

    protected RendererWidget buildEffectsWidget() {
        return new SpiffyRendererWidget(this.f_96543_ - 50 - 1, 1, 50, 50, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.EFFECTS_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.spiffyAlignment = SpiffyAlignment.TOP_RIGHT;
            EFFECTS_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_effects_dummy");
    }

    private /* synthetic */ void lambda$buildSubtitleWidget$15(Component subtitle, int subtitleWidth, GuiGraphics graphics, int mX, int mY, float partial, int gx, int gy, int gwidth, int gheight, RendererWidget widget) {
        RenderSystem.m_69478_();
        graphics.pose().m_85836_();
        graphics.pose().m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ / 2), 0.0);
        graphics.pose().m_85836_();
        graphics.pose().m_85841_(2.0f, 2.0f, 2.0f);
        graphics.drawString(Minecraft.m_91087_().f_91062_, subtitle, -subtitleWidth / 2, 6, 0xFFFFFF);
        graphics.pose().m_85849_();
        graphics.pose().m_85849_();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private /* synthetic */ void lambda$buildTitleWidget$14(Component title, int titleWidth, GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y, int width, int height, RendererWidget widget) {
        RenderSystem.m_69478_();
        graphics.pose().m_85836_();
        graphics.pose().m_85837_((double)((float)this.f_96543_ / 2.0f), (double)((float)this.f_96544_ / 2.0f), 0.0);
        RenderSystem.m_69478_();
        graphics.pose().m_85836_();
        graphics.pose().m_85841_(4.0f, 4.0f, 4.0f);
        graphics.drawString(this.font, title, -titleWidth / 2, -12, -1);
        graphics.pose().m_85849_();
        graphics.pose().m_85849_();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private static /* synthetic */ void lambda$buildOverlayMessageWidget$11(ObjectHolder animatedTickHolder, Component message, int textX, int textY, GuiGraphics graphics, int mX, int mY, float partial, int gx, int gy, int gwidth, int gheight, RendererWidget widget) {
        RenderSystem.m_69478_();
        animatedTickHolder.set((Object)Float.valueOf(((Float)animatedTickHolder.get()).floatValue() + 0.005f));
        int animatedTextColor = Mth.m_14169_((float)Mth.m_14036_((float)(((Float)animatedTickHolder.get()).floatValue() % 1.0f), (float)0.0f, (float)1.0f), (float)0.7f, (float)0.6f) | 0xFF000000;
        graphics.drawString(Minecraft.m_91087_().f_91062_, message, textX, textY, animatedTextColor);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private /* synthetic */ void lambda$buildScoreboardSidebarWidget$5(int sidebarXStart, int sidebarYBase, int sidebarXEnd, int backgroundColorTitle, int sidebarYEnd, int backgroundColorNormal, Component title, int finalTotalSidebarWidth, int titleWidth, int linesCount, 1DisplayEntry[] entries, GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y, int width, int height, RendererWidget widget) {
        RenderSystem.m_69478_();
        Objects.requireNonNull(this.font);
        graphics.fill(sidebarXStart - 2, sidebarYBase - 9 - 1, sidebarXEnd, sidebarYBase - 1, backgroundColorTitle);
        graphics.fill(sidebarXStart - 2, sidebarYBase - 1, sidebarXEnd, sidebarYEnd, backgroundColorNormal);
        int n = sidebarXStart + finalTotalSidebarWidth / 2 - titleWidth / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, title, n, sidebarYBase - 9, -1, false);
        for (int t = 0; t < linesCount; ++t) {
            DisplayEntry entry = entries[t];
            Objects.requireNonNull(this.font);
            int u = sidebarYEnd - (linesCount - t) * 9;
            graphics.drawString(this.font, entry.name, sidebarXStart, u, -1, false);
            graphics.drawString(this.font, entry.score, sidebarXEnd - entry.scoreWidth, u, -1, false);
        }
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    public static class SpiffyRendererWidget
    extends RendererWidget {
        public SpiffyRendererWidget(int x, int y, int width, int height, @NotNull SpiffyRendererWidgetBody body) {
            super(x, y, width, height, (RendererWidget.RendererWidgetBody)body);
        }

        public void render(@NotNull GuiGraphics $$0, int $$1, int $$2, float $$3) {
            if (!(Minecraft.m_91087_().f_91080_ instanceof LayoutEditorScreen)) {
                return;
            }
            super.m_6305_($$0.pose(), $$1, $$2, $$3);
        }

        @Deprecated
        public final void m_6305_(PoseStack $$0, int $$1, int $$2, float $$3) {
            this.render(GuiGraphics.currentGraphics(), $$1, $$2, $$3);
        }
    }

    @FunctionalInterface
    public static interface SpiffyRendererWidgetBody
    extends RendererWidget.RendererWidgetBody {
    }
}

