/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.actions.marker;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.customization.actions.marker.MarkerActionConfig;
import de.keksuccino.spiffyhud.customization.actions.marker.MarkerEditorScreen;
import de.keksuccino.spiffyhud.customization.marker.MarkerStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMarkerAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public AddMarkerAction() {
        super("spiffyhud_add_marker");
    }

    public boolean hasValue() {
        return true;
    }

    public void execute(@Nullable String value) {
        MarkerActionConfig config = MarkerActionConfig.parse(value);
        if (config == null) {
            LOGGER.error("[SPIFFYHUD] AddMarkerAction received malformed configuration.");
            return;
        }
        if (!config.hasValidTarget() || !config.hasValidMarkerName()) {
            LOGGER.error("[SPIFFYHUD] AddMarkerAction requires a target element identifier and display name.");
            return;
        }
        boolean success = MarkerStorage.addMarker(config.targetElementIdentifier, config.toMarkerData());
        if (!success) {
            LOGGER.error("[SPIFFYHUD] Failed to add marker '{}' to group '{}'.", (Object)config.uniqueMarkerName, (Object)config.targetElementIdentifier);
        }
    }

    @NotNull
    public Component getActionDisplayName() {
        return Component.m_237115_((String)"spiffyhud.actions.add_marker");
    }

    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.actions.add_marker.desc", (String[])new String[0]);
    }

    public Component getValueDisplayName() {
        return Component.m_237119_();
    }

    public String getValueExample() {
        return MarkerActionConfig.defaultConfig().serialize();
    }

    public void editValue(@NotNull Screen parentScreen, @NotNull ActionInstance instance) {
        MarkerActionConfig config = MarkerActionConfig.parse(instance.value);
        if (config == null) {
            config = MarkerActionConfig.defaultConfig();
        }
        MarkerEditorScreen screen = new MarkerEditorScreen((Component)Component.m_237115_((String)"spiffyhud.actions.add_marker.editor"), config, serialized -> {
            if (serialized != null) {
                instance.value = serialized;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }
}

