/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.overlayremover;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.overlayremover.OverlayRemoverEditorElement;
import de.keksuccino.spiffyhud.customization.elements.overlayremover.OverlayRemoverElement;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayRemoverElementBuilder
extends ElementBuilder<OverlayRemoverElement, OverlayRemoverEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public OverlayRemoverElementBuilder() {
        super("spiffy_overlay_remover");
    }

    @NotNull
    public OverlayRemoverElement buildDefaultInstance() {
        OverlayRemoverElement i = new OverlayRemoverElement(this);
        i.baseWidth = 100;
        i.baseHeight = 100;
        i.inEditorColor = DrawableColor.of((Color)new Color(137, 168, 50));
        return i;
    }

    public OverlayRemoverElement deserializeElement(@NotNull SerializedElement serialized) {
        OverlayRemoverElement element = this.buildDefaultInstance();
        element.overlayType = Objects.requireNonNullElse(OverlayRemoverElement.OverlayType.getByName(Objects.requireNonNullElse(serialized.getValue("overlay_type"), OverlayRemoverElement.OverlayType.VIGNETTE.getName())), element.overlayType);
        return element;
    }

    protected SerializedElement serializeElement(@NotNull OverlayRemoverElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("overlay_type", element.overlayType.getName());
        return serializeTo;
    }

    @NotNull
    public OverlayRemoverEditorElement wrapIntoEditorElement(@NotNull OverlayRemoverElement element, @NotNull LayoutEditorScreen editor) {
        return new OverlayRemoverEditorElement(element, editor);
    }

    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.m_237115_((String)"spiffyhud.elements.overlay_remover");
    }

    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.overlay_remover.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

