/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.playerfoodbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerFoodBarElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_SCALE_STRING = "1.0";
    private static final float DEFAULT_SCALE = 1.0f;
    private static final float MIN_SCALE = 0.2f;
    private static final float MAX_SCALE = 70.0f;
    private static final int BASE_ICON_PIXEL_SIZE = 8;
    private static final int BASE_SLOT_COUNT = 10;
    private static final long BLINK_DURATION_MS = 650L;
    private static final long EDITOR_PREVIEW_INTERVAL_MS = 10000L;
    private static final FoodVisualStyle[] EDITOR_PREVIEW_STYLES = FoodVisualStyle.values();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final RandomSource shakeRandom = RandomSource.m_216327_();
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;
    public int iconsPerRow = 10;
    public int iconGap = 1;
    @NotNull
    public String scaleMultiplier = "1.0";
    public boolean blinkOnLoss = true;
    public boolean lowFoodShakeEnabled = true;
    public int lowFoodShakeThresholdIcons = 4;
    private final EnumMap<FoodTextureKind, ResourceSupplier<ITexture>> customTextures = new EnumMap(FoodTextureKind.class);
    private float lastRecordedFood = -1.0f;
    private int cachedTickCount = 0;
    private final Map<Integer, BlinkState> activeBlinkSlots = new HashMap<Integer, BlinkState>();

    public PlayerFoodBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.stickyAnchor = true;
        this.stayOnScreen = false;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.cachedTickCount = this.safeTickCount();
        PlayerData data = this.collectPlayerData();
        float scale = this.resolveScale();
        RenderMetrics metrics = this.computeMetrics(scale);
        this.baseWidth = Math.max(1, metrics.bodyWidth);
        this.baseHeight = Math.max(1, metrics.bodyHeight);
        this.updateBlinkState(data.currentFood);
        if (!this.shouldRender()) {
            return;
        }
        Integer[] aligned = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), metrics.bodyWidth, metrics.bodyHeight);
        RenderSystem.m_69478_();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        this.drawFood(graphics, aligned[0], aligned[1], data, metrics, scale);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void drawFood(@NotNull GuiGraphics graphics, int originX, int originY, @NotNull PlayerData data, @NotNull RenderMetrics metrics, float scale) {
        PoseStack pose = graphics.pose();
        pose.m_85836_();
        pose.m_85837_((double)originX, (double)originY, 0.0);
        long now = System.currentTimeMillis();
        boolean shake = this.shouldShake(data.currentFood);
        float shakeStrengthBase = shake ? 0.9f : 0.0f;
        int totalSlots = metrics.totalSlots;
        for (int logicalIndex = totalSlots - 1; logicalIndex >= 0; --logicalIndex) {
            SlotPlacement placement = this.computeSlotPlacement(logicalIndex, metrics);
            FoodTextureKind textureKind = this.resolveTextureKind(logicalIndex, data, now);
            float appliedShake = shakeStrengthBase > 0.0f && textureKind != FoodTextureKind.EMPTY ? shakeStrengthBase : 0.0f;
            this.renderSingleIcon(graphics, metrics, placement, logicalIndex, textureKind, appliedShake, scale);
        }
        pose.m_85849_();
    }

    private FoodTextureKind resolveTextureKind(int logicalIndex, @NotNull PlayerData data, long now) {
        BlinkState blink = this.activeBlinkSlots.get(logicalIndex);
        if (blink != null) {
            if (now < blink.endTimeMs) {
                FoodTextureKind previousTexture = this.textureFromFill(blink.previousFill, data.visualStyle);
                if (previousTexture == FoodTextureKind.EMPTY) {
                    previousTexture = data.visualStyle.halfTexture;
                }
                return now / 120L % 2L == 0L ? previousTexture : FoodTextureKind.EMPTY;
            }
            this.activeBlinkSlots.remove(logicalIndex);
        }
        float displayedFood = data.currentFood;
        float slotLowerBound = (float)logicalIndex * 2.0f;
        float fillValue = displayedFood - slotLowerBound;
        return this.textureFromFill(fillValue, data.visualStyle);
    }

    private void renderSingleIcon(@NotNull GuiGraphics graphics, @NotNull RenderMetrics metrics, @NotNull SlotPlacement placement, int logicalIndex, @NotNull FoodTextureKind textureKind, float shakeStrengthBase, float scale) {
        float gap = this.iconGap;
        float baseSpacingX = ((float)metrics.baseIconSize + gap) * scale;
        float baseSpacingY = ((float)metrics.baseIconSize + gap) * scale;
        float baseX = (float)placement.column * baseSpacingX;
        float baseY = (float)placement.row * baseSpacingY;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (shakeStrengthBase > 0.0f && textureKind != FoodTextureKind.EMPTY) {
            float[] offsets = this.computeShakeOffset(logicalIndex, shakeStrengthBase);
            offsetX = offsets[0];
            offsetY = offsets[1];
        }
        PoseStack pose = graphics.pose();
        pose.m_85836_();
        pose.m_85837_((double)(baseX + offsetX), (double)(baseY + offsetY), 0.0);
        pose.m_85841_(scale, scale, 1.0f);
        this.drawFoodTexture(graphics, textureKind, metrics.baseIconSize);
        pose.m_85849_();
    }

    private float[] computeShakeOffset(int logicalIndex, float shakeStrengthBase) {
        this.shakeRandom.m_188584_((long)this.cachedTickCount * 341873128712L + (long)logicalIndex * 132897987541L);
        float dx = (this.shakeRandom.m_188501_() - 0.5f) * shakeStrengthBase;
        float dy = (this.shakeRandom.m_188501_() - 0.5f) * shakeStrengthBase;
        return new float[]{dx, dy};
    }

    private void drawFoodTexture(@NotNull GuiGraphics graphics, @NotNull FoodTextureKind kind, int size) {
        ResourceSupplier<ITexture> supplier = this.customTextures.get((Object)kind);
        if (supplier != null) {
            try {
                ITexture texture = (ITexture)supplier.get();
                if (texture != null && texture.isReady() && texture.getResourceLocation() != null) {
                    RenderSystem.m_69478_();
                    graphics.blit(texture.getResourceLocation(), 0, 0, 0.0f, 0.0f, size, size, size, size);
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.error("[SpiffyHUD] Failed to draw food texture {}", (Object)kind.name(), (Object)ex);
            }
        }
        graphics.fill(0, 0, size, size, this.applyOpacity(kind.defaultColor));
    }

    private int applyOpacity(int argb) {
        int alpha = argb >>> 24 & 0xFF;
        int rgb = argb & 0xFFFFFF;
        int adjustedAlpha = (int)Math.max(0.0f, Math.min(255.0f, (float)alpha * this.opacity));
        return adjustedAlpha << 24 | rgb;
    }

    private RenderMetrics computeMetrics(float scale) {
        int totalSlots = 10;
        int perRow = Math.max(1, this.iconsPerRow);
        int rowSize = Math.min(perRow, totalSlots);
        int rows = Math.max(1, (int)Math.ceil((double)totalSlots / (double)perRow));
        int gap = Math.max(0, this.iconGap);
        float scaledWidth = (float)(rowSize * 8) * scale + (float)(Math.max(0, rowSize - 1) * gap) * scale;
        float scaledHeight = (float)(rows * 8) * scale + (float)(Math.max(0, rows - 1) * gap) * scale;
        int bodyWidth = Math.max(1, Mth.m_14167_((float)scaledWidth));
        int bodyHeight = Math.max(1, Mth.m_14167_((float)scaledHeight));
        return new RenderMetrics(perRow, 8, totalSlots, bodyWidth, bodyHeight, rows, gap, gap);
    }

    private void updateBlinkState(float currentFood) {
        long now = System.currentTimeMillis();
        this.cleanupExpiredBlinks(now);
        if (!this.blinkOnLoss) {
            this.activeBlinkSlots.clear();
            this.lastRecordedFood = currentFood;
            return;
        }
        if (this.lastRecordedFood < 0.0f) {
            this.lastRecordedFood = currentFood;
            return;
        }
        if (currentFood < this.lastRecordedFood - 0.01f) {
            this.registerBlinkSlots(this.lastRecordedFood, currentFood, now);
        } else if (currentFood > this.lastRecordedFood + 0.01f) {
            this.activeBlinkSlots.clear();
        }
        this.lastRecordedFood = currentFood;
    }

    private boolean shouldShake(float currentFood) {
        if (!this.lowFoodShakeEnabled) {
            return false;
        }
        if (this.lowFoodShakeThresholdIcons <= 0) {
            return false;
        }
        float threshold = (float)this.lowFoodShakeThresholdIcons * 2.0f;
        return currentFood <= threshold;
    }

    private int safeTickCount() {
        try {
            return SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private PlayerData collectPlayerData() {
        if (PlayerFoodBarElement.isEditor()) {
            FoodVisualStyle style = this.pickEditorPreviewStyle();
            return new PlayerData(13.0f, style);
        }
        LocalPlayer player = this.minecraft.f_91074_;
        if (player == null) {
            return new PlayerData(10.0f, FoodVisualStyle.NORMAL);
        }
        FoodData foodData = player.m_36324_();
        float currentFood = foodData != null ? (float)foodData.m_38702_() : 0.0f;
        FoodVisualStyle style = player.m_21023_(MobEffects.f_19612_) ? FoodVisualStyle.HUNGER : FoodVisualStyle.NORMAL;
        return new PlayerData(Math.max(0.0f, Math.min(20.0f, currentFood)), style);
    }

    private float resolveScale() {
        String raw = this.scaleMultiplier;
        if (raw == null || raw.isBlank()) {
            return 1.0f;
        }
        String replaced = PlaceholderParser.replacePlaceholders((String)raw).trim();
        if (MathUtils.isFloat((String)replaced)) {
            try {
                float parsed = Float.parseFloat(replaced);
                if (!Float.isFinite(parsed)) {
                    return 1.0f;
                }
                return Mth.m_14036_((float)parsed, (float)0.2f, (float)70.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0f;
    }

    private FoodTextureKind textureFromFill(float fillValue, @NotNull FoodVisualStyle style) {
        if (fillValue >= 2.0f) {
            return style.fullTexture;
        }
        if (fillValue > 0.0f) {
            return style.halfTexture;
        }
        return FoodTextureKind.EMPTY;
    }

    private void registerBlinkSlots(float previousFood, float currentFood, long now) {
        for (int slot = 0; slot < 10; ++slot) {
            float newFill;
            float prevFill = this.fillForSlot(previousFood, slot);
            if (!(prevFill > (newFill = this.fillForSlot(currentFood, slot)) + 0.01f) || !(prevFill > 0.0f)) continue;
            this.activeBlinkSlots.put(slot, new BlinkState(prevFill, now + 650L));
        }
    }

    private float fillForSlot(float value, int slot) {
        float slotLowerBound = (float)slot * 2.0f;
        return Mth.m_14036_((float)(value - slotLowerBound), (float)0.0f, (float)2.0f);
    }

    private void cleanupExpiredBlinks(long now) {
        Iterator<Map.Entry<Integer, BlinkState>> iterator = this.activeBlinkSlots.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BlinkState> entry = iterator.next();
            if (now < entry.getValue().endTimeMs) continue;
            iterator.remove();
        }
    }

    private SlotPlacement computeSlotPlacement(int logicalIndex, RenderMetrics metrics) {
        int iconsInRow;
        int perRow = metrics.iconsPerRow;
        int rawRow = logicalIndex / perRow;
        int row = this.isTopAligned() ? rawRow : metrics.rows - 1 - rawRow;
        int topRowRawIndex = (metrics.totalSlots - 1) / perRow;
        int n = iconsInRow = rawRow == topRowRawIndex ? metrics.totalSlots - rawRow * perRow : perRow;
        if (iconsInRow <= 0) {
            iconsInRow = perRow;
        }
        int alignmentOffset = 0;
        if (rawRow == topRowRawIndex && this.isCenterAligned()) {
            alignmentOffset = (perRow - iconsInRow) / 2;
        }
        int rawColumn = logicalIndex % perRow;
        int column = this.isRightAligned() ? perRow - 1 - rawColumn : rawColumn;
        column = Math.max(0, column + alignmentOffset);
        return new SlotPlacement(column, Math.max(0, row));
    }

    private boolean isTopAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_LEFT, SpiffyAlignment.TOP_CENTERED, SpiffyAlignment.TOP_RIGHT -> true;
            default -> false;
        };
    }

    private boolean isCenterAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_CENTERED, SpiffyAlignment.MID_CENTERED, SpiffyAlignment.BOTTOM_CENTERED -> true;
            default -> false;
        };
    }

    private boolean isRightAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_RIGHT, SpiffyAlignment.MID_RIGHT, SpiffyAlignment.BOTTOM_RIGHT -> true;
            default -> false;
        };
    }

    public void setCustomTexture(@NotNull FoodTextureKind kind, @Nullable ResourceSupplier<ITexture> supplier) {
        if (supplier == null) {
            this.customTextures.remove((Object)kind);
        } else {
            this.customTextures.put(kind, supplier);
        }
    }

    @Nullable
    public ResourceSupplier<ITexture> getCustomTexture(@NotNull FoodTextureKind kind) {
        return this.customTextures.get((Object)kind);
    }

    @NotNull
    public Map<FoodTextureKind, ResourceSupplier<ITexture>> getCustomTextureMap() {
        return Collections.unmodifiableMap(this.customTextures);
    }

    private FoodVisualStyle pickEditorPreviewStyle() {
        long bucket = System.currentTimeMillis() / 10000L;
        int index = (int)(bucket % (long)EDITOR_PREVIEW_STYLES.length);
        return EDITOR_PREVIEW_STYLES[Math.max(0, index)];
    }

    public static enum FoodTextureKind {
        EMPTY("empty", -2145378272),
        NORMAL_HALF("normal_half", -2653),
        NORMAL_FULL("normal_full", -10129),
        HUNGER_HALF("hunger_half", -4128897),
        HUNGER_FULL("hunger_full", -8464041);

        private final String translationKeySuffix;
        private final int defaultColor;

        private FoodTextureKind(String translationKeySuffix, int defaultColor) {
            this.translationKeySuffix = translationKeySuffix;
            this.defaultColor = defaultColor;
        }

        public String getTranslationKey() {
            return "spiffyhud.elements.player_food_bar.texture." + this.translationKeySuffix;
        }
    }

    private static class PlayerData {
        final float currentFood;
        final FoodVisualStyle visualStyle;

        PlayerData(float currentFood, FoodVisualStyle visualStyle) {
            this.currentFood = currentFood;
            this.visualStyle = visualStyle;
        }
    }

    private record RenderMetrics(int iconsPerRow, int baseIconSize, int totalSlots, int bodyWidth, int bodyHeight, int rows, int horizontalGap, int verticalGap) {
    }

    private record SlotPlacement(int column, int row) {
    }

    private record BlinkState(float previousFill, long endTimeMs) {
    }

    private static enum FoodVisualStyle {
        NORMAL(FoodTextureKind.NORMAL_HALF, FoodTextureKind.NORMAL_FULL),
        HUNGER(FoodTextureKind.HUNGER_HALF, FoodTextureKind.HUNGER_FULL);

        private final FoodTextureKind halfTexture;
        private final FoodTextureKind fullTexture;

        private FoodVisualStyle(FoodTextureKind halfTexture, FoodTextureKind fullTexture) {
            this.halfTexture = halfTexture;
            this.fullTexture = fullTexture;
        }
    }
}

