/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.air;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerAirElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static final int BUBBLE_SIZE = 9;
    private static final int BUBBLE_SPACING = 8;
    private static final int TOTAL_BAR_WIDTH = 81;
    private static final int TOTAL_BAR_HEIGHT = 9;
    private final Minecraft minecraft = Minecraft.m_91087_();
    protected int tickCount;
    private int barWidth = 100;
    private int barHeight = 100;
    private boolean shouldRenderBar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerAirElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        if (this.minecraft.f_91073_ == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderPlayerAir(graphics, 0, 0);
        int elementAbsX = this.getAbsoluteX();
        int elementAbsY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementAbsX, elementAbsY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int barAbsX = alignedPosition[0];
        int barAbsY = alignedPosition[1];
        RenderSystem.m_69478_();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.shouldRenderBar = true;
        this.renderPlayerAir(graphics, barAbsX, barAbsY);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderPlayerAir(GuiGraphics graphics, int offsetX, int offsetY) {
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.m_69478_();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        int maxAir = player.m_6062_();
        int currentAir = Math.min(player.m_20146_(), maxAir);
        int fullAirBubbles = Mth.m_14165_((double)((double)(currentAir - 2) * 10.0 / (double)maxAir));
        int emptyAirBubbles = Mth.m_14165_((double)((double)currentAir * 10.0 / (double)maxAir)) - fullAirBubbles;
        int totalBubbles = fullAirBubbles + emptyAirBubbles;
        int totalBarWidth = 9 + (totalBubbles - 1) * 8;
        boolean leftAligned = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT;
        int localStartX = leftAligned ? 0 : totalBarWidth - 9;
        int localStartY = 0;
        for (int i = 0; i < totalBubbles; ++i) {
            boolean isFullBubble;
            int bubbleLocalX = leftAligned ? localStartX + i * 8 : localStartX - i * 8;
            int bubbleAbsX = offsetX + bubbleLocalX;
            int bubbleAbsY = offsetY + localStartY;
            boolean bl = isFullBubble = i < fullAirBubbles;
            if (!this.shouldRenderBar) continue;
            if (isFullBubble) {
                graphics.blit(GUI_ICONS_LOCATION, bubbleAbsX, bubbleAbsY, 16, 18, 9, 9);
                continue;
            }
            graphics.blit(GUI_ICONS_LOCATION, bubbleAbsX, bubbleAbsY, 25, 18, 9, 9);
        }
        this.barWidth = totalBarWidth;
        this.barHeight = 9;
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.m_91087_().m_91288_();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return 81;
    }

    public int getAbsoluteHeight() {
        return 9;
    }
}

