/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.armor;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerArmorElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static final int BAR_WIDTH = 81;
    private static final int BAR_HEIGHT = 9;
    private final Minecraft minecraft = Minecraft.m_91087_();
    protected int tickCount;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerArmorElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.f_91074_ == null || this.minecraft.f_91073_ == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, elementWidth, elementHeight, 81, 9);
        int armorBarX = alignedPosition[0];
        int armorBarY = alignedPosition[1];
        RenderSystem.m_69478_();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.renderPlayerArmor(graphics, armorBarX, armorBarY);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderPlayerArmor(GuiGraphics graphics, int offsetX, int offsetY) {
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.m_69478_();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        int armorValue = player.m_21230_();
        if (VanillaLikePlayerArmorElement.isEditor()) {
            armorValue = 9;
        }
        int iconCount = 10;
        int iconSpacing = 8;
        int iconSize = 9;
        boolean isRightAligned = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT;
        for (int slot = 0; slot < 10; ++slot) {
            int iconX = isRightAligned ? offsetX + (9 - slot) * 8 : offsetX + slot * 8;
            int iconY = offsetY;
            int armorSegment = slot * 2 + 1;
            if (armorSegment < armorValue) {
                if (isRightAligned) {
                    SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, iconX, iconY, 0, 34, 9, 9, 9, 256, 256);
                    continue;
                }
                graphics.blit(GUI_ICONS_LOCATION, iconX, iconY, 34, 9, 9, 9);
                continue;
            }
            if (armorSegment == armorValue) {
                if (isRightAligned) {
                    SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, iconX, iconY, 0, 25, 9, 9, 9, 256, 256);
                    continue;
                }
                graphics.blit(GUI_ICONS_LOCATION, iconX, iconY, 25, 9, 9, 9);
                continue;
            }
            if (isRightAligned) {
                SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, iconX, iconY, 0, 16, 9, 9, 9, 256, 256);
                continue;
            }
            graphics.blit(GUI_ICONS_LOCATION, iconX, iconY, 16, 9, 9, 9);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.m_91087_().m_91288_();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return 81;
    }

    public int getAbsoluteHeight() {
        return 9;
    }
}

