/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.bossbars;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeBossOverlayElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
    private static final List<LerpingBossEvent> DUMMY_EVENTS = List.of(new LerpingBossEvent(UUID.randomUUID(), (Component)Component.m_237115_((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS, false, false, false), new LerpingBossEvent(UUID.randomUUID(), (Component)Component.m_237115_((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS, false, false, false), new LerpingBossEvent(UUID.randomUUID(), (Component)Component.m_237115_((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS, false, false, false));
    private final Minecraft minecraft = Minecraft.m_91087_();
    private int barWidth = 182;
    private int barHeight = 0;
    private int barOriginalX = 0;
    private int barOriginalY = 0;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeBossOverlayElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.f_91074_ == null || this.minecraft.f_91073_ == null) {
            return;
        }
        this.updateBodySizeAndPosCache();
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int offsetX = alignedPosition[0] - this.barOriginalX;
        int offsetY = alignedPosition[1] - this.barOriginalY;
        RenderSystem.m_69478_();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        List<LerpingBossEvent> eventsToRender = VanillaLikeBossOverlayElement.isEditor() ? DUMMY_EVENTS : Minecraft.m_91087_().f_91065_.m_93090_().f_93699_.values();
        this.renderBossBars(graphics, offsetX, offsetY, eventsToRender);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void updateBodySizeAndPosCache() {
        List<LerpingBossEvent> eventsToRecord;
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setHeightOffset(5);
        int defaultBarWidth = 182;
        Collection<Object> collection = eventsToRecord = VanillaLikeBossOverlayElement.isEditor() ? DUMMY_EVENTS : Minecraft.m_91087_().f_91065_.m_93090_().f_93699_.values();
        if (!eventsToRecord.iterator().hasNext() && !VanillaLikeBossOverlayElement.isEditor()) {
            return;
        }
        int currentY = 12;
        for (LerpingBossEvent bossEvent : eventsToRecord) {
            int barPosX = 0;
            int barPosY = currentY;
            recorder.updateX(barPosX);
            recorder.updateY(barPosY);
            Component eventName = bossEvent.m_18861_();
            int textWidth = this.minecraft.f_91062_.m_92852_((FormattedText)eventName);
            int textPosX = (defaultBarWidth - textWidth) / 2;
            int textPosY = barPosY - 9;
            recorder.updateX(textPosX);
            recorder.updateY(textPosY);
            Objects.requireNonNull(this.minecraft.f_91062_);
            currentY += 10 + 9;
        }
        this.barOriginalX = recorder.getX();
        this.barOriginalY = recorder.getY();
        this.barWidth = Math.max(defaultBarWidth, recorder.getWidth());
        this.barHeight = recorder.getHeight();
    }

    private void renderBossBars(GuiGraphics graphics, int offsetX, int offsetY, Iterable<LerpingBossEvent> bossEvents) {
        RenderSystem.m_69478_();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        int currentY = offsetY + 12;
        for (LerpingBossEvent bossEvent : bossEvents) {
            int barPosX = offsetX;
            int barPosY = currentY;
            RenderSystem.m_69478_();
            graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
            this.drawBar(graphics, barPosX, barPosY, (BossEvent)bossEvent);
            Component eventName = bossEvent.m_18861_();
            int textWidth = this.minecraft.f_91062_.m_92852_((FormattedText)eventName);
            int textPosX = offsetX + (this.getAbsoluteWidth() - textWidth) / 2;
            int textPosY = barPosY - 9;
            RenderSystem.m_69478_();
            graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
            graphics.drawString(this.minecraft.f_91062_, eventName, textPosX, textPosY, 0xFFFFFF);
            Objects.requireNonNull(this.minecraft.f_91062_);
            currentY += 10 + 9;
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void drawBar(GuiGraphics graphics, int barX, int barY, BossEvent bossEvent) {
        this.drawBar(graphics, barX, barY, bossEvent, 182, 0);
        int filledWidth = (int)(bossEvent.m_142717_() * 183.0f);
        if (filledWidth > 0) {
            this.drawBar(graphics, barX, barY, bossEvent, filledWidth, 5);
        }
    }

    private void drawBar(GuiGraphics graphics, int barX, int barY, BossEvent bossEvent, int width, int textureYOffset) {
        graphics.blit(GUI_BARS_LOCATION, barX, barY, 0, bossEvent.m_18862_().ordinal() * 5 * 2 + textureYOffset, width, 5);
        if (bossEvent.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
            RenderSystem.m_69478_();
            graphics.blit(GUI_BARS_LOCATION, barX, barY, 0, 80 + (bossEvent.m_18863_().ordinal() - 1) * 5 * 2 + textureYOffset, width, 5);
            RenderSystem.m_69461_();
        }
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }

    protected boolean isInEditor() {
        return VanillaLikeBossOverlayElement.isEditor();
    }
}

