/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeHotbarElement
extends AbstractElement {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 22;

    public VanillaLikeHotbarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        RenderSystem.m_69478_();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        this.renderHotbar(graphics, partialTick, elementX, elementY, elementWidth, elementHeight);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderHotbar(GuiGraphics graphics, float partialTick, int elementX, int elementY, int elementWidth, int elementHeight) {
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.m_69478_();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        ItemStack offhandItem = player.m_21206_();
        HumanoidArm oppositeMainArm = player.m_5737_().m_20828_();
        graphics.blit(WIDGETS_LOCATION, elementX, elementY, 0, 0, elementWidth, elementHeight);
        int selectedSlot = player.m_150109_().f_35977_;
        graphics.blit(WIDGETS_LOCATION, elementX - 1 + selectedSlot * 20, elementY - 1, 0, 22, 24, 22);
        if (!VanillaLikeHotbarElement.isEditor()) {
            if (!offhandItem.m_41619_()) {
                if (oppositeMainArm == HumanoidArm.LEFT) {
                    graphics.blit(WIDGETS_LOCATION, elementX - 29, elementY - 1, 24, 22, 29, 24);
                } else {
                    graphics.blit(WIDGETS_LOCATION, elementX + elementWidth, elementY - 1, 53, 22, 29, 24);
                }
            }
        } else {
            graphics.blit(WIDGETS_LOCATION, elementX - 29, elementY - 1, 24, 22, 29, 24);
            graphics.blit(WIDGETS_LOCATION, elementX + elementWidth, elementY - 1, 53, 22, 29, 24);
        }
        int slotStartX = elementX + 3;
        int slotY = elementY + 3;
        int renderSeed = 1;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int slotX = slotStartX + slotIndex * 20;
            this.renderSlot(graphics, slotX, slotY, partialTick, player, (ItemStack)player.m_150109_().f_35974_.get(slotIndex), renderSeed++);
        }
        if (!offhandItem.m_41619_()) {
            if (oppositeMainArm == HumanoidArm.LEFT) {
                this.renderSlot(graphics, elementX - 26, slotY, partialTick, player, offhandItem, renderSeed++);
            } else {
                this.renderSlot(graphics, elementX + elementWidth + 10, slotY, partialTick, player, offhandItem, renderSeed++);
            }
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderSlot(GuiGraphics graphics, int slotX, int slotY, float partialTick, Player player, ItemStack stack, int renderSeed) {
        if (stack.m_41619_()) {
            return;
        }
        float popTimeRemaining = (float)stack.m_41612_() - partialTick;
        if (popTimeRemaining > 0.0f) {
            float scaleFactor = 1.0f + popTimeRemaining / 5.0f;
            graphics.pose().m_85836_();
            graphics.pose().m_85837_((double)(slotX + 8), (double)(slotY + 12), 0.0);
            graphics.pose().m_85841_(1.0f / scaleFactor, (scaleFactor + 1.0f) / 2.0f, 1.0f);
            graphics.pose().m_85837_((double)(-(slotX + 8)), (double)(-(slotY + 12)), 0.0);
        }
        graphics.renderItem((LivingEntity)player, stack, slotX, slotY, renderSeed);
        if (popTimeRemaining > 0.0f) {
            graphics.pose().m_85849_();
        }
        this.renderSlotDecorations(graphics, player, stack, slotX, slotY);
    }

    private void renderSlotDecorations(GuiGraphics graphics, @Nullable Player player, ItemStack stack, int slotX, int slotY) {
        float cooldownProgress;
        graphics.pose().m_85836_();
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        if (stack.m_41613_() != 1) {
            String countText = String.valueOf(stack.m_41613_());
            graphics.pose().m_85837_(0.0, 0.0, 200.0);
            graphics.drawString(font, countText, slotX + 19 - 2 - font.m_92895_(countText), slotY + 6 + 3, 0xFFFFFF, true);
        }
        if (stack.m_150947_()) {
            int barWidth = stack.m_150948_();
            int barColor = stack.m_150949_();
            int barX = slotX + 2;
            int barY = slotY + 13;
            graphics.fill(barX, barY, barX + 13, barY + 2, -16777216);
            graphics.fill(barX, barY, barX + barWidth, barY + 1, barColor | 0xFF000000);
        }
        if (player != null && (cooldownProgress = player.m_36335_().m_41521_(stack.m_41720_(), minecraft.m_91296_())) > 0.0f) {
            int overlayTop = slotY + Mth.m_14143_((float)(16.0f * (1.0f - cooldownProgress)));
            int overlayBottom = overlayTop + Mth.m_14167_((float)(16.0f * cooldownProgress));
            graphics.fill(slotX, overlayTop, slotX + 16, overlayBottom, Integer.MAX_VALUE);
        }
        graphics.pose().m_85849_();
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.m_91087_().m_91288_();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return 182;
    }

    public int getAbsoluteHeight() {
        return 22;
    }
}

