/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.playerhealth;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerHealthElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private final Minecraft minecraft = Minecraft.m_91087_();
    protected final RandomSource random = RandomSource.m_216327_();
    protected int lastHealth;
    protected int displayHealth;
    protected long lastHealthTime;
    protected long healthBlinkTime;
    protected int tickCount;
    private int barWidth = 100;
    private int barHeight = 100;
    private boolean shouldRenderBar = false;
    public boolean isUsedAsDummy = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerHealthElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        if (this.minecraft.f_91073_ == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderPlayerHealthInternal(graphics, 0, 0);
        int elementAbsX = this.getAbsoluteX();
        int elementAbsY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementAbsX, elementAbsY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int alignedBarX = alignedPosition[0];
        int alignedBarY = alignedPosition[1];
        RenderSystem.m_69478_();
        this.shouldRenderBar = true;
        this.renderPlayerHealthInternal(graphics, alignedBarX, alignedBarY);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderPlayerHealthInternal(GuiGraphics graphics, int originX, int originY) {
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.m_69478_();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        int currentHealthCeil = Mth.m_14167_((float)player.m_21223_());
        boolean heartBlink = this.healthBlinkTime > (long)this.tickCount && (this.healthBlinkTime - (long)this.tickCount) / 3L % 2L == 1L;
        long currentTime = Util.m_137550_();
        if (currentHealthCeil < this.lastHealth && player.f_19802_ > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = this.tickCount + 20;
        } else if (currentHealthCeil > this.lastHealth && player.f_19802_ > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = this.tickCount + 10;
        }
        if (currentTime - this.lastHealthTime > 1000L) {
            this.displayHealth = currentHealthCeil;
            this.lastHealthTime = currentTime;
        }
        this.lastHealth = currentHealthCeil;
        FoodData foodData = player.m_36324_();
        int baseX = originX;
        int baseY = originY;
        float maxHealth = Math.max((float)player.m_21133_(Attributes.f_22276_), (float)Math.max(this.displayHealth, currentHealthCeil));
        int absorptionHalfHearts = Mth.m_14167_((float)player.m_6103_());
        int totalHealthHearts = Mth.m_14167_((float)(maxHealth / 2.0f));
        int totalHearts = totalHealthHearts + VanillaLikePlayerHealthElement.toFullHearts(absorptionHalfHearts);
        int displayedHealth = this.displayHealth;
        if (VanillaLikePlayerHealthElement.isEditor()) {
            maxHealth = 40.0f;
            currentHealthCeil = 9;
            displayedHealth = 9;
            absorptionHalfHearts = 5;
            totalHealthHearts = Mth.m_14167_((float)(maxHealth / 2.0f));
            totalHearts = totalHealthHearts + VanillaLikePlayerHealthElement.toFullHearts(absorptionHalfHearts);
        }
        if (this.isUsedAsDummy) {
            maxHealth = 20.0f;
            currentHealthCeil = 9;
            displayedHealth = 9;
            absorptionHalfHearts = 0;
            totalHealthHearts = Mth.m_14167_((float)(maxHealth / 2.0f));
            totalHearts = totalHealthHearts + VanillaLikePlayerHealthElement.toFullHearts(absorptionHalfHearts);
        }
        int fullRowSlots = 10;
        int numRows = (totalHearts + 10 - 1) / 10;
        int rowSpacing = Math.max(10 - (numRows - 2), 3);
        int regenHeartIndex = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regenHeartIndex = this.tickCount % Mth.m_14167_((float)(maxHealth + 5.0f));
        }
        Gui.HeartType baseHeartType = Gui.HeartType.m_168732_((Player)player);
        boolean isHardcore = player.f_19853_.m_6106_().m_5466_();
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setWidthOffset(9);
        recorder.setHeightOffset(9);
        for (int m = totalHearts - 1; m >= 0; --m) {
            boolean isLastHeart;
            int absorptionIndex;
            int rawRow = m / 10;
            int row = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT ? rawRow : numRows - 1 - rawRow;
            int heartsInRow = rawRow == (totalHearts - 1) / 10 ? totalHearts - rawRow * 10 : 10;
            int alignmentOffset = 0;
            if (rawRow == (totalHearts - 1) / 10 && (this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED)) {
                alignmentOffset = (10 - heartsInRow) / 2;
            }
            int col = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT ? 9 - m % 10 : m % 10;
            int effectiveCol = col + alignmentOffset;
            int heartX = baseX + effectiveCol * 8;
            int heartY = baseY + row * rowSpacing;
            if (currentHealthCeil + absorptionHalfHearts <= 4) {
                heartY += this.random.m_188503_(2);
            }
            if (m < totalHealthHearts && m == regenHeartIndex) {
                heartY -= 2;
            }
            recorder.updateX(heartX);
            recorder.updateY(heartY);
            if (this.shouldRenderBar) {
                this.renderEmptyHeart(graphics, heartX, heartY, heartBlink, isHardcore);
            }
            int heartValue = m * 2;
            if (m >= totalHealthHearts && (absorptionIndex = heartValue - totalHealthHearts * 2) < absorptionHalfHearts) {
                boolean isLastAbsorption;
                boolean bl = isLastAbsorption = absorptionIndex + 1 == absorptionHalfHearts;
                if (this.shouldRenderBar) {
                    this.renderHeart(graphics, baseHeartType == Gui.HeartType.WITHERED ? baseHeartType : Gui.HeartType.ABSORBING, heartX, heartY, false, isHardcore, isLastAbsorption);
                }
            }
            if (heartBlink && heartValue < displayedHealth) {
                boolean isLastHighlight;
                boolean bl = isLastHighlight = heartValue + 1 == displayedHealth;
                if (this.shouldRenderBar) {
                    this.renderHeart(graphics, baseHeartType, heartX, heartY, true, isHardcore, isLastHighlight);
                }
            }
            if (heartValue >= currentHealthCeil) continue;
            boolean bl = isLastHeart = heartValue + 1 == currentHealthCeil;
            if (!this.shouldRenderBar) continue;
            this.renderHeart(graphics, baseHeartType, heartX, heartY, false, isHardcore, isLastHeart);
        }
        if (!this.shouldRenderBar && recorder.isUpdated()) {
            this.barWidth = recorder.getWidth();
            this.barHeight = recorder.getHeight();
        } else if (!this.shouldRenderBar) {
            this.barWidth = 1;
            this.barHeight = 9;
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderEmptyHeart(GuiGraphics graphics, int x, int y, boolean blinking, boolean hardcore) {
        int textureYOffset = hardcore ? 45 : 0;
        int textureX = Gui.HeartType.CONTAINER.m_168734_(false, blinking);
        if (this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, x, y, 0, textureX, textureYOffset, 9, 9, 256, 256);
        } else {
            graphics.blit(GUI_ICONS_LOCATION, x, y, textureX, textureYOffset, 9, 9);
        }
    }

    private void renderHeart(GuiGraphics graphics, Gui.HeartType heartType, int x, int y, boolean blinking, boolean hardcore, boolean halfHeart) {
        int textureYOffset = hardcore ? 45 : 0;
        int textureX = heartType.m_168734_(halfHeart, blinking);
        if (this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, x, y, 0, textureX, textureYOffset, 9, 9, 256, 256);
        } else {
            graphics.blit(GUI_ICONS_LOCATION, x, y, textureX, textureYOffset, 9, 9);
        }
    }

    private static int toFullHearts(int halfHearts) {
        return (halfHearts + 1) / 2;
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.m_91087_().m_91288_();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

