/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.scoreboard;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeScoreboardElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SPACER = ": ";
    private final Minecraft minecraft = Minecraft.m_91087_();
    private int sidebarWidth = 100;
    private int sidebarHeight = 100;
    private int sidebarOriginalX = 0;
    private int sidebarOriginalY = 0;
    private boolean renderSidebar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;
    @Nullable
    public DrawableColor customTitleBackgroundColor = null;
    @Nullable
    public DrawableColor customLineBackgroundColor = null;

    public VanillaLikeScoreboardElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.f_91074_ == null || this.minecraft.f_91073_ == null) {
            return;
        }
        this.renderSidebar = false;
        this.renderScoreboard(graphics, 0, 0, false);
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.sidebarWidth, this.sidebarHeight);
        int offsetX = alignedPosition[0] - this.sidebarOriginalX;
        int offsetY = alignedPosition[1] - this.sidebarOriginalY;
        RenderSystem.m_69478_();
        this.renderSidebar = true;
        this.renderScoreboard(graphics, offsetX, offsetY, true);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderScoreboard(GuiGraphics graphics, int offsetX, int offsetY, boolean applyOffset) {
        Objective objectiveToRender;
        RenderSystem.m_69478_();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        Scoreboard scoreboard = this.minecraft.f_91073_.m_6188_();
        Objective objective = null;
        PlayerTeam playerTeam = scoreboard.m_83500_(this.minecraft.f_91074_.m_6302_());
        int colorId = -1;
        if (playerTeam != null) {
            colorId = playerTeam.m_7414_().m_126656_();
        }
        if (playerTeam != null && colorId >= 0) {
            objective = scoreboard.m_83416_(3 + colorId);
        }
        Objective objective2 = objectiveToRender = objective != null ? objective : scoreboard.m_83416_(1);
        if (VanillaLikeScoreboardElement.isEditor()) {
            objectiveToRender = new Objective(scoreboard, "", ObjectiveCriteria.f_83588_, (Component)Component.m_237119_(), ObjectiveCriteria.RenderType.INTEGER);
        }
        if (objectiveToRender != null) {
            this.displayScoreboardSidebar(graphics, objectiveToRender, offsetX, offsetY, applyOffset);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void displayScoreboardSidebar(GuiGraphics guiGraphics, Objective objective, int offsetX, int offsetY, boolean applyOffset) {
        Scoreboard scoreboard = objective.m_83313_();
        Collection rawScores = scoreboard.m_83498_(objective);
        ArrayList<DummyScore> validScores = rawScores.stream().filter(score -> score.m_83405_() != null && !score.m_83405_().startsWith("#")).collect(Collectors.toList());
        ArrayList<DummyScore> scoresToDisplay = validScores.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(validScores, (int)(validScores.size() - 15))) : validScores;
        ArrayList scoreComponents = Lists.newArrayListWithCapacity((int)scoresToDisplay.size());
        Component title = objective.m_83322_();
        if (VanillaLikeScoreboardElement.isEditor()) {
            title = Component.m_237115_((String)"spiffyhud.elements.dummy.scoreboard_sidebar.title").m_130940_(ChatFormatting.BOLD);
            ArrayList<DummyScore> dummyEntries = new ArrayList<DummyScore>();
            String dummyLineText = I18n.m_118938_((String)"spiffyhud.elements.dummy.scoreboard_sidebar.line", (Object[])new Object[0]);
            for (int i = 0; i < 6; ++i) {
                dummyEntries.add(new DummyScore(objective, dummyLineText, 0));
            }
            dummyEntries.add(new DummyScore(objective, "", 0));
            scoresToDisplay = dummyEntries;
        }
        int titleWidth = this.getFont().m_92852_((FormattedText)title);
        int spacerWidth = this.getFont().m_92895_(SPACER);
        int maxEntryWidth = titleWidth;
        for (Score score2 : scoresToDisplay) {
            PlayerTeam team = scoreboard.m_83500_(score2.m_83405_());
            MutableComponent scoreComponent = PlayerTeam.m_83348_((Team)team, (Component)Component.m_237113_((String)score2.m_83405_()));
            scoreComponents.add(Pair.of((Object)score2, (Object)scoreComponent));
            int entryWidth = this.getFont().m_92852_((FormattedText)scoreComponent) + spacerWidth + this.getFont().m_92895_(Integer.toString(score2.m_83400_()));
            maxEntryWidth = Math.max(maxEntryWidth, entryWidth);
        }
        int numberOfLines = scoresToDisplay.size();
        Objects.requireNonNull(this.getFont());
        int n = numberOfLines * 9;
        int baseY = VanillaLikeScoreboardElement.getScreenHeight() / 2 + n / 3;
        int baseX = VanillaLikeScoreboardElement.getScreenWidth() - maxEntryWidth - 3;
        int lineBackgroundColor = this.minecraft.f_91066_.m_92170_(0.3f);
        if (this.customLineBackgroundColor != null) {
            lineBackgroundColor = this.customLineBackgroundColor.getColorInt();
        }
        int titleBackgroundColor = this.minecraft.f_91066_.m_92170_(0.4f);
        if (this.customTitleBackgroundColor != null) {
            titleBackgroundColor = this.customTitleBackgroundColor.getColorInt();
        }
        Objects.requireNonNull(this.getFont());
        int topY = baseY - numberOfLines * 9;
        this.sidebarWidth = Math.max(1, maxEntryWidth + 4);
        Objects.requireNonNull(this.getFont());
        this.sidebarHeight = Math.max(1, baseY - (topY - 9 - 1));
        this.sidebarOriginalX = baseX - 2;
        Objects.requireNonNull(this.getFont());
        this.sidebarOriginalY = topY - 9 - 1;
        int effectiveBaseX = baseX + (applyOffset ? offsetX : 0);
        int effectiveBaseY = baseY + (applyOffset ? offsetY : 0);
        if (this.renderSidebar) {
            int lineIndex = 0;
            for (Pair scorePair : scoreComponents) {
                Score currentScore = (Score)scorePair.getFirst();
                Component entryComponent = (Component)scorePair.getSecond();
                String scoreText = "" + ChatFormatting.RED + currentScore.m_83400_();
                int lineX = effectiveBaseX;
                int lineY = effectiveBaseY - ++lineIndex * 9;
                int rightX = VanillaLikeScoreboardElement.getScreenWidth() - 3 + 2 + (applyOffset ? offsetX : 0);
                guiGraphics.fill(lineX - 2, lineY, rightX, lineY + 9, lineBackgroundColor);
                guiGraphics.drawString(this.getFont(), entryComponent, lineX, lineY, -1, false);
                guiGraphics.drawString(this.getFont(), scoreText, rightX - this.getFont().m_92895_(scoreText), lineY, -1, false);
                if (lineIndex != scoresToDisplay.size()) continue;
                guiGraphics.fill(lineX - 2, lineY - 9 - 1, rightX, lineY - 1, titleBackgroundColor);
                guiGraphics.fill(lineX - 2, lineY - 1, rightX, lineY, lineBackgroundColor);
                Font font = this.getFont();
                int titleX = lineX + maxEntryWidth / 2 - titleWidth / 2;
                guiGraphics.drawString(font, title, titleX, lineY - 9, -1, false);
            }
        }
    }

    private Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    public int getAbsoluteWidth() {
        return this.sidebarWidth;
    }

    public int getAbsoluteHeight() {
        return this.sidebarHeight;
    }

    private static class DummyScore
    extends Score {
        int score;

        public DummyScore(Objective objective, String display, int score) {
            super(objective.m_83313_(), objective, display);
            this.score = score;
        }

        public int m_83400_() {
            return this.score;
        }
    }
}

