/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.scoreboard;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.scoreboard.VanillaLikeScoreboardEditorElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.scoreboard.VanillaLikeScoreboardElement;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeScoreboardElementBuilder
extends ElementBuilder<VanillaLikeScoreboardElement, VanillaLikeScoreboardEditorElement> {
    public VanillaLikeScoreboardElementBuilder() {
        super("spiffy_vanillalike_scoreboard_sidebar");
    }

    @NotNull
    public VanillaLikeScoreboardElement buildDefaultInstance() {
        VanillaLikeScoreboardElement e = new VanillaLikeScoreboardElement(this);
        e.stickyAnchor = true;
        e.stayOnScreen = false;
        return e;
    }

    public VanillaLikeScoreboardElement deserializeElement(@NotNull SerializedElement serialized) {
        String linesBackColor;
        String titleBackColor;
        VanillaLikeScoreboardElement element = this.buildDefaultInstance();
        String alignment = serialized.getValue("body_alignment");
        if (alignment != null) {
            element.spiffyAlignment = Objects.requireNonNullElse(SpiffyAlignment.getByName(alignment), element.spiffyAlignment);
        }
        if ((titleBackColor = serialized.getValue("title_background_color")) != null) {
            element.customTitleBackgroundColor = DrawableColor.of((String)titleBackColor);
        }
        if ((linesBackColor = serialized.getValue("lines_background_color")) != null) {
            element.customLineBackgroundColor = DrawableColor.of((String)linesBackColor);
        }
        return element;
    }

    @Nullable
    public VanillaLikeScoreboardElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        VanillaLikeScoreboardElement e = (VanillaLikeScoreboardElement)super.deserializeElementInternal(serialized);
        if (e != null) {
            e.stayOnScreen = this.deserializeBoolean(e.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return e;
    }

    protected SerializedElement serializeElement(@NotNull VanillaLikeScoreboardElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("body_alignment", element.spiffyAlignment.getName());
        if (element.customTitleBackgroundColor != null) {
            serializeTo.putProperty("title_background_color", element.customTitleBackgroundColor.getHex());
        }
        if (element.customLineBackgroundColor != null) {
            serializeTo.putProperty("lines_background_color", element.customLineBackgroundColor.getHex());
        }
        return serializeTo;
    }

    @NotNull
    public VanillaLikeScoreboardEditorElement wrapIntoEditorElement(@NotNull VanillaLikeScoreboardElement element, @NotNull LayoutEditorScreen editor) {
        return new VanillaLikeScoreboardEditorElement(element, editor);
    }

    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.m_237115_((String)"spiffyhud.elements.vanillalike.scoreboard");
    }

    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return null;
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

