/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.placeholders;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.customization.marker.MarkerData;
import de.keksuccino.spiffyhud.customization.marker.MarkerStorage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerListPlaceholder
extends Placeholder {
    private static final String VALUE_TARGET_ELEMENT = "target_element_identifier";
    private static final String VALUE_SEPARATOR = "separator";

    public MarkerListPlaceholder() {
        super("marker_list");
    }

    public String getReplacementFor(DeserializedPlaceholderString dps) {
        List<MarkerData> markers;
        String trimmedTarget;
        HashMap values = dps.values;
        String targetElement = values != null ? (String)values.get(VALUE_TARGET_ELEMENT) : null;
        String separator = values != null ? (String)values.get(VALUE_SEPARATOR) : null;
        String string = trimmedTarget = targetElement != null ? targetElement.trim() : "";
        if (trimmedTarget.isEmpty()) {
            return "";
        }
        String normalizedSeparator = separator == null ? ", " : separator;
        try {
            markers = MarkerStorage.getMarkers(trimmedTarget);
        }
        catch (IllegalArgumentException ignored) {
            return "";
        }
        if (markers.isEmpty()) {
            return "";
        }
        return markers.stream().map(MarkerData::getName).filter(name -> !name.isBlank()).collect(Collectors.joining(normalizedSeparator));
    }

    @Nullable
    public List<String> getValueNames() {
        return List.of(VALUE_TARGET_ELEMENT, VALUE_SEPARATOR);
    }

    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"spiffyhud.placeholders.marker_list", (Object[])new Object[0]);
    }

    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines((String)"spiffyhud.placeholders.marker_list.desc", (String[])new String[0]));
    }

    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.placeholders.categories.world", (Object[])new Object[0]);
    }

    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put(VALUE_TARGET_ELEMENT, "element_identifier");
        values.put(VALUE_SEPARATOR, ", ");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

