/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.GuiMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class GuiEntityRenderer {
    private static final float DEFAULT_FACING = 180.0f;
    private static final float MAX_BODY_DELTA = 30.0f;
    private static final float MAX_HEAD_DELTA = 30.0f;
    private float lastOriginalBodyRotation = Float.NaN;
    private float renderedBodyRotation = 180.0f;
    private float lastOriginalHeadRotation = Float.NaN;
    private float renderedHeadRotation = 180.0f;

    public void renderEntity(GuiGraphics graphics, int posX, int posY, int boxWidth, int boxHeight, float opacity, LivingEntity entity) {
        EntityDimensions dimensions = entity.m_6972_(Pose.STANDING);
        float scaleFromWidth = (float)boxWidth / dimensions.f_20377_;
        float scaleFromHeight = (float)boxHeight / dimensions.f_20378_;
        float uniformScale = Math.min(scaleFromWidth, scaleFromHeight);
        float origYBodyRot = entity.f_20883_;
        float origYRot = entity.m_146908_();
        float origXRot = entity.m_146909_();
        float origYHeadRot = entity.f_20885_;
        float origYHeadRotO = entity.f_20886_;
        float currentOriginalBody = origYBodyRot;
        if (Float.isNaN(this.lastOriginalBodyRotation)) {
            this.lastOriginalBodyRotation = currentOriginalBody;
            this.renderedBodyRotation = currentOriginalBody;
        }
        float bodyDelta = Mth.m_14177_((float)(currentOriginalBody - this.lastOriginalBodyRotation));
        this.renderedBodyRotation += bodyDelta;
        this.renderedBodyRotation = Mth.m_14036_((float)this.renderedBodyRotation, (float)150.0f, (float)210.0f);
        this.lastOriginalBodyRotation = currentOriginalBody;
        entity.f_20883_ = this.renderedBodyRotation;
        float currentOriginalHead = origYHeadRot;
        if (Float.isNaN(this.lastOriginalHeadRotation)) {
            this.lastOriginalHeadRotation = currentOriginalHead;
            this.renderedHeadRotation = currentOriginalHead;
        }
        float headDelta = Mth.m_14177_((float)(currentOriginalHead - this.lastOriginalHeadRotation));
        float newRenderedHead = this.renderedHeadRotation + headDelta;
        newRenderedHead = Mth.m_14036_((float)newRenderedHead, (float)(this.renderedBodyRotation - 30.0f), (float)(this.renderedBodyRotation + 30.0f));
        this.lastOriginalHeadRotation = currentOriginalHead;
        this.renderedHeadRotation = newRenderedHead;
        entity.f_20885_ = newRenderedHead;
        entity.f_20886_ = newRenderedHead;
        entity.m_146922_(newRenderedHead);
        graphics.pose().m_85836_();
        graphics.pose().m_85837_((double)posX + (double)boxWidth / 2.0, (double)posY + (double)boxHeight / 2.0, 50.0);
        graphics.pose().m_166854_((Matrix4f)new GuiMatrix4f().scaling(uniformScale, uniformScale, -uniformScale));
        Quaternion baseRotation = new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), (float)Math.PI, false);
        graphics.pose().m_85845_(baseRotation);
        graphics.pose().m_85837_(0.0, (double)(-(dimensions.f_20378_ / 2.0f)), 0.0);
        Lighting.m_166384_();
        RenderSystem.m_69478_();
        graphics.setColor(1.0f, 1.0f, 1.0f, opacity);
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        dispatcher.m_114468_(false);
        RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, graphics.pose(), (MultiBufferSource)graphics.bufferSource(), 0xF000F0));
        graphics.flush();
        dispatcher.m_114468_(true);
        graphics.pose().m_85849_();
        Lighting.m_84931_();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        entity.f_20883_ = origYBodyRot;
        entity.m_146922_(origYRot);
        entity.m_146926_(origXRot);
        entity.f_20885_ = origYHeadRot;
        entity.f_20886_ = origYHeadRotO;
    }
}

