/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.keksuccino.fancymenu.networking.Packet;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.util.CommandUtils;
import de.keksuccino.spiffyhud.customization.actions.marker.MarkerActionConfig;
import de.keksuccino.spiffyhud.customization.actions.marker.MarkerRemovalConfig;
import de.keksuccino.spiffyhud.networking.packets.markercommand.MarkerCommandEditField;
import de.keksuccino.spiffyhud.networking.packets.markercommand.MarkerCommandOperation;
import de.keksuccino.spiffyhud.networking.packets.markercommand.command.MarkerCommandPacket;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiffyMarkerCommand {
    private static final SimpleCommandExceptionType MUST_BE_PLAYER_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"spiffyhud.commands.marker.requires_player"));
    private static final SimpleCommandExceptionType INVALID_TARGET_ELEMENT = new SimpleCommandExceptionType((Message)Component.translatable((String)"spiffyhud.commands.marker.error.invalid_target"));
    private static final SimpleCommandExceptionType INVALID_MARKER_NAME = new SimpleCommandExceptionType((Message)Component.translatable((String)"spiffyhud.commands.marker.error.invalid_marker"));
    private static final SimpleCommandExceptionType CLIENT_NOT_SUPPORTED = new SimpleCommandExceptionType((Message)Component.translatable((String)"spiffyhud.commands.marker.self_not_supported"));
    private static final Map<String, List<String>> CACHED_GROUP_SUGGESTIONS = Collections.synchronizedMap(new HashMap());
    private static final DecimalFormat POSITION_FORMAT = SpiffyMarkerCommand.buildPositionFormat();

    public static void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spiffymarker").then(SpiffyMarkerCommand.buildAddCommand())).then(SpiffyMarkerCommand.buildEditCommand())).then(SpiffyMarkerCommand.buildRemoveCommand())).then(SpiffyMarkerCommand.buildClearCommand()));
    }

    public static void cacheSuggestions(@NotNull UUID playerUuid, @NotNull List<String> groups) {
        CACHED_GROUP_SUGGESTIONS.put(playerUuid.toString(), new ArrayList<String>(groups));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> targetElementArgument() {
        return Commands.argument((String)"target_element", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            try {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
                List values = Objects.requireNonNullElse(CACHED_GROUP_SUGGESTIONS.get(player.getUUID().toString()), List.of());
                if (values.isEmpty()) {
                    return CommandUtils.buildStringSuggestionsList((CommandContext)context, (String[])new String[]{"<no_marker_groups>"});
                }
                return CommandUtils.buildStringSuggestionsList((CommandContext)context, (String[])values.toArray(new String[0]));
            }
            catch (CommandSyntaxException ex) {
                return CommandUtils.buildStringSuggestionsList((CommandContext)context, (String[])new String[]{"<player_only>"});
            }
        });
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildAddCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"add").then(SpiffyMarkerCommand.silenceArgument().then(SpiffyMarkerCommand.targetElementArgument().then(Commands.argument((String)"marker_name", (ArgumentType)StringArgumentType.string()).then(SpiffyMarkerCommand.positionAndOptionals((Command<CommandSourceStack>)((Command)SpiffyMarkerCommand::executeAdd))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildEditCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"edit").then(SpiffyMarkerCommand.silenceArgument().then(SpiffyMarkerCommand.targetElementArgument().then(Commands.argument((String)"marker_name", (ArgumentType)StringArgumentType.string()).then(SpiffyMarkerCommand.positionAndOptionals((Command<CommandSourceStack>)((Command)SpiffyMarkerCommand::executeEdit))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildRemoveCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"remove").then(SpiffyMarkerCommand.silenceArgument().then(SpiffyMarkerCommand.targetElementArgument().then(Commands.argument((String)"marker_name", (ArgumentType)StringArgumentType.string()).executes(SpiffyMarkerCommand::executeRemove))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildClearCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"clear").then(SpiffyMarkerCommand.silenceArgument().then(SpiffyMarkerCommand.targetElementArgument().executes(SpiffyMarkerCommand::executeClear)));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Boolean> silenceArgument() {
        return Commands.argument((String)"silence_command_chat_output", (ArgumentType)BoolArgumentType.bool());
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> optionalColorArgument() {
        return Commands.argument((String)"color", (ArgumentType)StringArgumentType.string());
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Boolean> optionalNeedleArgument() {
        return Commands.argument((String)"show_as_needle", (ArgumentType)BoolArgumentType.bool());
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> optionalDotTextureArgument() {
        return Commands.argument((String)"dot_texture", (ArgumentType)StringArgumentType.string());
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> optionalNeedleTextureArgument() {
        return Commands.argument((String)"needle_texture", (ArgumentType)StringArgumentType.string());
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ?> positionAndOptionals(Command<CommandSourceStack> executor) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)SpiffyMarkerCommand.positionArgument().executes(executor)).then(((RequiredArgumentBuilder)SpiffyMarkerCommand.optionalColorArgument().executes(executor)).then(((RequiredArgumentBuilder)SpiffyMarkerCommand.optionalNeedleArgument().executes(executor)).then(((RequiredArgumentBuilder)SpiffyMarkerCommand.optionalDotTextureArgument().executes(executor)).then(SpiffyMarkerCommand.optionalNeedleTextureArgument().executes(executor)))));
    }

    private static int executeAdd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean silence = BoolArgumentType.getBool(context, (String)"silence_command_chat_output");
        try {
            ServerPlayer player = SpiffyMarkerCommand.getCommandPlayer(context);
            String targetElement = SpiffyMarkerCommand.sanitizeTarget(StringArgumentType.getString(context, (String)"target_element"));
            String markerName = SpiffyMarkerCommand.sanitizeMarkerName(StringArgumentType.getString(context, (String)"marker_name"));
            Vec2 pos = Vec2Argument.getVec2(context, (String)"position");
            String posX = SpiffyMarkerCommand.formatPosition(pos.x);
            String posZ = SpiffyMarkerCommand.formatPosition(pos.y);
            String color = SpiffyMarkerCommand.sanitizeOptional(SpiffyMarkerCommand.getOptionalString(context, "color"));
            Boolean showAsNeedle = SpiffyMarkerCommand.getOptionalBool(context, "show_as_needle");
            String dotTexture = SpiffyMarkerCommand.sanitizeOptional(SpiffyMarkerCommand.getOptionalString(context, "dot_texture"));
            String needleTexture = SpiffyMarkerCommand.sanitizeOptional(SpiffyMarkerCommand.getOptionalString(context, "needle_texture"));
            return SpiffyMarkerCommand.dispatchAdd((CommandSourceStack)context.getSource(), player, targetElement, markerName, posX, posZ, color, showAsNeedle, dotTexture, needleTexture, silence);
        }
        catch (CommandSyntaxException ex) {
            if (silence) {
                return 0;
            }
            throw ex;
        }
    }

    private static int executeEdit(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean silence = BoolArgumentType.getBool(context, (String)"silence_command_chat_output");
        try {
            ServerPlayer player = SpiffyMarkerCommand.getCommandPlayer(context);
            String targetElement = SpiffyMarkerCommand.sanitizeTarget(StringArgumentType.getString(context, (String)"target_element"));
            String markerName = SpiffyMarkerCommand.sanitizeMarkerName(StringArgumentType.getString(context, (String)"marker_name"));
            Vec2 pos = Vec2Argument.getVec2(context, (String)"position");
            String posX = SpiffyMarkerCommand.formatPosition(pos.x);
            String posZ = SpiffyMarkerCommand.formatPosition(pos.y);
            EnumSet<MarkerCommandEditField> overrides = EnumSet.noneOf(MarkerCommandEditField.class);
            String color = null;
            if (SpiffyMarkerCommand.wasArgumentProvided(context, "color")) {
                color = SpiffyMarkerCommand.sanitizeOptional(StringArgumentType.getString(context, (String)"color"));
                overrides.add(MarkerCommandEditField.COLOR);
            }
            Boolean showAsNeedle = null;
            if (SpiffyMarkerCommand.wasArgumentProvided(context, "show_as_needle")) {
                showAsNeedle = BoolArgumentType.getBool(context, (String)"show_as_needle");
                overrides.add(MarkerCommandEditField.SHOW_AS_NEEDLE);
            }
            String dotTexture = null;
            if (SpiffyMarkerCommand.wasArgumentProvided(context, "dot_texture")) {
                dotTexture = SpiffyMarkerCommand.sanitizeOptional(StringArgumentType.getString(context, (String)"dot_texture"));
                overrides.add(MarkerCommandEditField.DOT_TEXTURE);
            }
            String needleTexture = null;
            if (SpiffyMarkerCommand.wasArgumentProvided(context, "needle_texture")) {
                needleTexture = SpiffyMarkerCommand.sanitizeOptional(StringArgumentType.getString(context, (String)"needle_texture"));
                overrides.add(MarkerCommandEditField.NEEDLE_TEXTURE);
            }
            return SpiffyMarkerCommand.dispatchEdit((CommandSourceStack)context.getSource(), player, targetElement, markerName, posX, posZ, color, showAsNeedle, dotTexture, needleTexture, overrides, silence);
        }
        catch (CommandSyntaxException ex) {
            if (silence) {
                return 0;
            }
            throw ex;
        }
    }

    private static int executeRemove(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean silence = BoolArgumentType.getBool(context, (String)"silence_command_chat_output");
        try {
            ServerPlayer player = SpiffyMarkerCommand.getCommandPlayer(context);
            String targetElement = SpiffyMarkerCommand.sanitizeTarget(StringArgumentType.getString(context, (String)"target_element"));
            String markerName = SpiffyMarkerCommand.sanitizeMarkerName(StringArgumentType.getString(context, (String)"marker_name"));
            return SpiffyMarkerCommand.dispatchRemove((CommandSourceStack)context.getSource(), player, targetElement, markerName, silence);
        }
        catch (CommandSyntaxException ex) {
            if (silence) {
                return 0;
            }
            throw ex;
        }
    }

    private static int executeClear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean silence = BoolArgumentType.getBool(context, (String)"silence_command_chat_output");
        try {
            ServerPlayer player = SpiffyMarkerCommand.getCommandPlayer(context);
            String targetElement = SpiffyMarkerCommand.sanitizeTarget(StringArgumentType.getString(context, (String)"target_element"));
            return SpiffyMarkerCommand.dispatchClear((CommandSourceStack)context.getSource(), player, targetElement, silence);
        }
        catch (CommandSyntaxException ex) {
            if (silence) {
                return 0;
            }
            throw ex;
        }
    }

    private static int dispatchAdd(CommandSourceStack source, ServerPlayer player, String targetElement, String markerName, String posX, String posZ, @Nullable String color, @Nullable Boolean showAsNeedle, @Nullable String dotTexture, @Nullable String needleTexture, boolean silence) throws CommandSyntaxException {
        MarkerActionConfig config = MarkerActionConfig.defaultConfig();
        config.targetElementIdentifier = targetElement;
        config.uniqueMarkerName = markerName;
        config.positionX = posX;
        config.positionZ = posZ;
        config.colorHex = Objects.requireNonNullElse(color, "");
        config.dotTexture = Objects.requireNonNullElse(dotTexture, "");
        config.needleTexture = Objects.requireNonNullElse(needleTexture, "");
        config.showAsNeedle = showAsNeedle != null && showAsNeedle != false;
        config.normalize();
        return SpiffyMarkerCommand.sendPacket(source, player, MarkerCommandOperation.ADD, config, null, null, silence, "spiffyhud.commands.marker.add.sent", markerName, targetElement);
    }

    private static int dispatchEdit(CommandSourceStack source, ServerPlayer player, String targetElement, String markerName, String posX, String posZ, @Nullable String color, @Nullable Boolean showAsNeedle, @Nullable String dotTexture, @Nullable String needleTexture, @NotNull Set<MarkerCommandEditField> overrides, boolean silence) throws CommandSyntaxException {
        MarkerActionConfig config = MarkerActionConfig.defaultConfig();
        config.targetElementIdentifier = targetElement;
        config.uniqueMarkerName = markerName;
        config.positionX = posX;
        config.positionZ = posZ;
        config.colorHex = Objects.requireNonNullElse(color, "");
        config.dotTexture = Objects.requireNonNullElse(dotTexture, "");
        config.needleTexture = Objects.requireNonNullElse(needleTexture, "");
        config.showAsNeedle = showAsNeedle != null && showAsNeedle != false;
        config.normalize();
        return SpiffyMarkerCommand.sendPacket(source, player, MarkerCommandOperation.EDIT, config, null, overrides, silence, "spiffyhud.commands.marker.edit.sent", markerName, targetElement);
    }

    private static int dispatchRemove(CommandSourceStack source, ServerPlayer player, String targetElement, String markerName, boolean silence) throws CommandSyntaxException {
        MarkerRemovalConfig config = MarkerRemovalConfig.defaultConfig();
        config.targetElementIdentifier = targetElement;
        config.uniqueMarkerName = markerName;
        config.normalize();
        return SpiffyMarkerCommand.sendPacket(source, player, MarkerCommandOperation.REMOVE, null, config, null, silence, "spiffyhud.commands.marker.remove.sent", markerName, targetElement);
    }

    private static int dispatchClear(CommandSourceStack source, ServerPlayer player, String targetElement, boolean silence) throws CommandSyntaxException {
        MarkerRemovalConfig config = MarkerRemovalConfig.defaultConfig();
        config.targetElementIdentifier = targetElement;
        config.uniqueMarkerName = "";
        config.normalize();
        return SpiffyMarkerCommand.sendPacket(source, player, MarkerCommandOperation.CLEAR_GROUP, null, config, null, silence, "spiffyhud.commands.marker.clear.sent", targetElement);
    }

    private static int sendPacket(CommandSourceStack source, ServerPlayer player, @NotNull MarkerCommandOperation operation, @Nullable MarkerActionConfig actionConfig, @Nullable MarkerRemovalConfig removalConfig, @Nullable Set<MarkerCommandEditField> editFields, boolean silence, @NotNull String successTranslationKey, Object ... successArgs) throws CommandSyntaxException {
        if (!PacketHandler.isFancyMenuClient((ServerPlayer)player)) {
            if (silence) {
                return 0;
            }
            throw CLIENT_NOT_SUPPORTED.create();
        }
        MarkerCommandPacket packet = new MarkerCommandPacket();
        packet.operation = operation;
        packet.actionConfig = actionConfig == null ? null : actionConfig.copy();
        MarkerRemovalConfig markerRemovalConfig = packet.removalConfig = removalConfig == null ? null : removalConfig.copy();
        packet.editFields = editFields == null ? null : (editFields.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(editFields));
        packet.silenceClientFeedback = silence;
        PacketHandler.sendToClient((ServerPlayer)player, (Packet)packet);
        if (!silence) {
            source.sendSuccess(() -> Component.translatable((String)successTranslationKey, (Object[])successArgs), true);
        }
        return 1;
    }

    private static ServerPlayer getCommandPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            return ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException ex) {
            throw MUST_BE_PLAYER_EXCEPTION.create();
        }
    }

    @NotNull
    private static String sanitizeTarget(@Nullable String value) throws CommandSyntaxException {
        String trimmed;
        String string = trimmed = value == null ? "" : value.trim();
        if (trimmed.isEmpty()) {
            throw INVALID_TARGET_ELEMENT.create();
        }
        return trimmed;
    }

    @NotNull
    private static String sanitizeMarkerName(@Nullable String value) throws CommandSyntaxException {
        String trimmed;
        String string = trimmed = value == null ? "" : value.trim();
        if (trimmed.isEmpty()) {
            throw INVALID_MARKER_NAME.create();
        }
        return trimmed;
    }

    private static String formatPosition(double value) {
        return POSITION_FORMAT.format(value);
    }

    @Nullable
    private static String sanitizeOptional(@Nullable String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty() || trimmed.equals("-") || trimmed.equalsIgnoreCase("none") || trimmed.equalsIgnoreCase("null")) {
            return null;
        }
        return trimmed;
    }

    @Nullable
    private static String getOptionalString(CommandContext<CommandSourceStack> context, String name) {
        try {
            return StringArgumentType.getString(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Nullable
    private static Boolean getOptionalBool(CommandContext<CommandSourceStack> context, String name) {
        try {
            return BoolArgumentType.getBool(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static boolean wasArgumentProvided(@NotNull CommandContext<CommandSourceStack> context, @NotNull String argumentName) {
        for (ParsedCommandNode node : context.getNodes()) {
            if (node.getNode() == null || !argumentName.equals(node.getNode().getName())) continue;
            return true;
        }
        return false;
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ?> positionArgument() {
        return Commands.argument((String)"position", (ArgumentType)Vec2Argument.vec2());
    }

    private static DecimalFormat buildPositionFormat() {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.ROOT);
        DecimalFormat format = new DecimalFormat("0.########", symbols);
        format.setGroupingUsed(false);
        return format;
    }
}

