/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.spiffyhud.customization.Shared;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiffyGui
implements Renderable {
    public static final SpiffyGui INSTANCE = new SpiffyGui();
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean initialized = false;
    private static SpiffyOverlayScreen spiffyOverlayScreen = new SpiffyOverlayScreen(false);
    private boolean renderingHudContext = false;

    private SpiffyGui() {
        if (!initialized) {
            initialized = true;
        }
        this.setNewOverlayScreen();
        this.initOverlayScreen(false);
        this.tick();
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (!this.shouldRenderCustomizations()) {
            return;
        }
        this.runLayerTask(() -> {
            EventHandler.INSTANCE.postEvent((EventBase)new ScreenTickEvent.Pre((Screen)spiffyOverlayScreen));
            spiffyOverlayScreen.tick();
            EventHandler.INSTANCE.postEvent((EventBase)new ScreenTickEvent.Post((Screen)spiffyOverlayScreen));
            this.restoreRenderDefaults(graphics);
            EventHandler.INSTANCE.postEvent((EventBase)new RenderScreenEvent.Pre((Screen)spiffyOverlayScreen, graphics, mouseX, mouseY, partial));
            spiffyOverlayScreen.render(graphics, mouseX, mouseY, partial);
            this.restoreRenderDefaults(graphics);
            EventHandler.INSTANCE.postEvent((EventBase)new RenderScreenEvent.Post((Screen)spiffyOverlayScreen, graphics, mouseX, mouseY, partial));
            this.restoreRenderDefaults(graphics);
        });
    }

    private void restoreRenderDefaults(@NotNull GuiGraphics graphics) {
    }

    private boolean shouldRenderCustomizations() {
        if (Minecraft.getInstance().screen instanceof LayoutEditorScreen) {
            return false;
        }
        return spiffyOverlayScreen != null && this.getLayer() != null;
    }

    @Nullable
    private ScreenCustomizationLayer getLayer() {
        if (spiffyOverlayScreen == null) {
            return null;
        }
        ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen((Screen)spiffyOverlayScreen);
        if (l != null) {
            l.loadEarly = true;
        }
        return l;
    }

    @NotNull
    public SpiffyOverlayScreen getOverlayScreen() {
        return spiffyOverlayScreen;
    }

    public boolean isRenderingHudContext() {
        return this.renderingHudContext;
    }

    public void onResize() {
        try {
            this.initOverlayScreen(true);
        }
        catch (Exception ex) {
            LOGGER.error("[SPIFFY HUD] Failed to resize SpiffyGui!", (Throwable)ex);
        }
    }

    public void tick() {
        try {
            if (Shared.reInitHudLayouts) {
                Shared.reInitHudLayouts = false;
                this.initOverlayScreen(true);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[SPIFFY HUD] Failed to tick SpiffyGui!", (Throwable)ex);
        }
    }

    private void setNewOverlayScreen() {
        spiffyOverlayScreen = new SpiffyOverlayScreen(false);
        ScreenCustomizationLayerHandler.registerScreen((Screen)spiffyOverlayScreen);
        this.getLayer();
    }

    private void initOverlayScreen(boolean resize) {
        this.runLayerTask(() -> {
            try {
                int cachedScale = Minecraft.getInstance().getWindow().getGuiScale();
                if (!resize) {
                    EventHandler.INSTANCE.postEvent((EventBase)new OpenScreenEvent((Screen)spiffyOverlayScreen));
                }
                SpiffyGui.spiffyOverlayScreen.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
                SpiffyGui.spiffyOverlayScreen.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenStartingEvent((Screen)spiffyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenEvent.Pre((Screen)spiffyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                spiffyOverlayScreen.init(Minecraft.getInstance(), SpiffyGui.spiffyOverlayScreen.width, SpiffyGui.spiffyOverlayScreen.height);
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenEvent.Post((Screen)spiffyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenCompletedEvent((Screen)spiffyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                if (!resize) {
                    EventHandler.INSTANCE.postEvent((EventBase)new OpenScreenPostInitEvent((Screen)spiffyOverlayScreen));
                }
                Minecraft.getInstance().getWindow().setGuiScale(cachedScale);
            }
            catch (Exception ex) {
                LOGGER.error("[SPIFFY HUD] Failed to initialize SpiffyOverlayScreen!", (Throwable)ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLayerTask(@NotNull Runnable run) {
        try {
            boolean customizationEnabled = ScreenCustomization.isScreenCustomizationEnabled();
            ScreenCustomization.setScreenCustomizationEnabled((boolean)true);
            Screen current = Minecraft.getInstance().screen;
            if (!(current instanceof SpiffyOverlayScreen)) {
                Minecraft.getInstance().screen = spiffyOverlayScreen;
                this.renderingHudContext = true;
                try {
                    run.run();
                }
                finally {
                    this.renderingHudContext = false;
                    Minecraft.getInstance().screen = current;
                }
            }
            ScreenCustomization.setScreenCustomizationEnabled((boolean)customizationEnabled);
        }
        catch (Exception ex) {
            LOGGER.error("[SPIFFY HUD] Failed to run layer task!", (Throwable)ex);
        }
    }
}

