/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ObjectHolder;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import de.keksuccino.spiffyhud.customization.elements.Elements;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.air.VanillaLikePlayerAirElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.armor.VanillaLikePlayerArmorElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.bossbars.VanillaLikeBossOverlayElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.contextualbar.VanillaLikeContextualBarElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.effects.VanillaLikeEffectsElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.food.VanillaLikePlayerFoodElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.hotbar.VanillaLikeHotbarElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.mounthealth.VanillaLikeMountHealthElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.playerhealth.VanillaLikePlayerHealthElement;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SpiffyOverlayScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final SpiffyOverlayScreen DUMMY_INSTANCE = new SpiffyOverlayScreen(true);
    private static final ResourceLocation CROSSHAIR_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_background");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_progress");
    private static final ResourceLocation HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_attack_indicator_background");
    private static final ResourceLocation HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_attack_indicator_progress");
    private static final VanillaLikeHotbarElement HOTBAR_ELEMENT = Elements.VANILLA_LIKE_HOTBAR.buildDefaultInstance();
    private static final VanillaLikeContextualBarElement CONTEXTUAL_BAR_ELEMENT = Elements.VANILLA_LIKE_CONTEXTUAL_BAR.buildDefaultInstance();
    private static final VanillaLikePlayerFoodElement FOOD_ELEMENT = Elements.VANILLA_LIKE_PLAYER_FOOD.buildDefaultInstance();
    private static final VanillaLikePlayerArmorElement ARMOR_ELEMENT = Elements.VANILLA_LIKE_PLAYER_ARMOR.buildDefaultInstance();
    private static final VanillaLikePlayerAirElement AIR_ELEMENT = Elements.VANILLA_LIKE_PLAYER_AIR.buildDefaultInstance();
    private static final VanillaLikeMountHealthElement MOUNT_HEALTH_ELEMENT = Elements.VANILLA_LIKE_MOUNT_HEALTH.buildDefaultInstance();
    private static final VanillaLikePlayerHealthElement PLAYER_HEALTH_ELEMENT = Elements.VANILLA_LIKE_PLAYER_HEALTH.buildDefaultInstance();
    private static final VanillaLikeBossOverlayElement BOSS_OVERLAY_ELEMENT = Elements.VANILLA_LIKE_BOSS_OVERLAY.buildDefaultInstance();
    private static final VanillaLikeEffectsElement EFFECTS_ELEMENT = Elements.VANILLA_LIKE_EFFECTS.buildDefaultInstance();
    public final boolean showFancyMenuOverlay;
    protected final Font font;
    protected final Minecraft minecraft;

    public SpiffyOverlayScreen(boolean showFancyMenuOverlay) {
        super((Component)Component.empty());
        this.font = Minecraft.getInstance().font;
        this.minecraft = Minecraft.getInstance();
        this.forceEnableCustomizations();
        this.showFancyMenuOverlay = showFancyMenuOverlay;
    }

    protected void forceEnableCustomizations() {
        if (!ScreenCustomization.isCustomizationEnabledForScreen((Screen)this)) {
            LOGGER.info("[SPIFFY HUD] Force-enabling customizations for SpiffyOverlayScreen..");
            ScreenCustomization.setCustomizationForScreenEnabled((Screen)this, (boolean)true);
        }
    }

    protected void init() {
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildHotbarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.hotbar"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildContextualBarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.experience_bar"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildSelectedItemNameWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.selected_item_name"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildScoreboardSidebarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.scoreboard_sidebar"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildFoodBarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.food_bar"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildArmorBarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.armor_bar"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildAirBarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.air_bar"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildHealthBarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.health_bar"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildMountHealthBarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.mount_health_bar"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildOverlayMessageWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.overlay_message"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildCrosshairWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.crosshair"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildAttackIndicatorWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.attack_indicator"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildTitleWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.title"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildSubtitleWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.subtitle"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildBossBarWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.boss_bars"));
        ((RendererWidget)this.addRenderableWidget((GuiEventListener)this.buildEffectsWidget())).setMessage((Component)Component.translatable((String)"spiffyhud.elements.dummy.effects"));
    }

    public void render(@NotNull GuiGraphics $$0, int $$1, int $$2, float $$3) {
        if (!(Minecraft.getInstance().screen instanceof LayoutEditorScreen)) {
            return;
        }
        this.children().forEach(guiEventListener -> {
            if (guiEventListener instanceof Renderable) {
                Renderable renderable = (Renderable)guiEventListener;
                renderable.render($$0, $$1, $$2, $$3);
            }
        });
    }

    public void renderBackground(GuiGraphics $$0, int $$1, int $$2, float $$3) {
    }

    protected RendererWidget buildHotbarWidget() {
        int screenCenter = this.width / 2;
        int x = screenCenter - 91;
        int y = this.height - 22;
        int widgetWidth = 182;
        int widgetHeight = 22;
        return new SpiffyRendererWidget(x, y, widgetWidth, widgetHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.HOTBAR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.HOTBAR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.HOTBAR_ELEMENT.posOffsetY = gy - 2;
            HOTBAR_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_hotbar_dummy");
    }

    protected RendererWidget buildContextualBarWidget() {
        int screenCenter = this.width / 2;
        int x = screenCenter - 91;
        int y = this.height - 32 + 3;
        int width = 182;
        int height = 5;
        return new SpiffyRendererWidget(x, y, width, height, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.CONTEXTUAL_BAR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.CONTEXTUAL_BAR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.CONTEXTUAL_BAR_ELEMENT.posOffsetY = gy;
            CONTEXTUAL_BAR_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_experience_bar_dummy");
    }

    protected RendererWidget buildSelectedItemNameWidget() {
        MutableComponent mutableComponent = Component.empty().append((Component)Component.translatable((String)"spiffyhud.elements.dummy.selected_item_name")).withStyle(ChatFormatting.LIGHT_PURPLE);
        int textWidth = this.font.width((FormattedText)mutableComponent);
        int textX = (this.width - textWidth) / 2;
        int textY = this.height - 59 - 18;
        Objects.requireNonNull(this.font);
        return new SpiffyRendererWidget(textX, textY, textWidth, 9, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            Objects.requireNonNull(this.font);
            graphics.fill(textX - 2, textY - 2, textX + textWidth + 2, textY + 9 + 2, Minecraft.getInstance().options.getBackgroundColor(0));
            graphics.drawString(this.font, (Component)mutableComponent, textX, textY, -1);
        }).setWidgetIdentifierFancyMenu("spiffy_selected_item_name_dummy");
    }

    protected RendererWidget buildScoreboardSidebarWidget() {
        int titleWidth;
        String spacer = ": ";
        ArrayList<DisplayEntry> entryList = new ArrayList<DisplayEntry>();
        MutableComponent name = Component.translatable((String)"spiffyhud.elements.dummy.scoreboard_sidebar.line");
        MutableComponent score = Component.literal((String)"0").withStyle(ChatFormatting.RED);
        int scoreWidth = this.font.width((FormattedText)score);
        record DisplayEntry(Component name, Component score, int scoreWidth) {
        }
        entryList.add(new DisplayEntry((Component)Component.empty(), (Component)Component.empty(), scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        entryList.add(new DisplayEntry((Component)name, (Component)score, scoreWidth));
        DisplayEntry[] entries = entryList.toArray(new DisplayEntry[0]);
        MutableComponent title = Component.translatable((String)"spiffyhud.elements.dummy.scoreboard_sidebar.title").withStyle(ChatFormatting.BOLD);
        int totalSidebarWidth = titleWidth = this.font.width((FormattedText)title);
        int spacerWidth = this.font.width(spacer);
        for (DisplayEntry entry : entries) {
            totalSidebarWidth = Math.max(totalSidebarWidth, this.font.width((FormattedText)entry.name) + (entry.scoreWidth > 0 ? spacerWidth + entry.scoreWidth : 0));
        }
        int linesCount = entries.length;
        Objects.requireNonNull(this.font);
        int linesHeight = linesCount * 9;
        int sidebarYEnd = this.height / 2 + linesHeight / 3;
        int sidebarXStart = this.width - totalSidebarWidth - 3;
        int sidebarXEnd = this.width - 3 + 2;
        int backgroundColorNormal = this.minecraft.options.getBackgroundColor(0.3f);
        int backgroundColorTitle = this.minecraft.options.getBackgroundColor(0.4f);
        Objects.requireNonNull(this.font);
        int sidebarYBase = sidebarYEnd - linesCount * 9;
        int finalTotalSidebarWidth = totalSidebarWidth;
        Objects.requireNonNull(this.font);
        int sidebarY = sidebarYBase - 9 - 1;
        int sidebarHeight = Math.max(1, sidebarYEnd - sidebarY);
        return new SpiffyRendererWidget(sidebarXStart, sidebarY, totalSidebarWidth, sidebarHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildScoreboardSidebarWidget$4(sidebarXStart, sidebarYBase, sidebarXEnd, backgroundColorTitle, sidebarYEnd, backgroundColorNormal, (Component)title, finalTotalSidebarWidth, titleWidth, linesCount, entries, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_scoreboard_sidebar_dummy");
    }

    protected RendererWidget buildFoodBarWidget() {
        int barX = this.width / 2 + 91;
        int barY = this.height - 39 - 5;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.FOOD_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.FOOD_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.FOOD_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.FOOD_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            FOOD_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_food_bar_dummy");
    }

    protected RendererWidget buildArmorBarWidget() {
        int barX = this.width / 2 - 91;
        int barY = this.height - 39 - 10 - 5;
        return new SpiffyRendererWidget(barX, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.ARMOR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.ARMOR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.ARMOR_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.ARMOR_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_LEFT;
            ARMOR_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_armor_bar_dummy");
    }

    protected RendererWidget buildAirBarWidget() {
        int barX = this.width / 2 + 91;
        int barY = this.height - 39 - 10 - 5;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.AIR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.AIR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.AIR_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.AIR_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            AIR_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_air_bar_dummy");
    }

    protected RendererWidget buildMountHealthBarWidget() {
        int barX = this.width / 2 + 91;
        int barY = this.height - 39 - 10 - 15;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.isUsedAsDummy = true;
            MOUNT_HEALTH_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_mount_health_bar_dummy");
    }

    protected RendererWidget buildHealthBarWidget() {
        int barX = this.width / 2 - 91;
        int barY = this.height - 39 - 5;
        return new SpiffyRendererWidget(barX, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_LEFT;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.isUsedAsDummy = true;
            PLAYER_HEALTH_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_health_bar_dummy");
    }

    protected RendererWidget buildOverlayMessageWidget() {
        MutableComponent message = Component.literal((String)"Overlay Message");
        int messageWidth = this.font.width((FormattedText)message);
        int textX = this.width / 2 - messageWidth / 2;
        int textY = this.height - 68 - 4 - 18;
        ObjectHolder animatedTickHolder = ObjectHolder.of((Object)Float.valueOf(0.0f));
        Objects.requireNonNull(this.font);
        return new SpiffyRendererWidget(textX - 2, textY - 2, messageWidth + 4, 9 + 4, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> SpiffyOverlayScreen.lambda$buildOverlayMessageWidget$10(animatedTickHolder, (Component)message, textX, textY, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_overlay_message_dummy");
    }

    protected RendererWidget buildCrosshairWidget() {
        int crosshairX = (this.width - 15) / 2;
        int crosshairY = (this.height - 15) / 2;
        return new SpiffyRendererWidget(crosshairX, crosshairY, 15, 15, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> graphics.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_SPRITE, crosshairX, crosshairY, 15, 15)).setWidgetIdentifierFancyMenu("spiffy_crosshair_dummy");
    }

    protected RendererWidget buildAttackIndicatorWidget() {
        int crossX = this.width / 2 + 1;
        int crossY = this.height / 2 - 7 + 16 + 40;
        int hotX = crossX - 2 - 18;
        int hotY = crossY - 6;
        float progress = 0.5f;
        return new SpiffyRendererWidget(hotX, hotY, 36, 18, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            int fillWidth = (int)(progress * 16.0f);
            graphics.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, crossX, crossY, 16, 4);
            if (fillWidth > 0) {
                graphics.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, crossX, crossY, fillWidth, 4);
            }
            int fillHeight = (int)(progress * 18.0f);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE, hotX, hotY, 18, 18);
            if (fillHeight > 0) {
                graphics.blitSprite(RenderPipelines.GUI_TEXTURED, HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE, 18, 18, 0, 18 - fillHeight, hotX, hotY + 18 - fillHeight, 18, fillHeight);
            }
        }).setWidgetIdentifierFancyMenu("spiffy_attack_indicator_dummy");
    }

    protected RendererWidget buildTitleWidget() {
        MutableComponent title = Component.translatable((String)"spiffyhud.elements.dummy.title");
        int titleWidth = this.font.width((FormattedText)title);
        int totalWidth = titleWidth * 4;
        Objects.requireNonNull(this.font);
        int totalHeight = 9 * 4;
        int textX = this.width / 2 - totalWidth / 2;
        int textY = this.height / 2 - 48;
        return new SpiffyRendererWidget(textX, textY, totalWidth, totalHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildTitleWidget$13((Component)title, titleWidth, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_title_dummy");
    }

    protected RendererWidget buildSubtitleWidget() {
        MutableComponent subtitle = Component.literal((String)"Subtitle");
        int subtitleWidth = this.font.width((FormattedText)subtitle);
        int totalWidth = subtitleWidth * 2;
        Objects.requireNonNull(this.font);
        int totalHeight = 9 * 2;
        int textX = this.width / 2 - totalWidth / 2;
        int textY = this.height / 2 + 12;
        return new SpiffyRendererWidget(textX, textY, totalWidth, totalHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildSubtitleWidget$14((Component)subtitle, subtitleWidth, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_subtitle_dummy");
    }

    protected RendererWidget buildBossBarWidget() {
        int barX = this.width / 2 - 91;
        int barY = 12;
        int totalY = barY - 9;
        int totalHeight = 53;
        return new SpiffyRendererWidget(barX, totalY, 182, totalHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.spiffyAlignment = SpiffyAlignment.TOP_CENTERED;
            BOSS_OVERLAY_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_boss_bars_dummy");
    }

    protected RendererWidget buildEffectsWidget() {
        return new SpiffyRendererWidget(this.width - 50 - 1, 1, 50, 50, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.EFFECTS_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.spiffyAlignment = SpiffyAlignment.TOP_RIGHT;
            EFFECTS_ELEMENT.render(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_effects_dummy");
    }

    private /* synthetic */ void lambda$buildSubtitleWidget$14(Component subtitle, int subtitleWidth, GuiGraphics graphics, int mX, int mY, float partial, int gx, int gy, int gwidth, int gheight, RendererWidget widget) {
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)(this.width / 2), (float)(this.height / 2));
        graphics.pose().pushMatrix();
        graphics.pose().scale(2.0f, 2.0f);
        graphics.drawString(Minecraft.getInstance().font, subtitle, -subtitleWidth / 2, 6, 0xFFFFFF);
        graphics.pose().popMatrix();
        graphics.pose().popMatrix();
    }

    private /* synthetic */ void lambda$buildTitleWidget$13(Component title, int titleWidth, GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y, int width, int height, RendererWidget widget) {
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)this.width / 2.0f, (float)this.height / 2.0f);
        graphics.pose().pushMatrix();
        graphics.pose().scale(4.0f, 4.0f);
        graphics.drawString(this.font, title, -titleWidth / 2, -12, -1);
        graphics.pose().popMatrix();
        graphics.pose().popMatrix();
    }

    private static /* synthetic */ void lambda$buildOverlayMessageWidget$10(ObjectHolder animatedTickHolder, Component message, int textX, int textY, GuiGraphics graphics, int mX, int mY, float partial, int gx, int gy, int gwidth, int gheight, RendererWidget widget) {
        animatedTickHolder.set((Object)Float.valueOf(((Float)animatedTickHolder.get()).floatValue() + 0.005f));
        int animatedTextColor = Mth.hsvToRgb((float)Mth.clamp((float)(((Float)animatedTickHolder.get()).floatValue() % 1.0f), (float)0.0f, (float)1.0f), (float)0.7f, (float)0.6f) | 0xFF000000;
        graphics.drawString(Minecraft.getInstance().font, message, textX, textY, animatedTextColor);
    }

    private /* synthetic */ void lambda$buildScoreboardSidebarWidget$4(int sidebarXStart, int sidebarYBase, int sidebarXEnd, int backgroundColorTitle, int sidebarYEnd, int backgroundColorNormal, Component title, int finalTotalSidebarWidth, int titleWidth, int linesCount, 1DisplayEntry[] entries, GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y, int width, int height, RendererWidget widget) {
        Objects.requireNonNull(this.font);
        graphics.fill(sidebarXStart - 2, sidebarYBase - 9 - 1, sidebarXEnd, sidebarYBase - 1, backgroundColorTitle);
        graphics.fill(sidebarXStart - 2, sidebarYBase - 1, sidebarXEnd, sidebarYEnd, backgroundColorNormal);
        int n = sidebarXStart + finalTotalSidebarWidth / 2 - titleWidth / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, title, n, sidebarYBase - 9, -1, false);
        for (int t = 0; t < linesCount; ++t) {
            DisplayEntry entry = entries[t];
            Objects.requireNonNull(this.font);
            int u = sidebarYEnd - (linesCount - t) * 9;
            graphics.drawString(this.font, entry.name, sidebarXStart, u, -1, false);
            graphics.drawString(this.font, entry.score, sidebarXEnd - entry.scoreWidth, u, -1, false);
        }
    }

    public static class SpiffyRendererWidget
    extends RendererWidget {
        public SpiffyRendererWidget(int x, int y, int width, int height, @NotNull RendererWidget.RendererWidgetBody body) {
            super(x, y, width, height, body);
        }

        public void render(@NotNull GuiGraphics $$0, int $$1, int $$2, float $$3) {
            if (!(Minecraft.getInstance().screen instanceof LayoutEditorScreen)) {
                return;
            }
            super.render($$0, $$1, $$2, $$3);
        }
    }
}

