/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.chatcustomizer;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.spiffyhud.customization.elements.chatcustomizer.ChatCustomizerHandler;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatCustomizerElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    public String customChatBackgroundColor = null;
    @Nullable
    public String customInputBackgroundColor = null;
    @Nullable
    public String customLineSpacing = null;
    @NotNull
    public ChatCustomizerHandler.ChatCorner chatCorner = ChatCustomizerHandler.ChatCorner.BOTTOM_LEFT;
    protected String lastCustomChatBackgroundColor = null;
    protected String lastCustomInputBackgroundColor = null;
    protected String lastCustomLineSpacing = null;
    protected DrawableColor cachedCustomChatBackgroundColor = null;
    protected DrawableColor cachedCustomInputBackgroundColor = null;
    protected Double cachedCustomLineSpacing = null;

    public ChatCustomizerElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Nullable
    public DrawableColor getCustomChatBackgroundColor() {
        if (this.customChatBackgroundColor != null) {
            String parsedCustomChatBackgroundColor = PlaceholderParser.replacePlaceholders((String)this.customChatBackgroundColor);
            if (!Objects.equals(parsedCustomChatBackgroundColor, this.lastCustomChatBackgroundColor)) {
                this.cachedCustomChatBackgroundColor = DrawableColor.of((String)parsedCustomChatBackgroundColor);
            }
            this.lastCustomChatBackgroundColor = parsedCustomChatBackgroundColor;
        } else {
            this.lastCustomChatBackgroundColor = null;
            this.cachedCustomChatBackgroundColor = null;
        }
        return this.cachedCustomChatBackgroundColor;
    }

    @Nullable
    public DrawableColor getCustomInputBackgroundColor() {
        if (this.customInputBackgroundColor != null) {
            String parsedCustomInputBackgroundColor = PlaceholderParser.replacePlaceholders((String)this.customInputBackgroundColor);
            if (!Objects.equals(parsedCustomInputBackgroundColor, this.lastCustomInputBackgroundColor)) {
                this.cachedCustomInputBackgroundColor = DrawableColor.of((String)parsedCustomInputBackgroundColor);
            }
            this.lastCustomInputBackgroundColor = parsedCustomInputBackgroundColor;
        } else {
            this.lastCustomInputBackgroundColor = null;
            this.cachedCustomInputBackgroundColor = null;
        }
        return this.cachedCustomInputBackgroundColor;
    }

    @Nullable
    public Double getCustomLineSpacing() {
        if (this.customLineSpacing != null) {
            String parsedCustomLineSpacing = PlaceholderParser.replacePlaceholders((String)this.customLineSpacing);
            if (!Objects.equals(parsedCustomLineSpacing, this.lastCustomLineSpacing) && MathUtils.isDouble((String)parsedCustomLineSpacing)) {
                this.cachedCustomLineSpacing = Double.parseDouble(parsedCustomLineSpacing);
            }
            this.lastCustomLineSpacing = parsedCustomLineSpacing;
        } else {
            this.lastCustomLineSpacing = null;
            this.cachedCustomLineSpacing = null;
        }
        return this.cachedCustomLineSpacing;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (ChatCustomizerElement.isEditor()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            graphics.fill(x, y, x + w, y + h, this.inEditorColor.getColorInt());
            graphics.enableScissor(x, y, x + w, y + h);
            Font font = Minecraft.getInstance().font;
            Component component = this.getDisplayName();
            int n = x + w / 2;
            int n2 = y + h / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            graphics.drawCenteredString(font, component, n, n2 - 9 / 2, -1);
            graphics.disableScissor();
        }
    }
}

