/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.compass;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.spiffyhud.customization.marker.MarkerData;
import de.keksuccino.spiffyhud.customization.marker.MarkerStorage;
import de.keksuccino.spiffyhud.util.death.DeathPointStorage;
import de.keksuccino.spiffyhud.util.rendering.FlatMobRenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class CompassElement
extends AbstractElement {
    private static final Minecraft MC = Minecraft.getInstance();
    private static final int DEFAULT_BACKGROUND_COLOR = -1341124592;
    private static final int DEFAULT_BAR_COLOR = -1056964609;
    private static final int DEFAULT_CARDINAL_TICK_COLOR = -1;
    private static final int DEFAULT_DEGREE_TICK_COLOR = -1;
    private static final int DEFAULT_MINOR_TICK_COLOR = -1711276033;
    private static final int DEFAULT_CARDINAL_TEXT_COLOR = -1;
    private static final int DEFAULT_NUMBER_TEXT_COLOR = -2302756;
    private static final int DEFAULT_NEEDLE_COLOR = -47803;
    private static final int DEFAULT_DEATH_POINTER_COLOR = -10042369;
    private static final int DEFAULT_HOSTILE_DOT_COLOR = -46518;
    private static final int DEFAULT_PASSIVE_DOT_COLOR = -7846;
    private static final int MAX_MOB_DOTS_PER_TYPE = 64;
    private static final long MOB_DOTS_REFRESH_RATE_MS = 10L;
    private static final float DEFAULT_DOT_SCALE = 1.0f;
    private static final float DEFAULT_TEXT_SCALE = 1.0f;
    private static final float MIN_DOT_SCALE = 0.2f;
    private static final float MAX_DOT_SCALE = 8.0f;
    private static final float MIN_TEXT_SCALE = 0.2f;
    private static final float MAX_TEXT_SCALE = 8.0f;
    private static final float BASE_DOT_DIAMETER_MIN = 2.0f;
    private static final float BASE_DOT_DIAMETER_MAX = 18.0f;
    private static final float MIN_SCALED_DOT_DIAMETER = 1.0f;
    private static final float MAX_SCALED_DOT_DIAMETER = 64.0f;
    private static final float DEFAULT_TICK_OFFSET = 0.0f;
    private static final float MIN_TICK_OFFSET = -200.0f;
    private static final float MAX_TICK_OFFSET = 200.0f;
    private static final float MARKER_LABEL_DOT_GAP = 5.0f;
    private static final float MARKER_LABEL_NEEDLE_GAP = 5.0f;
    public static final String DEFAULT_BACKGROUND_COLOR_STRING = "#B0101010";
    public static final String DEFAULT_BAR_COLOR_STRING = "#C0FFFFFF";
    public static final String DEFAULT_CARDINAL_TICK_COLOR_STRING = "#FFFFFFFF";
    public static final String DEFAULT_DEGREE_TICK_COLOR_STRING = "#FFFFFFFF";
    public static final String DEFAULT_MINOR_TICK_COLOR_STRING = "#99FFFFFF";
    public static final String DEFAULT_CARDINAL_TEXT_COLOR_STRING = "#FFFFFFFF";
    public static final String DEFAULT_NUMBER_TEXT_COLOR_STRING = "#FFDCDCDC";
    public static final String DEFAULT_NEEDLE_COLOR_STRING = "#FFFF4545";
    public static final String DEFAULT_DEATH_POINTER_COLOR_STRING = "#FF66C3FF";
    public static final String DEFAULT_HOSTILE_DOT_COLOR_STRING = "#FFFF4A4A";
    public static final String DEFAULT_PASSIVE_DOT_COLOR_STRING = "#FFFFE15A";
    public static final String DEFAULT_DOT_SCALE_STRING = "1.0";
    public static final String DEFAULT_TEXT_SCALE_STRING = "1.0";
    public static final String DEFAULT_TICK_OFFSET_STRING = "0";
    public static final String DEFAULT_TEXT_OFFSET_STRING = "0";
    public static final String DEFAULT_HOSTILE_DOT_RANGE_STRING = "200";
    public static final String DEFAULT_PASSIVE_DOT_RANGE_STRING = "200";
    private static final double DEFAULT_HOSTILE_DOT_RANGE = Double.parseDouble("200");
    private static final double DEFAULT_PASSIVE_DOT_RANGE = Double.parseDouble("200");
    @NotNull
    public String backgroundColor = "#B0101010";
    @NotNull
    public String barColor = "#C0FFFFFF";
    @Nullable
    public ResourceSupplier<ITexture> barTexture;
    @NotNull
    public String cardinalTickColor = "#FFFFFFFF";
    @Nullable
    public ResourceSupplier<ITexture> cardinalTickTexture;
    @NotNull
    public String degreeTickColor = "#FFFFFFFF";
    @Nullable
    public ResourceSupplier<ITexture> degreeTickTexture;
    @NotNull
    public String minorTickColor = "#99FFFFFF";
    @Nullable
    public ResourceSupplier<ITexture> minorTickTexture;
    @NotNull
    public String cardinalTextColor = "#FFFFFFFF";
    @NotNull
    public String numberTextColor = "#FFDCDCDC";
    @NotNull
    public String needleColor = "#FFFF4545";
    @Nullable
    public ResourceSupplier<ITexture> northCardinalTexture;
    @Nullable
    public ResourceSupplier<ITexture> eastCardinalTexture;
    @Nullable
    public ResourceSupplier<ITexture> southCardinalTexture;
    @Nullable
    public ResourceSupplier<ITexture> westCardinalTexture;
    @Nullable
    public ResourceSupplier<ITexture> needleTexture;
    @Nullable
    public ResourceSupplier<ITexture> deathPointerTexture;
    @Nullable
    public ResourceSupplier<ITexture> hostileDotTexture;
    @Nullable
    public ResourceSupplier<ITexture> passiveDotTexture;
    @NotNull
    public String hostileDotScale = "1.0";
    @NotNull
    public String passiveDotScale = "1.0";
    @NotNull
    public String markerDotScale = "1.0";
    @NotNull
    public String needleYOffset = "0";
    @NotNull
    public String markerDotYOffset = "0";
    @NotNull
    public String markerNeedleYOffset = "0";
    @NotNull
    public String markerDotLabelXOffset = "0";
    @NotNull
    public String markerDotLabelYOffset = "0";
    @NotNull
    public String markerNeedleLabelXOffset = "0";
    @NotNull
    public String markerNeedleLabelYOffset = "0";
    @NotNull
    public String markerLabelScale = "1.0";
    @NotNull
    public String deathPointerLabelXOffset = "0";
    @NotNull
    public String deathPointerLabelYOffset = "0";
    @NotNull
    public String deathPointerLabelScale = "1.0";
    @NotNull
    public String deathPointerYOffset = "0";
    @NotNull
    public String hostileDotsYOffset = "0";
    @NotNull
    public String passiveDotsYOffset = "0";
    @NotNull
    public String cardinalTickYOffset = "0";
    @NotNull
    public String degreeTickYOffset = "0";
    @NotNull
    public String minorTickYOffset = "0";
    @NotNull
    public String cardinalTextYOffset = "0";
    @NotNull
    public String degreeTextYOffset = "0";
    @NotNull
    public String cardinalTextScale = "1.0";
    @NotNull
    public String degreeTextScale = "1.0";
    public boolean backgroundEnabled = true;
    public boolean barEnabled = true;
    public boolean cardinalTicksEnabled = true;
    public boolean degreeTicksEnabled = true;
    public boolean minorTicksEnabled = true;
    public boolean needleEnabled = true;
    public boolean cardinalTextEnabled = true;
    public boolean degreeNumbersEnabled = true;
    public boolean cardinalOutlineEnabled = true;
    public boolean degreeOutlineEnabled = true;
    public boolean deathPointerEnabled = true;
    public boolean worldMarkersEnabled = true;
    public boolean markerLabelsEnabled = true;
    public boolean markerLabelOutlineEnabled = true;
    public boolean deathPointerLabelEnabled = true;
    public boolean deathPointerLabelOutlineEnabled = true;
    @NotNull
    public String deathPointerColor = "#FF66C3FF";
    public boolean hostileDotsEnabled = true;
    public boolean passiveDotsEnabled = true;
    @NotNull
    public String hostileDotsColor = "#FFFF4A4A";
    @NotNull
    public String passiveDotsColor = "#FFFFE15A";
    @NotNull
    public String hostileDotsRange = "200";
    @NotNull
    public String passiveDotsRange = "200";
    public boolean hostileDotsShowHeads = false;
    public boolean passiveDotsShowHeads = false;
    public boolean mobDotsMoveUpDown = true;
    private boolean hasLastDeathPointerRelative = false;
    private float lastDeathPointerRelative = 0.0f;
    @Nullable
    private Mob previewHostileMob;
    @Nullable
    private Mob previewPassiveMob;
    @Nullable
    private MobDots cachedMobDots;
    private long lastMobDotsCacheTime = -1L;

    public CompassElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.stickyAnchor = true;
        this.stayOnScreen = false;
        this.supportsTilting = false;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (!this.shouldRender()) {
            return;
        }
        int width = Math.max(1, this.getAbsoluteWidth());
        int height = Math.max(6, this.getAbsoluteHeight());
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        CompassReading reading = this.collectReading(partial);
        DeathPointerData deathPointer = this.collectDeathPointer();
        MobDots mobDots = this.cachedMobDots == null ? MobDots.EMPTY : this.cachedMobDots;
        long now = System.currentTimeMillis();
        if (this.cachedMobDots == null || this.lastMobDotsCacheTime + 10L < now) {
            this.lastMobDotsCacheTime = now;
            mobDots = this.cachedMobDots = this.collectMobDots(reading);
        }
        List<ResolvedMarker> resolvedMarkers = this.collectMarkers(reading);
        ResolvedColors colors = this.resolveColors();
        Font font = CompassElement.MC.font;
        CompassLayout layout = this.computeLayout(font, x, y, width, height);
        CompassElement.wrapDepthTestLocked(false, () -> {
            if (this.backgroundEnabled) {
                this.drawBackground(graphics, layout, colors.backgroundColor());
            }
            if (this.barEnabled) {
                this.drawBar(graphics, layout, colors.barColor(), reading);
            }
            this.drawGradeLines(graphics, layout, colors, reading);
            if (this.cardinalTextEnabled) {
                this.drawCardinalLabels(graphics, layout, colors, reading);
            }
            if (this.degreeNumbersEnabled) {
                this.drawDegreeNumbers(graphics, layout, colors, reading);
            }
        });
        if (mobDots.hasAny()) {
            this.drawMobDots(graphics, layout, colors, mobDots);
        }
        CompassElement.wrapDepthTestLocked(false, () -> {
            if (this.needleEnabled) {
                this.drawNeedle(graphics, layout, colors);
            }
            if (!resolvedMarkers.isEmpty()) {
                this.drawMarkerDots(graphics, layout, resolvedMarkers);
                this.drawMarkerNeedles(graphics, layout, resolvedMarkers);
                if (this.markerLabelsEnabled) {
                    this.drawMarkerLabels(graphics, layout, resolvedMarkers, colors);
                }
            }
            this.drawDeathNeedle(graphics, layout, reading, deathPointer, colors);
        });
    }

    private static void wrapDepthTestLocked(boolean enableDepthTest, Runnable wrapped) {
        wrapped.run();
    }

    private void drawBackground(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, int color) {
        graphics.fill(layout.x(), layout.y(), layout.x() + layout.width(), layout.y() + layout.height(), color);
    }

    private void drawBar(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, int color, @NotNull CompassReading reading) {
        if (this.drawBarTexture(graphics, layout, reading)) {
            return;
        }
        graphics.fill(layout.x(), layout.barTop(), layout.x() + layout.width(), layout.barTop() + layout.barHeight(), color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawBarTexture(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull CompassReading reading) {
        TextureHandle handle = this.resolveTexture(this.barTexture);
        if (handle == null) {
            return false;
        }
        int width = Math.max(1, layout.width());
        int barHeight = Math.max(1, layout.barHeight());
        int textureWidth = handle.width();
        int textureHeight = handle.height();
        if (textureWidth <= 0 || textureHeight <= 0) {
            return false;
        }
        int destHeight = Math.max(1, Math.min(barHeight, textureHeight));
        int destWidth = Math.max(1, handle.aspectRatio().getAspectRatioWidth(destHeight));
        float normalizedHeading = Mth.positiveModulo((float)reading.headingDegrees(), (float)360.0f) / 360.0f;
        float pixelShift = normalizedHeading * (float)width;
        float offset = Mth.positiveModulo((float)pixelShift, (float)destWidth);
        float startX = (float)layout.x() - offset - (float)destWidth;
        int maxX = layout.x() + width + destWidth;
        int drawY = layout.barTop() + (layout.barHeight() - destHeight) / 2;
        graphics.enableScissor(layout.x(), layout.barTop(), layout.x() + width, layout.barTop() + barHeight);
        try {
            for (float drawX = startX; drawX < (float)maxX; drawX += (float)destWidth) {
                int drawXi = Mth.floor((float)drawX);
                this.blitBarTextureTile(graphics, handle, drawXi, drawY, destWidth, destHeight);
            }
        }
        finally {
            graphics.disableScissor();
        }
        return true;
    }

    private void blitBarTextureTile(@NotNull GuiGraphics graphics, @NotNull TextureHandle handle, int drawX, int drawY, int destWidth, int destHeight) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, handle.location(), drawX, drawY, 0.0f, 0.0f, destWidth, destHeight, destWidth, destHeight, ARGB.white((float)this.opacity));
    }

    private void drawGradeLines(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull ResolvedColors colors, @NotNull CompassReading reading) {
        boolean drawCardinal = this.cardinalTicksEnabled;
        boolean drawDegree = this.degreeTicksEnabled;
        boolean drawMinor = this.minorTicksEnabled;
        if (!(drawCardinal || drawDegree || drawMinor)) {
            return;
        }
        float cardinalTickOffset = this.resolveCardinalTickYOffset();
        float degreeTickOffset = this.resolveDegreeTickYOffset();
        float minorTickOffset = this.resolveMinorTickYOffset();
        for (int degrees = -180; degrees <= 180; degrees += 10) {
            int absolute = CompassElement.toAbsoluteDegrees(degrees);
            boolean majorCandidate = absolute % 30 == 0;
            float relative = this.relativeToHeading(absolute, reading.headingDegrees());
            if (majorCandidate) {
                boolean cardinalTick;
                boolean bl = cardinalTick = absolute % 90 == 0;
                if (cardinalTick) {
                    if (!drawCardinal) continue;
                    this.drawTick(graphics, layout, relative, layout.majorTickHalfHeight(), colors.cardinalTickColor(), this.cardinalTickTexture, cardinalTickOffset);
                    continue;
                }
                if (!drawDegree) continue;
                this.drawTick(graphics, layout, relative, layout.majorTickHalfHeight(), colors.degreeTickColor(), this.degreeTickTexture, degreeTickOffset);
                continue;
            }
            if (!drawMinor) continue;
            this.drawTick(graphics, layout, relative, layout.minorTickHalfHeight(), colors.minorTickColor(), this.minorTickTexture, minorTickOffset);
        }
    }

    private void drawTick(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, float relativeDegrees, int halfHeight, int color, @Nullable ResourceSupplier<ITexture> texture, float offsetY) {
        float x = this.computeScreenX(layout, relativeDegrees);
        if (this.drawTickTexture(graphics, layout, x, texture, offsetY)) {
            return;
        }
        int xi = Mth.clamp((int)Mth.floor((float)x), (int)layout.x(), (int)(layout.x() + layout.width() - 1));
        int offset = Mth.floor((float)offsetY);
        int top = layout.barCenterY() - halfHeight + offset;
        int bottom = layout.barCenterY() + halfHeight + offset;
        graphics.fill(xi, top, xi + 1, bottom, color);
    }

    private boolean drawTickTexture(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, float centerX, @Nullable ResourceSupplier<ITexture> supplier, float offsetY) {
        TextureHandle handle = this.resolveTexture(supplier);
        if (handle == null) {
            return false;
        }
        int destHeight = Math.max(1, layout.height());
        int availableWidth = Math.max(1, layout.width());
        int computedWidth = handle.aspectRatio().getAspectRatioWidth(destHeight);
        int destWidth = Math.max(1, Math.min(computedWidth, availableWidth));
        float drawX = centerX - (float)destWidth / 2.0f;
        int drawXi = Mth.floor((float)drawX);
        int drawYi = layout.y() + Mth.floor((float)offsetY);
        graphics.blit(RenderPipelines.GUI_TEXTURED, handle.location(), drawXi, drawYi, 0.0f, 0.0f, destWidth, destHeight, destWidth, destHeight, ARGB.white((float)this.opacity));
        return true;
    }

    private void drawCardinalLabels(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull ResolvedColors colors, @NotNull CompassReading reading) {
        String[] labels = new String[]{"N", "E", "S", "W"};
        float[] angles = new float[]{0.0f, 90.0f, 180.0f, 270.0f};
        float offset = this.resolveCardinalTextYOffset();
        for (int i = 0; i < labels.length; ++i) {
            this.drawCardinal(graphics, layout, angles[i], labels[i], colors.cardinalTextColor(), reading, offset);
        }
    }

    private void drawCardinal(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, float absoluteDegrees, @NotNull String text, int color, @NotNull CompassReading reading, float offsetY) {
        float relative = this.relativeToHeading(absoluteDegrees, reading.headingDegrees());
        float centerX = this.computeScreenX(layout, relative);
        float centerY = layout.cardinalCenterY() + offsetY;
        ResourceSupplier<ITexture> texture = this.getCardinalTexture(text);
        if (texture != null && this.drawCardinalTexture(graphics, layout, centerX, centerY, layout.cardinalScale(), texture)) {
            return;
        }
        this.drawScaledCenteredString(graphics, text, centerX, centerY, layout.cardinalScale(), color, this.cardinalOutlineEnabled);
    }

    private void drawDegreeNumbers(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull ResolvedColors colors, @NotNull CompassReading reading) {
        float offset = this.resolveDegreeTextYOffset();
        for (int degrees = -150; degrees <= 150; degrees += 30) {
            int absolute;
            if (degrees == 0 || (absolute = CompassElement.toAbsoluteDegrees(degrees)) % 90 == 0) continue;
            String label = Integer.toString(absolute);
            float relative = this.relativeToHeading(absolute, reading.headingDegrees());
            float centerX = this.computeScreenX(layout, relative);
            this.drawScaledCenteredString(graphics, label, centerX, layout.degreeNumberCenterY() + offset, layout.degreeNumberScale(), colors.degreeNumberTextColor(), this.degreeOutlineEnabled);
        }
    }

    private void drawMobDots(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull ResolvedColors colors, @NotNull MobDots dots) {
        if (!dots.hasAny()) {
            return;
        }
        float minY = layout.y();
        float maxY = layout.y() + layout.height();
        float markerCenter = (float)layout.y() + (float)layout.height() / 2.0f;
        float baseDiameter = this.computeBaseDotDiameter(layout);
        float hostileRadius = this.computeScaledRadius(baseDiameter, this.resolveHostileDotScale());
        float passiveRadius = this.computeScaledRadius(baseDiameter, this.resolvePassiveDotScale());
        float hostileOffset = this.resolveHostileDotsYOffset();
        float passiveOffset = this.resolvePassiveDotsYOffset();
        boolean drawHostileHeads = this.hostileDotsShowHeads;
        boolean moveWithDistance = this.mobDotsMoveUpDown;
        if (!dots.hostileDots().isEmpty()) {
            for (MobDotData data : dots.hostileDots()) {
                float animatedCenter = moveWithDistance ? this.computeDotCenterY(minY, maxY, data.distanceRatio()) : markerCenter;
                float centerY = animatedCenter + hostileOffset;
                this.drawMobDot(graphics, layout, data, centerY, hostileRadius, drawHostileHeads, colors.hostileDotColor(), this.hostileDotTexture);
            }
        }
        boolean drawPassiveHeads = this.passiveDotsShowHeads;
        if (!dots.passiveDots().isEmpty()) {
            for (MobDotData data : dots.passiveDots()) {
                float animatedCenter = moveWithDistance ? this.computeDotCenterY(minY, maxY, data.distanceRatio()) : markerCenter;
                float centerY = animatedCenter + passiveOffset;
                this.drawMobDot(graphics, layout, data, centerY, passiveRadius, drawPassiveHeads, colors.passiveDotColor(), this.passiveDotTexture);
            }
        }
    }

    private float computeDotCenterY(float minY, float maxY, float ratio) {
        float clampedRatio = Mth.clamp((float)ratio, (float)0.0f, (float)1.0f);
        return Mth.clamp((float)Mth.lerp((float)clampedRatio, (float)minY, (float)maxY), (float)minY, (float)maxY);
    }

    private float computeBaseDotDiameter(@NotNull CompassLayout layout) {
        return Mth.clamp((float)((float)layout.height() * 0.12f), (float)2.0f, (float)18.0f);
    }

    private float computeScaledRadius(float baseDiameter, float scaleMultiplier) {
        float scaledDiameter = Mth.clamp((float)(baseDiameter * scaleMultiplier), (float)1.0f, (float)64.0f);
        return Math.max(1.0f, scaledDiameter / 2.0f);
    }

    private void drawMobDot(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull MobDotData data, float centerY, float radius, boolean drawHead, int color, @Nullable ResourceSupplier<ITexture> texture) {
        float centerX = this.computeScreenX(layout, data.relativeDegrees());
        int size = Math.max(2, Mth.ceil((float)(radius * 2.0f)));
        DotBounds bounds = this.computeDotBounds(layout, centerX, centerY, radius, size);
        if (drawHead && this.drawMobHead(graphics, bounds, data.mob())) {
            return;
        }
        if (this.drawDotTexture(graphics, bounds, texture)) {
            return;
        }
        graphics.fill(bounds.left(), bounds.top(), bounds.left() + bounds.size(), bounds.top() + bounds.size(), color);
    }

    private void drawMarkerDots(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull List<ResolvedMarker> markers) {
        float baseDiameter = this.computeBaseDotDiameter(layout);
        float radius = this.computeScaledRadius(baseDiameter, this.resolveMarkerDotScale());
        float centerY = (float)layout.y() + (float)layout.height() / 2.0f + this.resolveMarkerDotYOffset();
        for (ResolvedMarker marker : markers) {
            if (marker.showAsNeedle()) continue;
            this.drawMarkerDot(graphics, layout, marker, centerY, radius);
        }
    }

    private void drawMarkerDot(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull ResolvedMarker marker, float centerY, float radius) {
        float centerX = this.computeScreenX(layout, marker.relativeDegrees());
        int size = Math.max(2, Mth.ceil((float)(radius * 2.0f)));
        DotBounds bounds = this.computeDotBounds(layout, centerX, centerY, radius, size);
        ResourceSupplier<ITexture> texture = marker.dotTexture();
        if (texture == null) {
            texture = marker.needleTexture();
        }
        if (texture != null && this.drawDotTexture(graphics, bounds, texture)) {
            return;
        }
        graphics.fill(bounds.left(), bounds.top(), bounds.left() + bounds.size(), bounds.top() + bounds.size(), marker.color());
    }

    private void drawMarkerNeedles(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull List<ResolvedMarker> markers) {
        float offset = this.resolveMarkerNeedleYOffset();
        for (ResolvedMarker marker : markers) {
            if (!marker.showAsNeedle()) continue;
            this.drawMarkerNeedle(graphics, layout, marker, offset);
        }
    }

    private void drawMarkerNeedle(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull ResolvedMarker marker, float offsetY) {
        float centerX = this.computeScreenX(layout, marker.relativeDegrees());
        ResourceSupplier<ITexture> texture = marker.needleTexture();
        if (texture == null) {
            texture = marker.dotTexture();
        }
        float centerY = (float)layout.y() + (float)layout.height() / 2.0f + offsetY;
        if (texture != null && this.drawNeedleTexture(graphics, layout, centerX, centerY, texture, true, false)) {
            return;
        }
        int needleWidth = Math.max(1, Mth.floor((float)((float)layout.width() * 0.008f)));
        int half = Math.max(0, needleWidth / 2);
        int xi = Mth.clamp((int)(Mth.floor((float)centerX) - half), (int)layout.x(), (int)(layout.x() + layout.width() - needleWidth));
        int pixelOffset = Mth.floor((float)offsetY);
        int top = layout.y() + pixelOffset;
        graphics.fill(xi, top, xi + needleWidth, top + layout.height(), marker.color());
    }

    private void drawMarkerLabels(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull List<ResolvedMarker> markers, @NotNull ResolvedColors colors) {
        if (markers.isEmpty()) {
            return;
        }
        float baseDiameter = this.computeBaseDotDiameter(layout);
        float dotRadius = this.computeScaledRadius(baseDiameter, this.resolveMarkerDotScale());
        float dotCenterY = (float)layout.y() + (float)layout.height() / 2.0f + this.resolveMarkerDotYOffset();
        float needleCenterY = (float)layout.y() + (float)layout.height() / 2.0f + this.resolveMarkerNeedleYOffset();
        float labelScale = this.computeBaseNumberScale(layout) * this.resolveMarkerLabelScaleMultiplier();
        float dotLabelXOffset = this.resolveMarkerDotLabelXOffset();
        float dotLabelYOffset = this.resolveMarkerDotLabelYOffset();
        float needleLabelXOffset = this.resolveMarkerNeedleLabelXOffset();
        float needleLabelYOffset = this.resolveMarkerNeedleLabelYOffset();
        int textColor = colors.degreeNumberTextColor();
        boolean outline = this.markerLabelOutlineEnabled;
        for (ResolvedMarker marker : markers) {
            float drawY;
            String label = this.formatMarkerDistance(marker.distanceMeters());
            if (label.isEmpty()) continue;
            float centerX = this.computeScreenX(layout, marker.relativeDegrees());
            boolean showAsNeedle = marker.showAsNeedle();
            float drawX = centerX + (showAsNeedle ? needleLabelXOffset : dotLabelXOffset);
            if (showAsNeedle) {
                float needleBottom = needleCenterY + (float)layout.height() / 2.0f;
                drawY = needleBottom + 5.0f + needleLabelYOffset;
            } else {
                drawY = dotCenterY + dotRadius + 5.0f + dotLabelYOffset;
            }
            this.drawMarkerLabel(graphics, label, drawX, drawY, labelScale, textColor, outline);
        }
    }

    private void drawMarkerLabel(@NotNull GuiGraphics graphics, @NotNull String text, float centerX, float centerY, float scale, int textColor, boolean outline) {
        if (text.isEmpty() || scale <= 0.0f) {
            return;
        }
        this.drawScaledCenteredString(graphics, text, centerX, centerY, scale, textColor, outline);
    }

    @NotNull
    private String formatMarkerDistance(float distanceMeters) {
        if (!Float.isFinite(distanceMeters)) {
            return "";
        }
        int meters = Math.max(0, Math.round(distanceMeters));
        return meters + "m";
    }

    private DotBounds computeDotBounds(@NotNull CompassLayout layout, float centerX, float centerY, float radius, int size) {
        int maxWidth = Math.max(1, layout.width());
        int maxHeight = Math.max(1, layout.height());
        int minX = layout.x();
        int minY = layout.y();
        int maxLeft = Math.max(minX, minX + maxWidth - size);
        int maxTop = Math.max(minY, minY + maxHeight - size);
        int left = Mth.clamp((int)Mth.floor((float)(centerX - radius)), (int)minX, (int)maxLeft);
        int top = Mth.clamp((int)Mth.floor((float)(centerY - radius)), (int)minY, (int)maxTop);
        return new DotBounds(left, top, size);
    }

    private boolean drawDotTexture(@NotNull GuiGraphics graphics, @NotNull DotBounds bounds, @Nullable ResourceSupplier<ITexture> supplier) {
        TextureHandle handle = this.resolveTexture(supplier);
        if (handle == null) {
            return false;
        }
        int size = bounds.size();
        graphics.blit(RenderPipelines.GUI_TEXTURED, handle.location(), bounds.left(), bounds.top(), 0.0f, 0.0f, size, size, size, size, ARGB.white((float)this.opacity));
        return true;
    }

    private boolean drawMobHead(@NotNull GuiGraphics graphics, @NotNull DotBounds bounds, @Nullable Mob mob) {
        if (mob == null) {
            return false;
        }
        return FlatMobRenderUtils.renderFlatMob(graphics, bounds.left(), bounds.top(), bounds.size(), mob, this.opacity);
    }

    private void drawNeedle(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull ResolvedColors colors) {
        int needleWidth = Math.max(1, Mth.floor((float)((float)layout.width() * 0.01f)));
        int half = Math.max(0, needleWidth / 2);
        int centerX = layout.x() + layout.width() / 2;
        float offset = this.resolveNeedleYOffset();
        float centerY = (float)layout.y() + (float)layout.height() / 2.0f + offset;
        if (this.drawNeedleTexture(graphics, layout, centerX, centerY, this.needleTexture, true, false)) {
            return;
        }
        int xi = Mth.clamp((int)(centerX - half), (int)layout.x(), (int)(layout.x() + layout.width() - needleWidth));
        int pixelOffset = Mth.floor((float)offset);
        int top = layout.y() + pixelOffset;
        graphics.fill(xi, top, xi + needleWidth, top + layout.height(), colors.needleColor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawDeathNeedle(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull CompassReading reading, @Nullable DeathPointerData pointer, @NotNull ResolvedColors colors) {
        if (pointer == null) {
            this.hasLastDeathPointerRelative = false;
            return;
        }
        float signedHeading = CompassElement.toSigned(reading.headingDegrees());
        float relative = pointer.signedDegrees() - signedHeading;
        relative = this.adjustDeathPointerRelative(relative);
        float centerX = this.computeScreenXUnbounded(layout, relative);
        float offset = this.resolveDeathPointerYOffset();
        float centerY = (float)layout.y() + (float)layout.height() / 2.0f + offset;
        graphics.enableScissor(layout.x(), layout.y() - 200, layout.x() + layout.width(), layout.y() + layout.height() + 200);
        try {
            boolean textured = this.drawNeedleTexture(graphics, layout, centerX, centerY, this.deathPointerTexture, false, true);
            if (!textured) {
                this.drawDeathNeedleStrips(graphics, layout, centerX, colors.deathNeedleColor(), offset);
            }
        }
        finally {
            graphics.disableScissor();
        }
        this.drawDeathPointerLabel(graphics, layout, pointer, centerX, centerY, colors);
    }

    private void drawDeathPointerLabel(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, @NotNull DeathPointerData pointer, float needleCenterX, float needleCenterY, @NotNull ResolvedColors colors) {
        if (!this.deathPointerLabelEnabled) {
            return;
        }
        String label = this.formatMarkerDistance(pointer.distanceMeters());
        if (label.isEmpty()) {
            return;
        }
        float normalizedCenterX = this.normalizeCenterForWrap(layout, needleCenterX);
        float drawX = normalizedCenterX + this.resolveDeathPointerLabelXOffset();
        int minX = layout.x();
        int maxX = layout.x() + layout.width();
        if (maxX > minX) {
            drawX = Mth.clamp((float)drawX, (float)minX, (float)maxX);
        }
        float pointerBottom = needleCenterY + (float)layout.height() / 2.0f;
        float drawY = pointerBottom + 5.0f + this.resolveDeathPointerLabelYOffset();
        float scale = this.computeBaseNumberScale(layout) * this.resolveDeathPointerLabelScaleMultiplier();
        this.drawMarkerLabel(graphics, label, drawX, drawY, scale, colors.degreeNumberTextColor(), this.deathPointerLabelOutlineEnabled);
    }

    private boolean drawNeedleTexture(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, float centerX, float centerY, @Nullable ResourceSupplier<ITexture> supplier, boolean clampCenter, boolean wrapAcross) {
        TextureHandle handle = this.resolveTexture(supplier);
        if (handle == null) {
            return false;
        }
        if (wrapAcross) {
            float normalizedCenter = this.normalizeCenterForWrap(layout, centerX);
            this.drawNeedleTextureInstance(graphics, layout, normalizedCenter - (float)layout.width(), centerY, handle, clampCenter);
            this.drawNeedleTextureInstance(graphics, layout, normalizedCenter, centerY, handle, clampCenter);
            this.drawNeedleTextureInstance(graphics, layout, normalizedCenter + (float)layout.width(), centerY, handle, clampCenter);
        } else {
            this.drawNeedleTextureInstance(graphics, layout, centerX, centerY, handle, clampCenter);
        }
        return true;
    }

    private void drawNeedleTextureInstance(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, float centerX, float centerY, @NotNull TextureHandle handle, boolean clampCenter) {
        int availableWidth = Math.max(1, layout.width());
        int availableHeight = Math.max(1, layout.height());
        if (handle.width() <= 0 || handle.height() <= 0) {
            return;
        }
        int[] scaled = handle.aspectRatio().getAspectRatioSizeByMaximumSize(availableWidth, availableHeight);
        int destWidth = Math.max(1, Math.min(scaled[0], availableWidth));
        int destHeight = Math.max(1, Math.min(scaled[1], availableHeight));
        float targetCenterX = clampCenter ? Mth.clamp((float)centerX, (float)layout.x(), (float)(layout.x() + layout.width())) : centerX;
        float resolvedCenterY = clampCenter ? Mth.clamp((float)centerY, (float)layout.y(), (float)(layout.y() + layout.height())) : centerY;
        float drawX = targetCenterX - (float)destWidth / 2.0f;
        float drawY = resolvedCenterY - (float)destHeight / 2.0f;
        if (clampCenter) {
            float minX = layout.x();
            float maxX = layout.x() + layout.width();
            drawX = Mth.clamp((float)drawX, (float)minX, (float)(maxX - (float)destWidth));
        }
        if (clampCenter) {
            float minY = layout.y();
            float maxY = layout.y() + layout.height();
            drawY = Mth.clamp((float)drawY, (float)minY, (float)(maxY - (float)destHeight));
        }
        int drawXi = Mth.floor((float)drawX);
        int drawYi = Mth.floor((float)drawY);
        graphics.blit(RenderPipelines.GUI_TEXTURED, handle.location(), drawXi, drawYi, 0.0f, 0.0f, destWidth, destHeight, destWidth, destHeight, ARGB.white((float)this.opacity));
    }

    private boolean drawCardinalTexture(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, float centerX, float centerY, float scale, @Nullable ResourceSupplier<ITexture> supplier) {
        if (scale <= 0.0f) {
            return false;
        }
        TextureHandle handle = this.resolveTexture(supplier);
        if (handle == null) {
            return false;
        }
        int availableWidth = Math.max(1, layout.width());
        int availableHeight = Math.max(1, layout.height());
        Objects.requireNonNull(CompassElement.MC.font);
        float scaledHeight = Math.max(1.0f, 9.0f * scale);
        int destHeight = Math.max(1, Math.min(Mth.floor((float)scaledHeight), availableHeight));
        int destWidth = Math.max(1, Math.min(handle.aspectRatio().getAspectRatioWidth(destHeight), availableWidth));
        float drawX = centerX - (float)destWidth / 2.0f;
        float drawY = centerY - (float)destHeight / 2.0f;
        int drawXi = Mth.floor((float)drawX);
        int drawYi = Mth.floor((float)drawY);
        graphics.blit(RenderPipelines.GUI_TEXTURED, handle.location(), drawXi, drawYi, 0.0f, 0.0f, destWidth, destHeight, destWidth, destHeight, ARGB.white((float)this.opacity));
        return true;
    }

    @Nullable
    private ResourceSupplier<ITexture> getCardinalTexture(@NotNull String label) {
        return switch (label) {
            case "N" -> this.northCardinalTexture;
            case "E" -> this.eastCardinalTexture;
            case "S" -> this.southCardinalTexture;
            case "W" -> this.westCardinalTexture;
            default -> null;
        };
    }

    @Nullable
    private TextureHandle resolveTexture(@Nullable ResourceSupplier<ITexture> supplier) {
        if (supplier == null) {
            return null;
        }
        try {
            ITexture texture = (ITexture)supplier.get();
            if (texture == null || !texture.isReady()) {
                return null;
            }
            ResourceLocation location = texture.getResourceLocation();
            if (location == null) {
                return null;
            }
            int width = texture.getWidth();
            int height = texture.getHeight();
            if (width <= 0 || height <= 0) {
                return null;
            }
            return new TextureHandle(location, width, height, texture.getAspectRatio());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private float computeScreenX(@NotNull CompassLayout layout, float signedDegrees) {
        float clamped = Mth.clamp((float)signedDegrees, (float)-180.0f, (float)180.0f);
        float normalized = clamped / 360.0f + 0.5f;
        float px = (float)layout.x() + normalized * (float)layout.width();
        return Mth.clamp((float)px, (float)layout.x(), (float)(layout.x() + layout.width() - 1));
    }

    private float computeScreenXUnbounded(@NotNull CompassLayout layout, float signedDegrees) {
        float normalized = signedDegrees / 360.0f + 0.5f;
        return (float)layout.x() + normalized * (float)layout.width();
    }

    private float computeBaseNumberScale(@NotNull CompassLayout layout) {
        float baseScale = Mth.clamp((float)((float)layout.height() / 60.0f), (float)0.55f, (float)3.0f);
        return Math.max(0.4f, baseScale * 0.8f);
    }

    private void drawScaledCenteredString(@NotNull GuiGraphics graphics, @NotNull String text, float centerX, float centerY, float scale, int color, boolean outline) {
        if (text.isEmpty() || scale <= 0.0f) {
            return;
        }
        Font font = CompassElement.MC.font;
        float textWidth = (float)font.width(text) * scale;
        Objects.requireNonNull(font);
        float textHeight = 9.0f * scale;
        float drawX = centerX - textWidth / 2.0f;
        float drawY = centerY - textHeight / 2.0f;
        Matrix3x2fStack pose = graphics.pose();
        pose.pushMatrix();
        pose.translate(drawX, drawY);
        pose.scale(scale, scale);
        if (outline) {
            int blackColor = this.applyOpacity(DrawableColor.BLACK.getColorInt());
            graphics.drawString(font, text, -1, 0, blackColor, false);
            graphics.drawString(font, text, 0, -1, blackColor, false);
            graphics.drawString(font, text, 1, 0, blackColor, false);
            graphics.drawString(font, text, 0, 1, blackColor, false);
            graphics.drawString(font, text, -1, -1, blackColor, false);
            graphics.drawString(font, text, 1, -1, blackColor, false);
            graphics.drawString(font, text, 1, 1, blackColor, false);
            graphics.drawString(font, text, -1, 1, blackColor, false);
        }
        graphics.drawString(font, text, 0, 0, color, false);
        pose.popMatrix();
    }

    private ResolvedColors resolveColors() {
        return new ResolvedColors(this.applyOpacity(this.parseColor(this.backgroundColor, -1341124592)), this.applyOpacity(this.parseColor(this.barColor, -1056964609)), this.applyOpacity(this.parseColor(this.cardinalTickColor, -1)), this.applyOpacity(this.parseColor(this.degreeTickColor, -1)), this.applyOpacity(this.parseColor(this.minorTickColor, -1711276033)), this.applyOpacity(this.parseColor(this.cardinalTextColor, -1)), this.applyOpacity(this.parseColor(this.numberTextColor, -2302756)), this.applyOpacity(this.parseColor(this.needleColor, -47803)), this.applyOpacity(this.parseColor(this.deathPointerColor, -10042369)), this.applyOpacity(this.parseColor(this.hostileDotsColor, -46518)), this.applyOpacity(this.parseColor(this.passiveDotsColor, -7846)));
    }

    private int applyOpacity(int argb) {
        int alpha = argb >>> 24 & 0xFF;
        int rgb = argb & 0xFFFFFF;
        int adjustedAlpha = (int)Mth.clamp((float)((float)alpha * this.opacity), (float)0.0f, (float)255.0f);
        return adjustedAlpha << 24 | rgb;
    }

    private int parseColor(@Nullable String configured, int fallback) {
        DrawableColor drawable;
        String replaced;
        if (configured != null && !configured.isBlank() && !(replaced = PlaceholderParser.replacePlaceholders((String)configured).trim()).isEmpty() && (drawable = DrawableColor.of((String)replaced)) != DrawableColor.EMPTY) {
            return drawable.getColorInt();
        }
        return fallback;
    }

    private float resolveHostileDotScale() {
        return this.resolveDotScale(this.hostileDotScale);
    }

    private float resolvePassiveDotScale() {
        return this.resolveDotScale(this.passiveDotScale);
    }

    private float resolveMarkerDotScale() {
        return this.resolveDotScale(this.markerDotScale);
    }

    private float resolveNeedleYOffset() {
        return this.resolveClampedFloat(this.needleYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveMarkerDotYOffset() {
        return this.resolveClampedFloat(this.markerDotYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveMarkerNeedleYOffset() {
        return this.resolveClampedFloat(this.markerNeedleYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveMarkerDotLabelXOffset() {
        return this.resolveClampedFloat(this.markerDotLabelXOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveMarkerDotLabelYOffset() {
        return this.resolveClampedFloat(this.markerDotLabelYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveMarkerNeedleLabelXOffset() {
        return this.resolveClampedFloat(this.markerNeedleLabelXOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveMarkerNeedleLabelYOffset() {
        return this.resolveClampedFloat(this.markerNeedleLabelYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveDeathPointerLabelXOffset() {
        return this.resolveClampedFloat(this.deathPointerLabelXOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveDeathPointerLabelYOffset() {
        return this.resolveClampedFloat(this.deathPointerLabelYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveDeathPointerYOffset() {
        return this.resolveClampedFloat(this.deathPointerYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveHostileDotsYOffset() {
        return this.resolveClampedFloat(this.hostileDotsYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolvePassiveDotsYOffset() {
        return this.resolveClampedFloat(this.passiveDotsYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveCardinalTickYOffset() {
        return this.resolveClampedFloat(this.cardinalTickYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveDegreeTickYOffset() {
        return this.resolveClampedFloat(this.degreeTickYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveMinorTickYOffset() {
        return this.resolveClampedFloat(this.minorTickYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveCardinalTextYOffset() {
        return this.resolveClampedFloat(this.cardinalTextYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveDegreeTextYOffset() {
        return this.resolveClampedFloat(this.degreeTextYOffset, 0.0f, -200.0f, 200.0f);
    }

    private float resolveCardinalTextScaleMultiplier() {
        return this.resolveClampedFloat(this.cardinalTextScale, 1.0f, 0.2f, 8.0f);
    }

    private float resolveDegreeTextScaleMultiplier() {
        return this.resolveClampedFloat(this.degreeTextScale, 1.0f, 0.2f, 8.0f);
    }

    private float resolveMarkerLabelScaleMultiplier() {
        return this.resolveClampedFloat(this.markerLabelScale, 1.0f, 0.2f, 8.0f);
    }

    private float resolveDeathPointerLabelScaleMultiplier() {
        return this.resolveClampedFloat(this.deathPointerLabelScale, 1.0f, 0.2f, 8.0f);
    }

    private float resolveDotScale(@Nullable String configured) {
        return this.resolveClampedFloat(configured, 1.0f, 0.2f, 8.0f);
    }

    private double resolveMobDotsRange(@Nullable String configured, double fallback) {
        if (configured == null || configured.isBlank()) {
            return Math.max(0.0, fallback);
        }
        String replaced = PlaceholderParser.replacePlaceholders((String)configured).trim();
        if (!replaced.isEmpty() && MathUtils.isDouble((String)replaced)) {
            try {
                double parsed = Double.parseDouble(replaced);
                if (!Double.isFinite(parsed)) {
                    return Math.max(0.0, fallback);
                }
                return Math.max(0.0, parsed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Math.max(0.0, fallback);
    }

    private float resolveClampedFloat(@Nullable String configured, float fallback, float min, float max) {
        if (configured == null || configured.isBlank()) {
            return fallback;
        }
        String replaced = PlaceholderParser.replacePlaceholders((String)configured).trim();
        if (!replaced.isEmpty() && MathUtils.isFloat((String)replaced)) {
            try {
                float parsed = Float.parseFloat(replaced);
                if (!Float.isFinite(parsed)) {
                    return fallback;
                }
                return Mth.clamp((float)parsed, (float)min, (float)max);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fallback;
    }

    @NotNull
    public List<MarkerData> getMarkers() {
        return MarkerStorage.getMarkers(this.getMarkerGroupKey());
    }

    public boolean addMarker(@NotNull MarkerData marker) {
        return MarkerStorage.addMarker(this.getMarkerGroupKey(), marker);
    }

    public boolean editMarker(@NotNull String markerName, @NotNull Consumer<MarkerData> editor) {
        return MarkerStorage.editMarker(this.getMarkerGroupKey(), markerName, editor);
    }

    public boolean removeMarker(@NotNull String markerName) {
        return MarkerStorage.removeMarker(this.getMarkerGroupKey(), markerName);
    }

    public void clearMarkers() {
        MarkerStorage.clearGroup(this.getMarkerGroupKey());
    }

    @NotNull
    public String getMarkerGroupKey() {
        return this.getInstanceIdentifier();
    }

    private CompassReading collectReading(float partialTick) {
        if (CompassElement.isEditor()) {
            float simulated = (float)((double)(System.currentTimeMillis() % 12000L) / 12000.0 * 360.0);
            return new CompassReading(simulated);
        }
        LocalPlayer player = CompassElement.MC.player;
        if (player == null) {
            float fallback = (float)((double)(System.currentTimeMillis() % 8000L) / 8000.0 * 360.0);
            return new CompassReading(fallback);
        }
        float yaw = player.getViewYRot(partialTick);
        float heading = this.normalizeYawToHeading(yaw);
        return new CompassReading(heading);
    }

    private float normalizeYawToHeading(float yaw) {
        float normalized = yaw % 360.0f;
        if (normalized < 0.0f) {
            normalized += 360.0f;
        }
        normalized = (normalized + 180.0f) % 360.0f;
        return normalized;
    }

    @Nullable
    private DeathPointerData collectDeathPointer() {
        double dz;
        if (!this.deathPointerEnabled) {
            return null;
        }
        if (CompassElement.isEditor()) {
            return new DeathPointerData(60.0f, 120.0f);
        }
        LocalPlayer player = CompassElement.MC.player;
        if (player == null) {
            return null;
        }
        DeathPointStorage.StoredDeathPoint point = DeathPointStorage.get();
        if (point == null || !point.dimensionMatches(player.level())) {
            return null;
        }
        if (point.squaredDistanceTo(player.getX(), player.getY(), player.getZ()) <= 0.001) {
            return null;
        }
        double dx = point.getX() - player.getX();
        double distanceSq = dx * dx + (dz = point.getZ() - player.getZ()) * dz;
        if (distanceSq < 1.0E-4) {
            return null;
        }
        float distanceMeters = (float)Math.sqrt(distanceSq);
        double angleRad = Math.atan2(dx, -dz);
        float degrees = (float)(angleRad * 57.29577951308232);
        return new DeathPointerData(degrees, distanceMeters);
    }

    @NotNull
    private MobDots collectMobDots(@NotNull CompassReading reading) {
        boolean hasPassive;
        double passiveRange;
        boolean hostilesEnabled = this.hostileDotsEnabled;
        boolean passiveEnabled = this.passiveDotsEnabled;
        if (!hostilesEnabled && !passiveEnabled) {
            return MobDots.EMPTY;
        }
        if (CompassElement.isEditor()) {
            return this.createEditorMobDots();
        }
        LocalPlayer player = CompassElement.MC.player;
        if (player == null) {
            return MobDots.EMPTY;
        }
        double hostileRange = this.resolveMobDotsRange(this.hostileDotsRange, DEFAULT_HOSTILE_DOT_RANGE);
        double maxRange = Math.max(hostileRange, passiveRange = this.resolveMobDotsRange(this.passiveDotsRange, DEFAULT_PASSIVE_DOT_RANGE));
        if (maxRange <= 0.0) {
            return MobDots.EMPTY;
        }
        Level level = player.level();
        if (level == null) {
            return MobDots.EMPTY;
        }
        ArrayList<MobDotData> hostileDots = hostilesEnabled ? new ArrayList<MobDotData>() : Collections.emptyList();
        ArrayList<MobDotData> passiveDots = passiveEnabled ? new ArrayList<MobDotData>() : Collections.emptyList();
        AABB bounds = player.getBoundingBox().inflate(maxRange, Math.min(64.0, maxRange), maxRange);
        List mobs = level.getEntitiesOfClass(Mob.class, bounds, this::shouldIncludeMob);
        for (Mob mob : mobs) {
            boolean isHostile;
            MobCategory category = mob.getType().getCategory();
            boolean bl = isHostile = category == MobCategory.MONSTER;
            if (isHostile) {
                if (!hostilesEnabled || hostileDots.size() >= 64) continue;
                this.appendMobDot(hostileDots, mob, (Player)player, reading, hostileRange);
            } else {
                if (!passiveEnabled || passiveDots.size() >= 64) continue;
                this.appendMobDot(passiveDots, mob, (Player)player, reading, passiveRange);
            }
            if (hostilesEnabled && hostileDots.size() < 64 || passiveEnabled && passiveDots.size() < 64) continue;
            break;
        }
        boolean hasHostile = hostilesEnabled && !hostileDots.isEmpty();
        boolean bl = hasPassive = passiveEnabled && !passiveDots.isEmpty();
        if (!hasHostile && !hasPassive) {
            return MobDots.EMPTY;
        }
        List<MobDotData> hostileOut = hasHostile ? List.copyOf(hostileDots) : Collections.emptyList();
        List<MobDotData> passiveOut = hasPassive ? List.copyOf(passiveDots) : Collections.emptyList();
        return new MobDots(hostileOut, passiveOut);
    }

    @NotNull
    private MobDots createEditorMobDots() {
        Mob previewPassive;
        boolean hostilesEnabled = this.hostileDotsEnabled;
        boolean passiveEnabled = this.passiveDotsEnabled;
        if (!hostilesEnabled && !passiveEnabled) {
            return MobDots.EMPTY;
        }
        long now = System.currentTimeMillis();
        float cycleHostile = (float)((double)(now % 6000L) / 6000.0 * 360.0) - 180.0f;
        float cyclePassive = (float)((double)(now % 5000L) / 5000.0 * 360.0) - 180.0f;
        ArrayList<MobDotData> hostileDots = hostilesEnabled ? new ArrayList<MobDotData>() : Collections.emptyList();
        ArrayList<MobDotData> passiveDots = passiveEnabled ? new ArrayList<MobDotData>() : Collections.emptyList();
        Mob previewHostile = this.hostileDotsShowHeads && hostilesEnabled ? this.ensurePreviewMob(true) : null;
        Mob mob = previewPassive = this.passiveDotsShowHeads && passiveEnabled ? this.ensurePreviewMob(false) : null;
        if (hostilesEnabled) {
            hostileDots.add(new MobDotData(Mth.wrapDegrees((float)(cycleHostile - 60.0f)), 0.2f, previewHostile));
            hostileDots.add(new MobDotData(Mth.wrapDegrees((float)(cycleHostile + 10.0f)), 0.55f, previewHostile));
            hostileDots.add(new MobDotData(Mth.wrapDegrees((float)(cycleHostile + 85.0f)), 0.85f, previewHostile));
        }
        if (passiveEnabled) {
            passiveDots.add(new MobDotData(Mth.wrapDegrees((float)(cyclePassive - 140.0f)), 0.35f, previewPassive));
            passiveDots.add(new MobDotData(Mth.wrapDegrees((float)(cyclePassive - 20.0f)), 0.65f, previewPassive));
            passiveDots.add(new MobDotData(Mth.wrapDegrees((float)(cyclePassive + 120.0f)), 0.9f, previewPassive));
        }
        List<MobDotData> hostileOut = hostilesEnabled ? List.copyOf(hostileDots) : Collections.emptyList();
        List<MobDotData> passiveOut = passiveEnabled ? List.copyOf(passiveDots) : Collections.emptyList();
        return new MobDots(hostileOut, passiveOut);
    }

    private List<ResolvedMarker> collectMarkers(@NotNull CompassReading reading) {
        if (!this.worldMarkersEnabled) {
            return Collections.emptyList();
        }
        List<MarkerData> markers = MarkerStorage.getMarkers(this.getMarkerGroupKey());
        if (markers.isEmpty()) {
            return Collections.emptyList();
        }
        LocalPlayer player = CompassElement.MC.player;
        if (player == null) {
            return Collections.emptyList();
        }
        ArrayList<ResolvedMarker> resolved = new ArrayList<ResolvedMarker>(markers.size());
        float heading = reading.headingDegrees();
        for (MarkerData marker : markers) {
            MarkerOrientation orientation = this.computeMarkerOrientation((Player)player, marker, heading);
            ResourceSupplier dotTexture = SerializationUtils.deserializeImageResourceSupplier((String)marker.getDotTexture());
            ResourceSupplier needleTexture = SerializationUtils.deserializeImageResourceSupplier((String)marker.getNeedleTexture());
            int color = this.applyOpacity(this.parseColor(marker.getColor(), -47803));
            resolved.add(new ResolvedMarker(marker.getName(), orientation.relativeDegrees(), marker.isShowAsNeedle(), color, (ResourceSupplier<ITexture>)dotTexture, (ResourceSupplier<ITexture>)needleTexture, orientation.distanceMeters()));
        }
        return resolved;
    }

    private boolean shouldIncludeMob(@Nullable Mob mob) {
        return mob != null && mob.isAlive() && !mob.isRemoved() && !mob.isSpectator();
    }

    @Nullable
    private Mob ensurePreviewMob(boolean hostile) {
        Mob cached;
        Mob mob = cached = hostile ? this.previewHostileMob : this.previewPassiveMob;
        if (cached != null && (cached.isRemoved() || cached.level() != CompassElement.MC.level)) {
            cached = null;
        }
        if (cached != null) {
            return cached;
        }
        if (CompassElement.MC.level == null) {
            return null;
        }
        EntityType type = hostile ? EntityType.ZOMBIE : EntityType.COW;
        Mob created = (Mob)type.create((Level)CompassElement.MC.level, EntitySpawnReason.SPAWN_ITEM_USE);
        if (created == null) {
            return null;
        }
        created.setNoGravity(true);
        created.setNoAi(true);
        if (hostile) {
            this.previewHostileMob = created;
        } else {
            this.previewPassiveMob = created;
        }
        return created;
    }

    private void appendMobDot(@NotNull List<MobDotData> dots, @NotNull Mob mob, @NotNull Player player, @NotNull CompassReading reading, double maxRange) {
        double dz;
        if (maxRange <= 0.0) {
            return;
        }
        double dx = mob.getX() - player.getX();
        double distanceSq = dx * dx + (dz = mob.getZ() - player.getZ()) * dz;
        if (distanceSq <= 0.001) {
            return;
        }
        double distance = Math.sqrt(distanceSq);
        if (distance > maxRange) {
            return;
        }
        float signed = (float)(Math.atan2(dx, -dz) * 57.29577951308232);
        float absolute = CompassElement.normalizeUnsignedDegrees(signed);
        float relative = this.relativeToHeading(absolute, reading.headingDegrees());
        float ratio = (float)Mth.clamp((double)(distance / maxRange), (double)0.0, (double)1.0);
        dots.add(new MobDotData(relative, ratio, mob));
    }

    private MarkerOrientation computeMarkerOrientation(@NotNull Player player, @NotNull MarkerData marker, float headingDegrees) {
        double dz;
        double dx = marker.getResolvedMarkerPosX() - player.getX();
        double distanceSq = dx * dx + (dz = marker.getResolvedMarkerPosZ() - player.getZ()) * dz;
        float distanceMeters = distanceSq <= 1.0E-6 ? 0.0f : (float)Math.sqrt(distanceSq);
        float relative = 0.0f;
        if (distanceSq > 1.0E-8) {
            float signed = (float)(Math.atan2(dx, -dz) * 57.29577951308232);
            float absolute = CompassElement.normalizeUnsignedDegrees(signed);
            relative = this.relativeToHeading(absolute, headingDegrees);
        }
        return new MarkerOrientation(relative, distanceMeters);
    }

    private static float toSigned(float headingDegrees) {
        return headingDegrees > 180.0f ? headingDegrees - 360.0f : headingDegrees;
    }

    private static int toAbsoluteDegrees(int signedDegrees) {
        int wrapped = signedDegrees % 360;
        if (wrapped < 0) {
            wrapped += 360;
        }
        return wrapped;
    }

    private static float normalizeUnsignedDegrees(float signedDegrees) {
        float wrapped = signedDegrees % 360.0f;
        if (wrapped < 0.0f) {
            wrapped += 360.0f;
        }
        return wrapped;
    }

    private float relativeToHeading(float targetDegrees, float headingDegrees) {
        return Mth.wrapDegrees((float)(targetDegrees - headingDegrees));
    }

    private CompassLayout computeLayout(@NotNull Font font, int x, int y, int width, int height) {
        int barHeight = Math.max(2, Mth.floor((float)((float)height * 0.2f)));
        int barTop = y + (height - barHeight) / 2;
        int barCenter = barTop + barHeight / 2;
        int majorHalf = Math.min(Math.max(barHeight / 2 + 2, Mth.floor((float)((float)height * 0.3f))), height / 2);
        int minorHalf = Math.min(Math.max(1, Mth.floor((float)((float)height * 0.18f))), height / 2);
        float baseScale = Mth.clamp((float)((float)height / 60.0f), (float)0.55f, (float)3.0f);
        float cardinalScale = baseScale * this.resolveCardinalTextScaleMultiplier();
        float numberScale = Math.max(0.4f, baseScale * 0.8f) * this.resolveDegreeTextScaleMultiplier();
        Objects.requireNonNull(font);
        float cardinalHalfHeight = 9.0f * cardinalScale / 2.0f;
        Objects.requireNonNull(font);
        float numberHalfHeight = 9.0f * numberScale / 2.0f;
        float cardinalCenterY = Mth.clamp((float)((float)y + (float)height * 0.28f), (float)((float)y + cardinalHalfHeight), (float)((float)(y + height) - cardinalHalfHeight));
        float numberCenterY = Mth.clamp((float)((float)y + (float)height * 0.78f), (float)((float)y + numberHalfHeight), (float)((float)(y + height) - numberHalfHeight));
        return new CompassLayout(x, y, width, height, barTop, barHeight, barCenter, majorHalf, minorHalf, cardinalCenterY, numberCenterY, cardinalScale, numberScale);
    }

    private void drawDeathNeedleStrips(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, float centerX, int color, float offsetY) {
        int needleWidth = Math.max(1, Mth.floor((float)((float)layout.width() * 0.006f)));
        int half = Math.max(0, needleWidth / 2);
        float normalizedCenter = this.normalizeCenterForWrap(layout, centerX);
        this.drawNeedleStrip(graphics, layout, normalizedCenter - (float)layout.width(), needleWidth, half, color, offsetY);
        this.drawNeedleStrip(graphics, layout, normalizedCenter, needleWidth, half, color, offsetY);
        this.drawNeedleStrip(graphics, layout, normalizedCenter + (float)layout.width(), needleWidth, half, color, offsetY);
    }

    private void drawNeedleStrip(@NotNull GuiGraphics graphics, @NotNull CompassLayout layout, float centerX, int width, int halfWidth, int color, float offsetY) {
        int xi = Mth.floor((float)centerX) - halfWidth;
        int pixelOffset = Mth.floor((float)offsetY);
        int top = layout.y() + pixelOffset;
        graphics.fill(xi, top, xi + width, top + layout.height(), color);
    }

    private float adjustDeathPointerRelative(float relative) {
        if (!this.hasLastDeathPointerRelative) {
            this.hasLastDeathPointerRelative = true;
            this.lastDeathPointerRelative = relative;
            return relative;
        }
        float adjusted = relative;
        while (adjusted - this.lastDeathPointerRelative > 180.0f) {
            adjusted -= 360.0f;
        }
        while (adjusted - this.lastDeathPointerRelative < -180.0f) {
            adjusted += 360.0f;
        }
        this.lastDeathPointerRelative = adjusted;
        return adjusted;
    }

    private float normalizeCenterForWrap(@NotNull CompassLayout layout, float centerX) {
        float width = Math.max(1, layout.width());
        if (width <= 0.0f) {
            return layout.x();
        }
        float offset = centerX - (float)layout.x();
        float normalized = offset % width;
        if (normalized < 0.0f) {
            normalized += width;
        }
        return (float)layout.x() + normalized;
    }

    private record CompassReading(float headingDegrees) {
    }

    private record DeathPointerData(float signedDegrees, float distanceMeters) {
    }

    private record MobDots(@NotNull List<MobDotData> hostileDots, @NotNull List<MobDotData> passiveDots) {
        private static final MobDots EMPTY = new MobDots(Collections.emptyList(), Collections.emptyList());

        private boolean hasAny() {
            return !this.hostileDots.isEmpty() || !this.passiveDots.isEmpty();
        }
    }

    private record ResolvedColors(int backgroundColor, int barColor, int cardinalTickColor, int degreeTickColor, int minorTickColor, int cardinalTextColor, int degreeNumberTextColor, int needleColor, int deathNeedleColor, int hostileDotColor, int passiveDotColor) {
    }

    private record CompassLayout(int x, int y, int width, int height, int barTop, int barHeight, int barCenterY, int majorTickHalfHeight, int minorTickHalfHeight, float cardinalCenterY, float degreeNumberCenterY, float cardinalScale, float degreeNumberScale) {
    }

    private record TextureHandle(ResourceLocation location, int width, int height, @NotNull AspectRatio aspectRatio) {
    }

    private record MobDotData(float relativeDegrees, float distanceRatio, @Nullable Mob mob) {
    }

    private record DotBounds(int left, int top, int size) {
    }

    private record ResolvedMarker(@NotNull String name, float relativeDegrees, boolean showAsNeedle, int color, @Nullable ResourceSupplier<ITexture> dotTexture, @Nullable ResourceSupplier<ITexture> needleTexture, float distanceMeters) {
    }

    private record MarkerOrientation(float relativeDegrees, float distanceMeters) {
    }
}

