/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.playerarmorbar;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class PlayerArmorBarElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_SCALE_STRING = "1.0";
    private static final float DEFAULT_SCALE = 1.0f;
    private static final float MIN_SCALE = 0.2f;
    private static final float MAX_SCALE = 70.0f;
    private static final int BASE_ICON_PIXEL_SIZE = 8;
    private static final int BASE_SLOT_COUNT = 10;
    private static final long BLINK_DURATION_MS = 650L;
    private final Minecraft minecraft = Minecraft.getInstance();
    private final RandomSource shakeRandom = RandomSource.create();
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;
    public int iconsPerRow = 10;
    public int iconGap = 1;
    @NotNull
    public String scaleMultiplier = "1.0";
    public boolean blinkOnLoss = true;
    public boolean lowArmorShakeEnabled = true;
    public int lowArmorShakeThresholdIcons = 4;
    private final EnumMap<ArmorTextureKind, ResourceSupplier<ITexture>> customTextures = new EnumMap(ArmorTextureKind.class);
    private float lastRecordedArmor = -1.0f;
    private int cachedTickCount = 0;
    private final Map<Integer, BlinkState> activeBlinkSlots = new HashMap<Integer, BlinkState>();

    public PlayerArmorBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.stickyAnchor = true;
        this.stayOnScreen = false;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.cachedTickCount = this.safeTickCount();
        PlayerData data = this.collectPlayerData();
        float scale = this.resolveScale();
        RenderMetrics metrics = this.computeMetrics(scale);
        this.baseWidth = Math.max(1, metrics.bodyWidth);
        this.baseHeight = Math.max(1, metrics.bodyHeight);
        this.updateBlinkState(data.currentArmor);
        if (!this.shouldRender()) {
            return;
        }
        Integer[] aligned = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), metrics.bodyWidth, metrics.bodyHeight);
        this.drawArmor(graphics, aligned[0], aligned[1], data, metrics, scale);
    }

    private void drawArmor(@NotNull GuiGraphics graphics, int originX, int originY, @NotNull PlayerData data, @NotNull RenderMetrics metrics, float scale) {
        Matrix3x2fStack pose = graphics.pose();
        pose.pushMatrix();
        pose.translate((float)originX, (float)originY);
        long now = System.currentTimeMillis();
        boolean shake = this.shouldShake(data.currentArmor);
        float shakeStrengthBase = shake ? 0.9f : 0.0f;
        int totalSlots = metrics.totalSlots;
        for (int logicalIndex = totalSlots - 1; logicalIndex >= 0; --logicalIndex) {
            SlotPlacement placement = this.computeSlotPlacement(logicalIndex, metrics);
            ArmorTextureKind textureKind = this.resolveTextureKind(logicalIndex, data, now);
            float appliedShake = shakeStrengthBase > 0.0f && textureKind != ArmorTextureKind.EMPTY ? shakeStrengthBase : 0.0f;
            this.renderSingleIcon(graphics, metrics, placement, logicalIndex, textureKind, appliedShake, scale);
        }
        pose.popMatrix();
    }

    private ArmorTextureKind resolveTextureKind(int logicalIndex, @NotNull PlayerData data, long now) {
        BlinkState blink = this.activeBlinkSlots.get(logicalIndex);
        if (blink != null) {
            if (now < blink.endTimeMs) {
                ArmorTextureKind previousTexture = this.textureFromFill(blink.previousFill);
                if (previousTexture == ArmorTextureKind.EMPTY) {
                    previousTexture = ArmorTextureKind.HALF;
                }
                return now / 120L % 2L == 0L ? previousTexture : ArmorTextureKind.EMPTY;
            }
            this.activeBlinkSlots.remove(logicalIndex);
        }
        float displayedArmor = data.currentArmor;
        float slotLowerBound = (float)logicalIndex * 2.0f;
        float fillValue = displayedArmor - slotLowerBound;
        return this.textureFromFill(fillValue);
    }

    private void renderSingleIcon(@NotNull GuiGraphics graphics, @NotNull RenderMetrics metrics, @NotNull SlotPlacement placement, int logicalIndex, @NotNull ArmorTextureKind textureKind, float shakeStrengthBase, float scale) {
        float gap = this.iconGap;
        float baseSpacingX = ((float)metrics.baseIconSize + gap) * scale;
        float baseSpacingY = ((float)metrics.baseIconSize + gap) * scale;
        float baseX = (float)placement.column * baseSpacingX;
        float baseY = (float)placement.row * baseSpacingY;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (shakeStrengthBase > 0.0f && textureKind != ArmorTextureKind.EMPTY) {
            float[] offsets = this.computeShakeOffset(logicalIndex, shakeStrengthBase);
            offsetX = offsets[0];
            offsetY = offsets[1];
        }
        Matrix3x2fStack pose = graphics.pose();
        pose.pushMatrix();
        pose.translate(baseX + offsetX, baseY + offsetY);
        pose.scale(scale, scale);
        this.drawArmorTexture(graphics, textureKind, metrics.baseIconSize);
        pose.popMatrix();
    }

    private float[] computeShakeOffset(int logicalIndex, float shakeStrengthBase) {
        this.shakeRandom.setSeed((long)this.cachedTickCount * 341873128712L + (long)logicalIndex * 132897987541L);
        float dx = (this.shakeRandom.nextFloat() - 0.5f) * shakeStrengthBase;
        float dy = (this.shakeRandom.nextFloat() - 0.5f) * shakeStrengthBase;
        return new float[]{dx, dy};
    }

    private void drawArmorTexture(@NotNull GuiGraphics graphics, @NotNull ArmorTextureKind kind, int size) {
        ResourceSupplier<ITexture> supplier = this.customTextures.get((Object)kind);
        if (supplier != null) {
            try {
                ITexture texture = (ITexture)supplier.get();
                if (texture != null && texture.isReady() && texture.getResourceLocation() != null) {
                    graphics.blit(RenderPipelines.GUI_TEXTURED, texture.getResourceLocation(), 0, 0, 0.0f, 0.0f, size, size, size, size, ARGB.white((float)this.opacity));
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.error("[SpiffyHUD] Failed to draw armor texture {}", (Object)kind.name(), (Object)ex);
            }
        }
        graphics.fill(0, 0, size, size, this.applyOpacity(kind.defaultColor));
    }

    private int applyOpacity(int argb) {
        int alpha = argb >>> 24 & 0xFF;
        int rgb = argb & 0xFFFFFF;
        int adjustedAlpha = (int)Math.max(0.0f, Math.min(255.0f, (float)alpha * this.opacity));
        return adjustedAlpha << 24 | rgb;
    }

    private RenderMetrics computeMetrics(float scale) {
        int totalSlots = 10;
        int perRow = Math.max(1, this.iconsPerRow);
        int rowSize = Math.min(perRow, totalSlots);
        int rows = Math.max(1, (int)Math.ceil((double)totalSlots / (double)perRow));
        int gap = Math.max(0, this.iconGap);
        float scaledWidth = (float)(rowSize * 8) * scale + (float)(Math.max(0, rowSize - 1) * gap) * scale;
        float scaledHeight = (float)(rows * 8) * scale + (float)(Math.max(0, rows - 1) * gap) * scale;
        int bodyWidth = Math.max(1, Mth.ceil((float)scaledWidth));
        int bodyHeight = Math.max(1, Mth.ceil((float)scaledHeight));
        return new RenderMetrics(perRow, 8, totalSlots, bodyWidth, bodyHeight, rows, gap, gap);
    }

    private void updateBlinkState(float currentArmor) {
        long now = System.currentTimeMillis();
        this.cleanupExpiredBlinks(now);
        if (!this.blinkOnLoss) {
            this.activeBlinkSlots.clear();
            this.lastRecordedArmor = currentArmor;
            return;
        }
        if (this.lastRecordedArmor < 0.0f) {
            this.lastRecordedArmor = currentArmor;
            return;
        }
        if (currentArmor < this.lastRecordedArmor - 0.01f) {
            this.registerBlinkSlots(this.lastRecordedArmor, currentArmor, now);
        } else if (currentArmor > this.lastRecordedArmor + 0.01f) {
            this.activeBlinkSlots.clear();
        }
        this.lastRecordedArmor = currentArmor;
    }

    private boolean shouldShake(float currentArmor) {
        if (!this.lowArmorShakeEnabled) {
            return false;
        }
        if (this.lowArmorShakeThresholdIcons <= 0) {
            return false;
        }
        float threshold = (float)this.lowArmorShakeThresholdIcons * 2.0f;
        return currentArmor <= threshold;
    }

    private int safeTickCount() {
        try {
            return SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private PlayerData collectPlayerData() {
        if (PlayerArmorBarElement.isEditor()) {
            return new PlayerData(13.0f);
        }
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return new PlayerData(0.0f);
        }
        float currentArmor = player.getArmorValue();
        return new PlayerData(Math.max(0.0f, Math.min(20.0f, currentArmor)));
    }

    private float resolveScale() {
        String raw = this.scaleMultiplier;
        if (raw == null || raw.isBlank()) {
            return 1.0f;
        }
        String replaced = PlaceholderParser.replacePlaceholders((String)raw).trim();
        if (MathUtils.isFloat((String)replaced)) {
            try {
                float parsed = Float.parseFloat(replaced);
                if (!Float.isFinite(parsed)) {
                    return 1.0f;
                }
                return Mth.clamp((float)parsed, (float)0.2f, (float)70.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0f;
    }

    private ArmorTextureKind textureFromFill(float fillValue) {
        if (fillValue >= 2.0f) {
            return ArmorTextureKind.FULL;
        }
        if (fillValue > 0.0f) {
            return ArmorTextureKind.HALF;
        }
        return ArmorTextureKind.EMPTY;
    }

    private void registerBlinkSlots(float previousArmor, float currentArmor, long now) {
        for (int slot = 0; slot < 10; ++slot) {
            float newFill;
            float prevFill = this.fillForSlot(previousArmor, slot);
            if (!(prevFill > (newFill = this.fillForSlot(currentArmor, slot)) + 0.01f) || !(prevFill > 0.0f)) continue;
            this.activeBlinkSlots.put(slot, new BlinkState(prevFill, now + 650L));
        }
    }

    private float fillForSlot(float value, int slot) {
        float slotLowerBound = (float)slot * 2.0f;
        return Mth.clamp((float)(value - slotLowerBound), (float)0.0f, (float)2.0f);
    }

    private void cleanupExpiredBlinks(long now) {
        Iterator<Map.Entry<Integer, BlinkState>> iterator = this.activeBlinkSlots.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BlinkState> entry = iterator.next();
            if (now < entry.getValue().endTimeMs) continue;
            iterator.remove();
        }
    }

    private SlotPlacement computeSlotPlacement(int logicalIndex, RenderMetrics metrics) {
        int iconsInRow;
        int perRow = metrics.iconsPerRow;
        int rawRow = logicalIndex / perRow;
        int row = this.isTopAligned() ? rawRow : metrics.rows - 1 - rawRow;
        int topRowRawIndex = (metrics.totalSlots - 1) / perRow;
        int n = iconsInRow = rawRow == topRowRawIndex ? metrics.totalSlots - rawRow * perRow : perRow;
        if (iconsInRow <= 0) {
            iconsInRow = perRow;
        }
        int alignmentOffset = 0;
        if (rawRow == topRowRawIndex && this.isCenterAligned()) {
            alignmentOffset = (perRow - iconsInRow) / 2;
        }
        int rawColumn = logicalIndex % perRow;
        int column = this.isRightAligned() ? perRow - 1 - rawColumn : rawColumn;
        column = Math.max(0, column + alignmentOffset);
        return new SlotPlacement(column, Math.max(0, row));
    }

    private boolean isTopAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_LEFT, SpiffyAlignment.TOP_CENTERED, SpiffyAlignment.TOP_RIGHT -> true;
            default -> false;
        };
    }

    private boolean isCenterAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_CENTERED, SpiffyAlignment.MID_CENTERED, SpiffyAlignment.BOTTOM_CENTERED -> true;
            default -> false;
        };
    }

    private boolean isRightAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_RIGHT, SpiffyAlignment.MID_RIGHT, SpiffyAlignment.BOTTOM_RIGHT -> true;
            default -> false;
        };
    }

    public void setCustomTexture(@NotNull ArmorTextureKind kind, @Nullable ResourceSupplier<ITexture> supplier) {
        if (supplier == null) {
            this.customTextures.remove((Object)kind);
        } else {
            this.customTextures.put(kind, supplier);
        }
    }

    @Nullable
    public ResourceSupplier<ITexture> getCustomTexture(@NotNull ArmorTextureKind kind) {
        return this.customTextures.get((Object)kind);
    }

    @NotNull
    public Map<ArmorTextureKind, ResourceSupplier<ITexture>> getCustomTextureMap() {
        return Collections.unmodifiableMap(this.customTextures);
    }

    public static enum ArmorTextureKind {
        EMPTY("empty", -2145378272),
        HALF("half", -7690551),
        FULL("full", -4535318);

        private final String translationKeySuffix;
        private final int defaultColor;

        private ArmorTextureKind(String translationKeySuffix, int defaultColor) {
            this.translationKeySuffix = translationKeySuffix;
            this.defaultColor = defaultColor;
        }

        public String getTranslationKey() {
            return "spiffyhud.elements.player_armor_bar.texture." + this.translationKeySuffix;
        }
    }

    private static class PlayerData {
        final float currentArmor;

        PlayerData(float currentArmor) {
            this.currentArmor = currentArmor;
        }
    }

    private record RenderMetrics(int iconsPerRow, int baseIconSize, int totalSlots, int bodyWidth, int bodyHeight, int rows, int horizontalGap, int verticalGap) {
    }

    private record SlotPlacement(int column, int row) {
    }

    private record BlinkState(float previousFill, long endTimeMs) {
    }
}

