/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.slot;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.slot.SlotEditorElement;
import de.keksuccino.spiffyhud.customization.elements.slot.SlotElement;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotElementBuilder
extends ElementBuilder<SlotElement, SlotEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SlotElementBuilder() {
        super("spiffy_slot");
    }

    @NotNull
    public SlotElement buildDefaultInstance() {
        SlotElement i = new SlotElement(this);
        i.baseWidth = 20;
        i.baseHeight = 20;
        i.inEditorColor = DrawableColor.of((Color)new Color(140, 0, 98));
        i.stayOnScreen = false;
        i.stickyAnchor = true;
        return i;
    }

    public SlotElement deserializeElement(@NotNull SerializedElement serialized) {
        SlotElement element = this.buildDefaultInstance();
        element.slot = Objects.requireNonNullElse(serialized.getValue("inventory_slot"), element.slot);
        element.useSelectedSlot = this.deserializeBoolean(element.useSelectedSlot, serialized.getValue("use_selected_slot"));
        element.showDurability = this.deserializeBoolean(element.showDurability, serialized.getValue("show_durability"));
        return element;
    }

    @Nullable
    public SlotElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        SlotElement e = (SlotElement)super.deserializeElementInternal(serialized);
        if (e != null) {
            e.stayOnScreen = this.deserializeBoolean(e.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return e;
    }

    protected SerializedElement serializeElement(@NotNull SlotElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("inventory_slot", element.slot);
        serializeTo.putProperty("use_selected_slot", "" + element.useSelectedSlot);
        serializeTo.putProperty("show_durability", "" + element.showDurability);
        return serializeTo;
    }

    @NotNull
    public SlotEditorElement wrapIntoEditorElement(@NotNull SlotElement element, @NotNull LayoutEditorScreen editor) {
        return new SlotEditorElement(element, editor);
    }

    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.translatable((String)"spiffyhud.elements.slot");
    }

    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.slot.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

