/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.air;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerAirElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation AIR_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/air");
    private static final ResourceLocation AIR_POPPING_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/air_bursting");
    private static final ResourceLocation AIR_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/air_empty");
    private static final int BUBBLE_SIZE = 9;
    private static final int BUBBLE_SPACING = 8;
    private static final int AIR_BUBBLE_TOTAL = 10;
    private static final int TOTAL_BAR_WIDTH = 81;
    private static final int TOTAL_BAR_HEIGHT = 9;
    private static final int AIR_BUBBLE_POPPING_DURATION = 2;
    private static final int EMPTY_AIR_BUBBLE_DELAY_DURATION = 1;
    private final Minecraft minecraft = Minecraft.getInstance();
    protected int tickCount;
    private int barWidth = 100;
    private int barHeight = 100;
    private boolean shouldRenderBar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerAirElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.player == null) {
            return;
        }
        if (this.minecraft.level == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderPlayerAir(graphics, 0, 0);
        int elementAbsX = this.getAbsoluteX();
        int elementAbsY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementAbsX, elementAbsY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int barAbsX = alignedPosition[0];
        int barAbsY = alignedPosition[1];
        this.shouldRenderBar = true;
        this.renderPlayerAir(graphics, barAbsX, barAbsY);
    }

    private void renderPlayerAir(GuiGraphics graphics, int offsetX, int offsetY) {
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        boolean isInWater = player.isEyeInFluid(FluidTags.WATER);
        int maxAir = player.getMaxAirSupply();
        int currentAir = Math.min(player.getAirSupply(), maxAir);
        if (!isInWater && currentAir >= maxAir) {
            return;
        }
        int currentAirBubble = VanillaLikePlayerAirElement.getCurrentAirSupplyBubble(currentAir, maxAir, -2);
        int lastAirBubble = VanillaLikePlayerAirElement.getCurrentAirSupplyBubble(currentAir, maxAir, 0);
        int emptyBubbleStart = 10 - VanillaLikePlayerAirElement.getCurrentAirSupplyBubble(currentAir, maxAir, VanillaLikePlayerAirElement.getEmptyBubbleDelayDuration(currentAir, isInWater));
        boolean bubbleBursting = currentAirBubble != lastAirBubble;
        int totalBarWidth = 81;
        boolean shouldMirror = this.spiffyAlignment != SpiffyAlignment.TOP_LEFT && this.spiffyAlignment != SpiffyAlignment.MID_LEFT && this.spiffyAlignment != SpiffyAlignment.BOTTOM_LEFT;
        int color = ARGB.color((int)Math.round(this.opacity * 255.0f), (int)255, (int)255, (int)255);
        for (int i = 1; i <= 10; ++i) {
            ResourceLocation bubbleSprite;
            int bubbleX = offsetX + (i - 1) * 8;
            int bubbleY = offsetY;
            if (!this.shouldRenderBar) continue;
            if (i <= currentAirBubble) {
                bubbleSprite = AIR_SPRITE;
            } else if (bubbleBursting && i == lastAirBubble && isInWater) {
                bubbleSprite = AIR_POPPING_SPRITE;
            } else {
                if (i <= 10 - emptyBubbleStart) continue;
                bubbleSprite = AIR_EMPTY_SPRITE;
            }
            if (shouldMirror) {
                SpiffyRenderUtils.blitSpriteMirrored(graphics, bubbleSprite, bubbleX, bubbleY, 9, 9, color);
                continue;
            }
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, bubbleSprite, bubbleX, bubbleY, 9, 9, color);
        }
        this.barWidth = totalBarWidth;
        this.barHeight = 9;
    }

    private static int getCurrentAirSupplyBubble(int currentAirSupply, int maxAirSupply, int offset) {
        return Mth.ceil((float)((float)((currentAirSupply + offset) * 10) / (float)maxAirSupply));
    }

    private static int getEmptyBubbleDelayDuration(int airSupply, boolean inWater) {
        return airSupply != 0 && inWater ? 1 : 0;
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return 81;
    }

    public int getAbsoluteHeight() {
        return 9;
    }
}

