/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.armor;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerArmorElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation ARMOR_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/armor_empty");
    private static final ResourceLocation ARMOR_HALF_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/armor_half");
    private static final ResourceLocation ARMOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/armor_full");
    private static final int BAR_WIDTH = 81;
    private static final int BAR_HEIGHT = 9;
    private final Minecraft minecraft = Minecraft.getInstance();
    protected int tickCount;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerArmorElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, elementWidth, elementHeight, 81, 9);
        int armorBarX = alignedPosition[0];
        int armorBarY = alignedPosition[1];
        this.renderPlayerArmor(graphics, armorBarX, armorBarY);
    }

    private void renderPlayerArmor(GuiGraphics graphics, int offsetX, int offsetY) {
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        int armorValue = player.getArmorValue();
        if (VanillaLikePlayerArmorElement.isEditor()) {
            armorValue = 9;
        }
        int iconCount = 10;
        int iconSpacing = 8;
        int iconSize = 9;
        boolean isRightAligned = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT;
        int color = ARGB.color((int)Math.round(this.opacity * 255.0f), (int)255, (int)255, (int)255);
        for (int slot = 0; slot < 10; ++slot) {
            int iconX = isRightAligned ? offsetX + (9 - slot) * 8 : offsetX + slot * 8;
            int iconY = offsetY;
            int armorSegment = slot * 2 + 1;
            ResourceLocation armorSprite = armorSegment < armorValue ? ARMOR_FULL_SPRITE : (armorSegment == armorValue ? ARMOR_HALF_SPRITE : ARMOR_EMPTY_SPRITE);
            if (isRightAligned) {
                SpiffyRenderUtils.blitSpriteMirrored(graphics, armorSprite, iconX, iconY, 9, 9, color);
                continue;
            }
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, armorSprite, iconX, iconY, 9, 9, color);
        }
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return 81;
    }

    public int getAbsoluteHeight() {
        return 9;
    }
}

