/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.bossbars;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeBossOverlayElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation[] BAR_BACKGROUND_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/pink_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/blue_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/red_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/green_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/purple_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/white_background")};
    private static final ResourceLocation[] BAR_PROGRESS_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/pink_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/blue_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/red_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/green_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/purple_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/white_progress")};
    private static final ResourceLocation[] OVERLAY_BACKGROUND_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_6_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_10_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_12_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_20_background")};
    private static final ResourceLocation[] OVERLAY_PROGRESS_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_6_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_10_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_12_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_20_progress")};
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private static final List<LerpingBossEvent> DUMMY_EVENTS = List.of(new LerpingBossEvent(UUID.randomUUID(), (Component)Component.translatable((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS, false, false, false), new LerpingBossEvent(UUID.randomUUID(), (Component)Component.translatable((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS, false, false, false), new LerpingBossEvent(UUID.randomUUID(), (Component)Component.translatable((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS, false, false, false));
    private final Minecraft minecraft = Minecraft.getInstance();
    private int barWidth = 182;
    private int barHeight = 0;
    private int barOriginalX = 0;
    private int barOriginalY = 0;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeBossOverlayElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        this.updateBodySizeAndPosCache();
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int offsetX = alignedPosition[0] - this.barOriginalX;
        int offsetY = alignedPosition[1] - this.barOriginalY;
        List<LerpingBossEvent> eventsToRender = VanillaLikeBossOverlayElement.isEditor() ? DUMMY_EVENTS : Minecraft.getInstance().gui.getBossOverlay().events.values();
        this.renderBossBars(graphics, offsetX, offsetY, eventsToRender);
    }

    private void updateBodySizeAndPosCache() {
        List<LerpingBossEvent> eventsToRecord;
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setHeightOffset(5);
        Collection<Object> collection = eventsToRecord = VanillaLikeBossOverlayElement.isEditor() ? DUMMY_EVENTS : Minecraft.getInstance().gui.getBossOverlay().events.values();
        if (!eventsToRecord.iterator().hasNext() && !VanillaLikeBossOverlayElement.isEditor()) {
            return;
        }
        int currentY = 12;
        for (LerpingBossEvent bossEvent : eventsToRecord) {
            int barPosX = 0;
            int barPosY = currentY;
            recorder.updateX(barPosX);
            recorder.updateY(barPosY);
            Component eventName = bossEvent.getName();
            int textWidth = this.minecraft.font.width((FormattedText)eventName);
            int textPosX = (182 - textWidth) / 2;
            int textPosY = barPosY - 9;
            recorder.updateX(textPosX);
            recorder.updateY(textPosY);
            currentY += 19;
        }
        this.barOriginalX = recorder.getX();
        this.barOriginalY = recorder.getY();
        this.barWidth = Math.max(182, recorder.getWidth());
        this.barHeight = recorder.getHeight();
    }

    private void renderBossBars(GuiGraphics graphics, int offsetX, int offsetY, Iterable<LerpingBossEvent> bossEvents) {
        int color = ARGB.color((int)Math.round(this.opacity * 255.0f), (int)255, (int)255, (int)255);
        int currentY = offsetY + 12;
        for (LerpingBossEvent bossEvent : bossEvents) {
            int barPosX = offsetX;
            int barPosY = currentY;
            this.drawBar(graphics, barPosX, barPosY, (BossEvent)bossEvent, color);
            Component eventName = bossEvent.getName();
            int textWidth = this.minecraft.font.width((FormattedText)eventName);
            int textPosX = barPosX + (182 - textWidth) / 2;
            int textPosY = barPosY - 9;
            graphics.drawString(this.minecraft.font, eventName, textPosX, textPosY, color);
            currentY += 19;
        }
    }

    private void drawBar(GuiGraphics graphics, int barX, int barY, BossEvent bossEvent, int color) {
        this.drawBar(graphics, barX, barY, bossEvent, 182, BAR_BACKGROUND_SPRITES, OVERLAY_BACKGROUND_SPRITES, color);
        int filledWidth = Mth.lerpDiscrete((float)bossEvent.getProgress(), (int)0, (int)182);
        if (filledWidth > 0) {
            this.drawBar(graphics, barX, barY, bossEvent, filledWidth, BAR_PROGRESS_SPRITES, OVERLAY_PROGRESS_SPRITES, color);
        }
    }

    private void drawBar(GuiGraphics graphics, int barX, int barY, BossEvent bossEvent, int progress, ResourceLocation[] barSprites, ResourceLocation[] overlaySprites, int color) {
        SpiffyRenderUtils.blitSprite(graphics, barSprites[bossEvent.getColor().ordinal()], 182, 5, 0, 0, barX, barY, progress, 5, color);
        if (bossEvent.getOverlay() != BossEvent.BossBarOverlay.PROGRESS) {
            SpiffyRenderUtils.blitSprite(graphics, overlaySprites[bossEvent.getOverlay().ordinal() - 1], 182, 5, 0, 0, barX, barY, progress, 5, color);
        }
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

