/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.contextualbar;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.WaypointStyle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.level.Level;
import net.minecraft.world.waypoints.TrackedWaypoint;
import net.minecraft.world.waypoints.Waypoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeContextualBarElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation EXPERIENCE_BAR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/experience_bar_background");
    private static final ResourceLocation EXPERIENCE_BAR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/experience_bar_progress");
    private static final ResourceLocation JUMP_BAR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/jump_bar_background");
    private static final ResourceLocation JUMP_BAR_COOLDOWN_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/jump_bar_cooldown");
    private static final ResourceLocation JUMP_BAR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/jump_bar_progress");
    private static final ResourceLocation LOCATOR_BAR_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"hud/locator_bar_background");
    private static final ResourceLocation LOCATOR_BAR_ARROW_UP = ResourceLocation.withDefaultNamespace((String)"hud/locator_bar_arrow_up");
    private static final ResourceLocation LOCATOR_BAR_ARROW_DOWN = ResourceLocation.withDefaultNamespace((String)"hud/locator_bar_arrow_down");
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private static final int EXPERIENCE_BAR_DISPLAY_TICKS = 100;
    private static final int DOT_SIZE = 9;
    private static final int VISIBLE_DEGREE_RANGE = 60;
    private static final int ARROW_WIDTH = 7;
    private static final int ARROW_HEIGHT = 5;
    private final Minecraft minecraft = Minecraft.getInstance();
    public boolean alwaysShowLocatorBar = false;
    public boolean alwaysShowExperienceBar = false;

    public VanillaLikeContextualBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        ContextualInfo contextualInfo = this.getContextualInfoState();
        switch (contextualInfo.ordinal()) {
            case 1: {
                this.renderExperienceBar(graphics, elementX, elementY, elementWidth, elementHeight);
                break;
            }
            case 3: {
                this.renderJumpBar(graphics, elementX, elementY, elementWidth, elementHeight);
                break;
            }
            case 2: {
                this.renderLocatorBar(graphics, elementX, elementY, elementWidth, elementHeight);
                break;
            }
        }
    }

    private ContextualInfo getContextualInfoState() {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return ContextualInfo.EMPTY;
        }
        if (VanillaLikeContextualBarElement.isEditor()) {
            return this.alwaysShowLocatorBar ? ContextualInfo.LOCATOR : ContextualInfo.EXPERIENCE;
        }
        if (this.alwaysShowLocatorBar) {
            return ContextualInfo.LOCATOR;
        }
        if (this.alwaysShowExperienceBar) {
            return ContextualInfo.EXPERIENCE;
        }
        boolean hasWaypoints = player.connection.getWaypointManager().hasWaypoints();
        boolean hasJumpableVehicle = player.jumpableVehicle() != null;
        boolean hasExperience = this.minecraft.gameMode.hasExperience();
        if (hasWaypoints) {
            if (hasJumpableVehicle && this.willPrioritizeJumpInfo()) {
                return ContextualInfo.JUMPABLE_VEHICLE;
            }
            return hasExperience && this.willPrioritizeExperienceInfo() ? ContextualInfo.EXPERIENCE : ContextualInfo.LOCATOR;
        }
        if (hasJumpableVehicle) {
            return ContextualInfo.JUMPABLE_VEHICLE;
        }
        return hasExperience ? ContextualInfo.EXPERIENCE : ContextualInfo.EMPTY;
    }

    private boolean willPrioritizeExperienceInfo() {
        LocalPlayer player = this.minecraft.player;
        return player != null && player.experienceDisplayStartTick + 100 > player.tickCount;
    }

    private boolean willPrioritizeJumpInfo() {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return false;
        }
        if (player.getJumpRidingScale() > 0.0f) {
            return true;
        }
        PlayerRideableJumping jumpableVehicle = player.jumpableVehicle();
        return jumpableVehicle != null && jumpableVehicle.getJumpCooldown() > 0;
    }

    private void renderExperienceBar(GuiGraphics graphics, int x, int y, int width, int height) {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        int color = ARGB.color((int)Math.round(this.opacity * 255.0f), (int)255, (int)255, (int)255);
        int xpNeeded = player.getXpNeededForNextLevel();
        if (xpNeeded > 0 || this.alwaysShowExperienceBar || VanillaLikeContextualBarElement.isEditor()) {
            int filledBarWidth = (int)(player.experienceProgress * 183.0f);
            if (VanillaLikeContextualBarElement.isEditor()) {
                filledBarWidth = 91;
            }
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, EXPERIENCE_BAR_BACKGROUND_SPRITE, x, y, width, height, color);
            if (filledBarWidth > 0) {
                graphics.enableScissor(x, y, x + filledBarWidth, y + height);
                graphics.blitSprite(RenderPipelines.GUI_TEXTURED, EXPERIENCE_BAR_PROGRESS_SPRITE, x, y, width, height, color);
                graphics.disableScissor();
            }
        }
        if (player.experienceLevel > 0 || this.alwaysShowExperienceBar || VanillaLikeContextualBarElement.isEditor()) {
            int level = player.experienceLevel;
            if (VanillaLikeContextualBarElement.isEditor()) {
                level = 42;
            }
            MutableComponent levelText = Component.translatable((String)"gui.experience.level", (Object[])new Object[]{level});
            int textWidth = this.getFont().width((FormattedText)levelText);
            int textX = x + (width - textWidth) / 2;
            int textY = y - 6;
            graphics.drawString(this.getFont(), (Component)levelText, textX + 1, textY, SpiffyRenderUtils.colorWithAlpha(0, this.opacity), false);
            graphics.drawString(this.getFont(), (Component)levelText, textX - 1, textY, SpiffyRenderUtils.colorWithAlpha(0, this.opacity), false);
            graphics.drawString(this.getFont(), (Component)levelText, textX, textY + 1, SpiffyRenderUtils.colorWithAlpha(0, this.opacity), false);
            graphics.drawString(this.getFont(), (Component)levelText, textX, textY - 1, SpiffyRenderUtils.colorWithAlpha(0, this.opacity), false);
            graphics.drawString(this.getFont(), (Component)levelText, textX, textY, SpiffyRenderUtils.colorWithAlpha(8453920, this.opacity), false);
        }
    }

    private void renderJumpBar(GuiGraphics graphics, int x, int y, int width, int height) {
        PlayerRideableJumping jumpableVehicle;
        LocalPlayer player = this.minecraft.player;
        PlayerRideableJumping playerRideableJumping = jumpableVehicle = player != null ? player.jumpableVehicle() : null;
        if (jumpableVehicle == null && !VanillaLikeContextualBarElement.isEditor()) {
            return;
        }
        int color = ARGB.color((int)Math.round(this.opacity * 255.0f), (int)255, (int)255, (int)255);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, JUMP_BAR_BACKGROUND_SPRITE, x, y, width, height, color);
        if (VanillaLikeContextualBarElement.isEditor()) {
            int filledWidth = width / 2;
            graphics.enableScissor(x, y, x + filledWidth, y + height);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, JUMP_BAR_PROGRESS_SPRITE, x, y, width, height, color);
            graphics.disableScissor();
        } else if (jumpableVehicle.getJumpCooldown() > 0) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, JUMP_BAR_COOLDOWN_SPRITE, x, y, width, height, color);
        } else {
            int filledWidth = (int)(player.getJumpRidingScale() * 183.0f);
            if (filledWidth > 0) {
                graphics.enableScissor(x, y, x + filledWidth, y + height);
                graphics.blitSprite(RenderPipelines.GUI_TEXTURED, JUMP_BAR_PROGRESS_SPRITE, x, y, width, height, color);
                graphics.disableScissor();
            }
        }
    }

    private void renderLocatorBar(GuiGraphics graphics, int x, int y, int width, int height) {
        int color = ARGB.color((int)Math.round(this.opacity * 255.0f), (int)255, (int)255, (int)255);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, LOCATOR_BAR_BACKGROUND, x, y, width, height, color);
        if (VanillaLikeContextualBarElement.isEditor()) {
            int centerX = x + width / 2;
            int dotY = y - 2;
            for (int i = -1; i <= 1; ++i) {
                int dotX = centerX + i * 30 - 4;
                int dotColor = ARGB.multiply((int)color, (int)ARGB.color((int)255, (int)(100 + i * 50), (int)150, (int)200));
                graphics.fill(dotX, dotY, dotX + 9, dotY + 9, dotColor);
            }
        } else {
            Level level = this.minecraft.getCameraEntity().level();
            this.minecraft.player.connection.getWaypointManager().forEachWaypoint(this.minecraft.getCameraEntity(), waypoint -> {
                double yawAngle;
                if (!this.isPlayerWaypoint((TrackedWaypoint)waypoint) && (yawAngle = waypoint.yawAngleToCamera(level, (TrackedWaypoint.Camera)this.minecraft.gameRenderer.getMainCamera(), entity -> this.minecraft.gameRenderer.getMainCamera().getPartialTickTime())) > -61.0 && yawAngle <= 60.0) {
                    this.renderWaypoint(graphics, (TrackedWaypoint)waypoint, x, y, width, yawAngle, level);
                }
            });
        }
    }

    private boolean isPlayerWaypoint(TrackedWaypoint waypoint) {
        return waypoint.id().left().map(uuid -> uuid.equals(this.minecraft.getCameraEntity().getUUID())).orElse(false);
    }

    private void renderWaypoint(GuiGraphics graphics, TrackedWaypoint waypoint, int barX, int barY, int barWidth, double yawAngle, Level level) {
        int centerX = barX + barWidth / 2;
        Waypoint.Icon icon = waypoint.icon();
        WaypointStyle style = this.minecraft.getWaypointStyles().get(icon.style);
        float distance = Mth.sqrt((float)((float)waypoint.distanceSquared(this.minecraft.getCameraEntity())));
        ResourceLocation sprite = style.sprite(distance);
        int waypointColor = icon.color.orElseGet(() -> (Integer)waypoint.id().map(left -> ARGB.setBrightness((int)ARGB.color((int)255, (int)left.hashCode()), (float)0.9f), right -> ARGB.setBrightness((int)ARGB.color((int)255, (int)right.hashCode()), (float)0.9f)));
        waypointColor = ARGB.multiply((int)waypointColor, (int)ARGB.color((int)Math.round(this.opacity * 255.0f), (int)255, (int)255, (int)255));
        int xOffset = (int)(yawAngle * 173.0 / 2.0 / 60.0);
        int dotX = centerX + xOffset - 4;
        int dotY = barY - 2;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, dotX, dotY, 9, 9, waypointColor);
        TrackedWaypoint.PitchDirection pitchDirection = waypoint.pitchDirectionToCamera(level, (TrackedWaypoint.Projector)this.minecraft.gameRenderer, entity -> this.minecraft.gameRenderer.getMainCamera().getPartialTickTime());
        if (pitchDirection != TrackedWaypoint.PitchDirection.NONE) {
            ResourceLocation arrowSprite;
            int arrowY;
            if (pitchDirection == TrackedWaypoint.PitchDirection.DOWN) {
                arrowY = barY + 6;
                arrowSprite = LOCATOR_BAR_ARROW_DOWN;
            } else {
                arrowY = barY - 6;
                arrowSprite = LOCATOR_BAR_ARROW_UP;
            }
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, arrowSprite, dotX + 1, arrowY, 7, 5, waypointColor);
        }
    }

    private Font getFont() {
        return Minecraft.getInstance().font;
    }

    public int getAbsoluteWidth() {
        return 182;
    }

    public int getAbsoluteHeight() {
        return 5;
    }

    private static enum ContextualInfo {
        EMPTY,
        EXPERIENCE,
        LOCATOR,
        JUMPABLE_VEHICLE;

    }
}

