/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.placeholders;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.spiffyhud.util.level.EntityNbtUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerNbtDataPlaceholder
extends Placeholder {
    private static final Map<String, Pair<String, Long>> CACHE = new HashMap<String, Pair<String, Long>>();

    public PlayerNbtDataPlaceholder() {
        super("player_nbt_data");
    }

    public String getReplacementFor(DeserializedPlaceholderString dps) {
        long now = System.currentTimeMillis();
        LocalPlayer e = Minecraft.getInstance().player;
        if (e != null) {
            String path = (String)dps.values.get("path");
            long cooldownMs = (Long)SerializationUtils.deserializeNumber(Long.class, (Number)0L, (String)((String)dps.values.get("refresh_cooldown_ms")));
            if (path != null) {
                String identifier = path + ":" + cooldownMs;
                if (cooldownMs > 0L && CACHE.containsKey(identifier) && (Long)CACHE.get(identifier).getValue() + cooldownMs >= now) {
                    return (String)CACHE.get(identifier).getKey();
                }
                String value = EntityNbtUtils.getNbtString((Entity)e, path);
                if (value == null) {
                    return "\u00a7cINVALID NBT PATH!";
                }
                if (cooldownMs > 0L) {
                    CACHE.put(identifier, (Pair<String, Long>)Pair.of((Object)value, (Object)now));
                }
                return value;
            }
        } else {
            return "\u00a7cNOT IN A WORLD!";
        }
        return "\u00a7cERROR!";
    }

    @Nullable
    public List<String> getValueNames() {
        return List.of("path", "refresh_cooldown_ms");
    }

    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"spiffyhud.placeholders.player_nbt_data", (Object[])new Object[0]);
    }

    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines((String)"spiffyhud.placeholders.player_nbt_data.desc", (String[])new String[0]));
    }

    public String getCategory() {
        return I18n.get((String)"fancymenu.placeholders.categories.world", (Object[])new Object[0]);
    }

    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("path", "path_to_nbt");
        values.put("refresh_cooldown_ms", "100");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

