/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.mixin.mixins.common.client;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.spiffyhud.util.rendering.ExtendedGuiGraphics;
import de.keksuccino.spiffyhud.util.rendering.exclusion.ExclusionAreaStack;
import de.keksuccino.spiffyhud.util.rendering.exclusion.IGuiGraphicsExclusionArea;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class MixinGuiGraphics
implements IGuiGraphicsExclusionArea,
ExtendedGuiGraphics {
    @Unique
    private final ExclusionAreaStack spiffyHud$exclusionAreaStack = new ExclusionAreaStack();

    @Shadow
    protected abstract void innerBlit(RenderPipeline var1, ResourceLocation var2, int var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10, int var11);

    @Override
    @Unique
    public void blitMirrored_Spiffy(RenderPipeline renderType, ResourceLocation texture, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, int textureWidth, int textureHeight, int color) {
        RenderSystem.assertOnRenderThread();
        float u1 = (u + uWidth) / (float)textureWidth;
        float u2 = u / (float)textureWidth;
        float v1 = v / (float)textureHeight;
        float v2 = (v + vHeight) / (float)textureHeight;
        this.innerBlit(renderType, texture, x, x + width, y, y + height, u1, u2, v1, v2, color);
    }

    @Override
    @Unique
    public void blitMirroredMatrix_Spiffy(RenderPipeline renderType, ResourceLocation texture, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, int textureWidth, int textureHeight, int color) {
        GuiGraphics self = (GuiGraphics)this;
        self.pose().pushMatrix();
        self.pose().translate((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
        self.pose().scale(-1.0f, 1.0f);
        self.pose().translate((float)(-width) / 2.0f, (float)(-height) / 2.0f);
        self.blit(renderType, texture, 0, 0, u, v, width, height, textureWidth, textureHeight, color);
        self.pose().popMatrix();
    }

    @Override
    @Unique
    public void spiffyHud$pushExclusionArea(int x1, int y1, int x2, int y2) {
        this.spiffyHud$exclusionAreaStack.push(new ScreenRectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1)));
    }

    @Override
    @Unique
    public void spiffyHud$popExclusionArea() {
        this.spiffyHud$exclusionAreaStack.pop();
    }

    @Override
    @Unique
    public void spiffyHud$clearExclusionAreas() {
        this.spiffyHud$exclusionAreaStack.clear();
    }

    @Override
    @Unique
    public boolean spiffyHud$hasExclusionAreas() {
        return !this.spiffyHud$exclusionAreaStack.isEmpty();
    }

    @Override
    @Unique
    public int spiffyHud$popAllExclusionAreas() {
        int count = this.spiffyHud$exclusionAreaStack.size();
        this.spiffyHud$exclusionAreaStack.clear();
        return count;
    }

    @Inject(method={"fill(IIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkFillExclusion(int minX, int minY, int maxX, int maxY, int color, CallbackInfo ci) {
        if (this.spiffyHud$shouldSkipRect(minX, minY, maxX, maxY)) {
            ci.cancel();
        }
    }

    @Inject(method={"fill(Lcom/mojang/blaze3d/pipeline/RenderPipeline;IIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkFillExclusion(RenderPipeline pipeline, int minX, int minY, int maxX, int maxY, int color, CallbackInfo ci) {
        if (this.spiffyHud$shouldSkipRect(minX, minY, maxX, maxY)) {
            ci.cancel();
        }
    }

    @Inject(method={"fill(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/client/gui/render/TextureSetup;IIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkFillExclusion(RenderPipeline pipeline, TextureSetup textureSetup, int minX, int minY, int maxX, int maxY, CallbackInfo ci) {
        if (this.spiffyHud$shouldSkipRect(minX, minY, maxX, maxY)) {
            ci.cancel();
        }
    }

    @Inject(method={"drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkStringExclusion(Font font, String text, int x, int y, int color, boolean dropShadow, CallbackInfo ci) {
        int height;
        int width;
        if (!this.spiffyHud$exclusionAreaStack.isEmpty() && text != null && this.spiffyHud$exclusionAreaStack.isRectangleFullyExcluded(x, y, x + (width = font.width(text)), y + (height = 9))) {
            ci.cancel();
        }
    }

    @Inject(method={"drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;IIIZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkFormattedStringExclusion(Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow, CallbackInfo ci) {
        int height;
        int width;
        if (!this.spiffyHud$exclusionAreaStack.isEmpty() && text != null && this.spiffyHud$exclusionAreaStack.isRectangleFullyExcluded(x, y, x + (width = font.width(text)), y + (height = 9))) {
            ci.cancel();
        }
    }

    @Inject(method={"innerBlit(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIIIFFFFI)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkInnerBlit(RenderPipeline pipeline, ResourceLocation atlasLocation, int x0, int x1, int y0, int y1, float minU, float maxU, float minV, float maxV, int color, CallbackInfo ci) {
        if (this.spiffyHud$shouldSkipRect(x0, y0, x1, y1)) {
            ci.cancel();
        }
    }

    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;III)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkRenderItem(LivingEntity entity, Level level, ItemStack stack, int x, int y, int seed, CallbackInfo ci) {
        if (!this.spiffyHud$exclusionAreaStack.isEmpty() && this.spiffyHud$exclusionAreaStack.isRectangleFullyExcluded(x, y, x + 16, y + 16)) {
            ci.cancel();
        }
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkRenderItemDecorations(Font font, ItemStack stack, int x, int y, String text, CallbackInfo ci) {
        if (!this.spiffyHud$exclusionAreaStack.isEmpty() && this.spiffyHud$exclusionAreaStack.isRectangleFullyExcluded(x, y, x + 16, y + 16)) {
            ci.cancel();
        }
    }

    @Inject(method={"submitOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkSubmitOutline(int x, int y, int width, int height, int color, CallbackInfo ci) {
        if (!this.spiffyHud$exclusionAreaStack.isEmpty() && this.spiffyHud$exclusionAreaStack.isRectangleFullyExcluded(x, y, x + width, y + height)) {
            ci.cancel();
        }
    }

    @Inject(method={"fillGradient(IIIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void spiffyHud$checkFillGradient(int x1, int y1, int x2, int y2, int colorFrom, int colorTo, CallbackInfo ci) {
        if (this.spiffyHud$shouldSkipRect(x1, y1, x2, y2)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean spiffyHud$shouldSkipRect(int rawX1, int rawY1, int rawX2, int rawY2) {
        if (this.spiffyHud$exclusionAreaStack.isEmpty()) {
            return false;
        }
        int minX = Math.min(rawX1, rawX2);
        int maxX = Math.max(rawX1, rawX2);
        int minY = Math.min(rawY1, rawY2);
        int maxY = Math.max(rawY1, rawY2);
        return this.spiffyHud$exclusionAreaStack.isRectangleFullyExcluded(minX, minY, maxX, maxY);
    }
}

