/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.level;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityNbtUtils {
    @Nullable
    public static String getNbtString(@NotNull Entity entity, @NotNull String path) {
        try {
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)entity.registryAccess());
            entity.saveWithoutId((ValueOutput)output);
            NbtPathArgument.NbtPath nbtPath = NbtPathArgument.nbtPath().parse(new StringReader(path));
            List results = nbtPath.get((Tag)output.buildResult());
            if (results.isEmpty()) {
                return null;
            }
            Tag tag = (Tag)results.get(0);
            if (tag instanceof NumericTag) {
                NumericTag numericTag = (NumericTag)tag;
                String tagString = tag.asString().orElse(null);
                Double tagDouble = numericTag.asDouble().orElse(null);
                Long tagLong = numericTag.asLong().orElse(null);
                if (tagString != null && (tagString.endsWith("d") || tagString.endsWith("f") || tagString.endsWith("b") || tagString.endsWith("s") || tagString.endsWith("L"))) {
                    if (tagString.contains(".") && tagDouble != null) {
                        return String.valueOf(tagDouble);
                    }
                    if (tagLong != null) {
                        return String.valueOf(tagLong);
                    }
                }
            }
            return tag.asString().orElse(null);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    @NotNull
    public static List<String> getAllNbtPaths(@NotNull Entity entity) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)entity.registryAccess());
        entity.saveWithoutId((ValueOutput)output);
        ArrayList<String> paths = new ArrayList<String>();
        EntityNbtUtils.collectPaths("", (Tag)output.buildResult(), paths);
        Collections.sort(paths);
        return paths;
    }

    private static void collectPaths(String prefix, Tag tag, List<String> paths) {
        block10: {
            block11: {
                block9: {
                    if (prefix != null && !prefix.isEmpty()) {
                        paths.add(prefix);
                    }
                    if (!(tag instanceof CompoundTag)) break block9;
                    CompoundTag compound = (CompoundTag)tag;
                    for (String key : compound.keySet()) {
                        String newPrefix = prefix.isEmpty() ? key : prefix + "." + key;
                        EntityNbtUtils.collectPaths(newPrefix, compound.get(key), paths);
                    }
                    break block10;
                }
                if (!(tag instanceof ListTag)) break block11;
                ListTag list = (ListTag)tag;
                for (int i = 0; i < list.size(); ++i) {
                    String newPrefix = prefix + "[" + i + "]";
                    EntityNbtUtils.collectPaths(newPrefix, list.get(i), paths);
                }
                break block10;
            }
            if (!(tag instanceof ByteArrayTag) && !(tag instanceof IntArrayTag) && !(tag instanceof LongArrayTag)) break block10;
            int size = 0;
            if (tag instanceof ByteArrayTag) {
                size = ((ByteArrayTag)tag).getAsByteArray().length;
            } else if (tag instanceof IntArrayTag) {
                size = ((IntArrayTag)tag).getAsIntArray().length;
            } else if (tag instanceof LongArrayTag) {
                size = ((LongArrayTag)tag).getAsLongArray().length;
            }
            for (int i = 0; i < size; ++i) {
                paths.add(prefix + "[" + i + "]");
            }
        }
    }
}

