/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.level;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public class StructureUtils {
    public static boolean isInStructure(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull ResourceKey<Structure> structure) {
        if (!level.isLoaded(pos)) {
            return false;
        }
        List<ResourceKey<Structure>> structures = StructureUtils.getAllStructuresAt(level, pos);
        for (ResourceKey<Structure> key : structures) {
            if (!key.toString().equals(structure.toString())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<ResourceKey<Structure>> getAllStructuresAt(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        if (!level.isLoaded(pos)) {
            return List.of();
        }
        Registry structureRegistry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        ArrayList<ResourceKey<Structure>> keys = new ArrayList<ResourceKey<Structure>>();
        level.structureManager().getAllStructuresAt(pos).forEach((structure, longs) -> {
            Optional structureKey = structureRegistry.getResourceKey(structure);
            structureKey.ifPresent(keys::add);
        });
        return keys;
    }

    @NotNull
    public static ResourceKey<Structure> getStructureKey(@NotNull String structureId) {
        ResourceLocation resourceLocation = ResourceLocation.parse((String)structureId);
        return StructureUtils.getStructureKey(resourceLocation);
    }

    @NotNull
    public static ResourceKey<Structure> getStructureKey(@NotNull ResourceLocation location) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)location);
    }

    @NotNull
    public static List<ResourceKey<Structure>> getAllStructureKeys(@NotNull RegistryAccess registryAccess) {
        Registry structureRegistry = registryAccess.lookupOrThrow(Registries.STRUCTURE);
        return new ArrayList<ResourceKey<Structure>>(structureRegistry.registryKeySet());
    }

    @NotNull
    public static Optional<ResourceKey<Structure>> findStructureKey(@NotNull RegistryAccess registryAccess, @NotNull String structureName) {
        try {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)structureName);
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)resourceLocation);
            Registry structureRegistry = registryAccess.lookupOrThrow(Registries.STRUCTURE);
            if (structureRegistry.containsKey(key)) {
                return Optional.of(key);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @NotNull
    public static List<String> convertStructureKeysToStrings(@NotNull List<ResourceKey<Structure>> keys) {
        ArrayList<String> stringKeys = new ArrayList<String>();
        keys.forEach(structureResourceKey -> stringKeys.add(structureResourceKey.location().toString()));
        return stringKeys;
    }
}

