/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering;

import de.keksuccino.spiffyhud.util.rendering.EntityRenderingUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class GuiEntityRenderer {
    private static final float DEFAULT_FACING = 180.0f;
    private static final float MAX_BODY_DELTA = 30.0f;
    private static final float MAX_HEAD_DELTA = 30.0f;
    private float lastOriginalBodyRotation = Float.NaN;
    private float renderedBodyRotation = 180.0f;
    private float lastOriginalHeadRotation = Float.NaN;
    private float renderedHeadRotation = 180.0f;

    public void renderEntity(GuiGraphics graphics, int posX, int posY, int boxWidth, int boxHeight, float opacity, LivingEntity entity) {
        EntityDimensions dimensions = entity.getDimensions(Pose.STANDING);
        float scaleFromWidth = (float)boxWidth / dimensions.width();
        float scaleFromHeight = (float)boxHeight / dimensions.height();
        float uniformScale = Math.min(scaleFromWidth, scaleFromHeight);
        float origYBodyRot = entity.yBodyRot;
        float origYRot = entity.getYRot();
        float origXRot = entity.getXRot();
        float origYHeadRot = entity.yHeadRot;
        float origYHeadRotO = entity.yHeadRotO;
        float currentOriginalBody = origYBodyRot;
        if (Float.isNaN(this.lastOriginalBodyRotation)) {
            this.lastOriginalBodyRotation = currentOriginalBody;
            this.renderedBodyRotation = currentOriginalBody;
        }
        float bodyDelta = Mth.wrapDegrees((float)(currentOriginalBody - this.lastOriginalBodyRotation));
        this.renderedBodyRotation += bodyDelta;
        this.renderedBodyRotation = Mth.clamp((float)this.renderedBodyRotation, (float)150.0f, (float)210.0f);
        this.lastOriginalBodyRotation = currentOriginalBody;
        entity.yBodyRot = this.renderedBodyRotation;
        float currentOriginalHead = origYHeadRot;
        if (Float.isNaN(this.lastOriginalHeadRotation)) {
            this.lastOriginalHeadRotation = currentOriginalHead;
            this.renderedHeadRotation = currentOriginalHead;
        }
        float headDelta = Mth.wrapDegrees((float)(currentOriginalHead - this.lastOriginalHeadRotation));
        float newRenderedHead = this.renderedHeadRotation + headDelta;
        newRenderedHead = Mth.clamp((float)newRenderedHead, (float)(this.renderedBodyRotation - 30.0f), (float)(this.renderedBodyRotation + 30.0f));
        this.lastOriginalHeadRotation = currentOriginalHead;
        this.renderedHeadRotation = newRenderedHead;
        entity.yHeadRot = newRenderedHead;
        entity.yHeadRotO = newRenderedHead;
        entity.setYRot(newRenderedHead);
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer renderer = dispatcher.getRenderer((Entity)entity);
        EntityRenderState renderState = renderer.createRenderState((Entity)entity, 1.0f);
        renderState.hitboxesRenderState = null;
        renderState.serverHitboxesRenderState = null;
        EntityRenderingUtils.submitLivingEntityOpacity(renderState, opacity);
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI);
        Vector3f translation = new Vector3f(0.0f, entity.getBbHeight() / 2.0f, 0.0f);
        graphics.submitEntityRenderState(renderState, uniformScale, translation, rotation, null, posX -= 1000, posY -= 1000, posX + (boxWidth += 2000), posY + (boxHeight += 2000));
        entity.yBodyRot = origYBodyRot;
        entity.setYRot(origYRot);
        entity.setXRot(origXRot);
        entity.yHeadRot = origYHeadRot;
        entity.yHeadRotO = origYHeadRotO;
    }
}

