/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.spiffyhud.mixin.mixins.common.client.IMixinGuiGraphics;
import de.keksuccino.spiffyhud.util.rendering.ExtendedGuiGraphics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class SpiffyRenderUtils {
    private static boolean blendLocked = false;

    public static void lockBlend(boolean lock) {
        blendLocked = true;
    }

    public static boolean isBlendLocked() {
        return blendLocked;
    }

    public static void blitMirrored(GuiGraphics graphics, ResourceLocation atlasLocation, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int color) {
        RenderSystem.assertOnRenderThread();
        ExtendedGuiGraphics extended = (ExtendedGuiGraphics)graphics;
        extended.blitMirrored_Spiffy(RenderPipelines.GUI_TEXTURED, atlasLocation, x, y, width, height, u, v, width, height, textureWidth, textureHeight, color);
    }

    public static void blitMirrored(GuiGraphics graphics, ResourceLocation atlasLocation, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        SpiffyRenderUtils.blitMirrored(graphics, atlasLocation, x, y, u, v, width, height, textureWidth, textureHeight, -1);
    }

    public static void blitSpriteMirrored(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height, int color) {
        RenderSystem.assertOnRenderThread();
        IMixinGuiGraphics mixinGraphics = (IMixinGuiGraphics)graphics;
        TextureAtlasSprite atlasSprite = mixinGraphics.get_guiSprites_Spiffy().getSprite(sprite);
        ResourceLocation atlasLocation = atlasSprite.atlasLocation();
        float u0 = atlasSprite.getU0();
        float v0 = atlasSprite.getV0();
        float u1 = atlasSprite.getU1();
        float v1 = atlasSprite.getV1();
        int atlasWidth = (int)((float)atlasSprite.contents().width() / (u1 - u0));
        int atlasHeight = (int)((float)atlasSprite.contents().height() / (v1 - v0));
        float uPixel = u0 * (float)atlasWidth;
        float vPixel = v0 * (float)atlasHeight;
        float uWidth = (u1 - u0) * (float)atlasWidth;
        float vHeight = (v1 - v0) * (float)atlasHeight;
        ExtendedGuiGraphics extended = (ExtendedGuiGraphics)graphics;
        extended.blitMirrored_Spiffy(RenderPipelines.GUI_TEXTURED, atlasLocation, x, y, width, height, uPixel, vPixel, uWidth, vHeight, atlasWidth, atlasHeight, color);
    }

    public static void blitSpriteMirrored(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        SpiffyRenderUtils.blitSpriteMirrored(graphics, sprite, x, y, width, height, -1);
    }

    public static void blitSprite(GuiGraphics graphics, ResourceLocation sprite, int textureWidth, int textureHeight, int uPosition, int vPosition, int x, int y, int uWidth, int vHeight, int color) {
        IMixinGuiGraphics mixinGraphics = (IMixinGuiGraphics)graphics;
        TextureAtlasSprite textureAtlasSprite = mixinGraphics.get_guiSprites_Spiffy().getSprite(sprite);
        GuiSpriteScaling guiSpriteScaling = SpiffyRenderUtils.getSpriteScaling(textureAtlasSprite);
        if (guiSpriteScaling instanceof GuiSpriteScaling.Stretch) {
            mixinGraphics.invoke_private_blitSprite_Spiffy(RenderPipelines.GUI_TEXTURED, textureAtlasSprite, textureWidth, textureHeight, uPosition, vPosition, x, y, uWidth, vHeight, color);
        } else {
            graphics.enableScissor(x, y, x + uWidth, y + vHeight);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, x - uPosition, y - vPosition, textureWidth, textureHeight, color);
            graphics.disableScissor();
        }
    }

    public static void blitMirroredMatrix(GuiGraphics graphics, ResourceLocation atlasLocation, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int color) {
        RenderSystem.assertOnRenderThread();
        ExtendedGuiGraphics extended = (ExtendedGuiGraphics)graphics;
        extended.blitMirroredMatrix_Spiffy(RenderPipelines.GUI_TEXTURED, atlasLocation, x, y, width, height, u, v, width, height, textureWidth, textureHeight, color);
    }

    public static int colorWithAlpha(int color, float alpha) {
        int alphaComponent = Math.round(alpha * 255.0f);
        if (alphaComponent > 255) {
            alphaComponent = 255;
        }
        if (alphaComponent < 0) {
            alphaComponent = 0;
        }
        int red = ARGB.red((int)color);
        int green = ARGB.green((int)color);
        int blue = ARGB.blue((int)color);
        return ARGB.color((int)alphaComponent, (int)red, (int)green, (int)blue);
    }

    private static GuiSpriteScaling getSpriteScaling(TextureAtlasSprite sprite) {
        return sprite.contents().getAdditionalMetadata(GuiMetadataSection.TYPE).orElse(GuiMetadataSection.DEFAULT).scaling();
    }
}

