/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering.exclusion;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.gui.navigation.ScreenRectangle;

public class ExclusionAreaStack {
    private final Deque<ScreenRectangle> stack = new ArrayDeque<ScreenRectangle>();

    public void push(ScreenRectangle area) {
        this.stack.addLast(area);
    }

    public void pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Exclusion area stack underflow");
        }
        this.stack.removeLast();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void clear() {
        this.stack.clear();
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isPointExcluded(float x, float y) {
        for (ScreenRectangle area : this.stack) {
            if (!area.containsPoint((int)x, (int)y)) continue;
            return true;
        }
        return false;
    }

    public boolean isRectangleFullyExcluded(float minX, float minY, float maxX, float maxY) {
        for (ScreenRectangle area : this.stack) {
            if (!((float)area.left() <= minX) || !((float)area.right() >= maxX) || !((float)area.top() <= minY) || !((float)area.bottom() >= maxY)) continue;
            return true;
        }
        return false;
    }

    public boolean doesRectangleIntersectExclusion(float minX, float minY, float maxX, float maxY) {
        for (ScreenRectangle area : this.stack) {
            if (maxX < (float)area.left() || minX > (float)area.right() || maxY < (float)area.top() || minY > (float)area.bottom()) continue;
            return true;
        }
        return false;
    }
}

