/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks.energyTransmitter;

import com.forsteri.createendertransmission.blocks.energyTransmitter.EnergyTransmitterBlockEntity;
import com.forsteri.createendertransmission.entry.TransmissionBlockEntities;
import com.forsteri.createendertransmission.entry.TransmissionBlocks;
import com.forsteri.createendertransmission.transmitUtil.TransmitterScreen;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class EnergyTransmitterBlock
extends DirectionalKineticBlock
implements IBE<EnergyTransmitterBlockEntity>,
IWrenchable {
    public EnergyTransmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockItem blockItem;
        if (AllItems.WRENCH.isIn(stack)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof KineticBlock && this.hasShaftTowards((LevelReader)level, pos, state, hitResult.getDirection())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.withBlockEntityDo((BlockGetter)level, pos, te -> this.displayScreen((EnergyTransmitterBlockEntity)te, player));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(EnergyTransmitterBlockEntity te, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new TransmitterScreen(te, TransmissionBlocks.ENERGY_TRANSMITTER_BLOCK.asStack()));
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos p_60517_, BlockState p_60518_, boolean p_60519_) {
        if (this.getBlockEntity((BlockGetter)pLevel, p_60517_) != null) {
            Objects.requireNonNull((EnergyTransmitterBlockEntity)this.getBlockEntity((BlockGetter)pLevel, p_60517_)).getConnectedTransmitters().remove(this.getBlockEntity((BlockGetter)pLevel, p_60517_));
        }
        super.onRemove(pState, pLevel, p_60517_, p_60518_, p_60519_);
    }

    public Class<EnergyTransmitterBlockEntity> getBlockEntityClass() {
        return EnergyTransmitterBlockEntity.class;
    }

    public BlockEntityType<? extends EnergyTransmitterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TransmissionBlockEntities.ENERGY_TRANSMITTER_TILE.get();
    }
}

