/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv;

import com.mojang.brigadier.CommandDispatcher;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import speakingvillagers.sv.commands.BefriendCommand;
import speakingvillagers.sv.commands.SetVillagerStyleCommand;
import speakingvillagers.sv.commands.SpeakCommand;
import speakingvillagers.sv.commands.UnfriendCommand;
import speakingvillagers.sv.config.ModConfig;
import speakingvillagers.sv.handlers.BiomeEntryTracker;
import speakingvillagers.sv.handlers.TTSHandler;
import speakingvillagers.sv.handlers.VillagerFriendshipManager;
import speakingvillagers.sv.handlers.VillagerStyleManager;
import speakingvillagers.sv.handlers.VisualEffectsManager;
import speakingvillagers.sv.quest.QuestTracker;

public class SpeakingVillagers
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"alivingvillagers");
    public static ModConfig config;

    public void onInitialize() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        this.registerLifecycleEvents();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            SpeakCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BefriendCommand.register((CommandDispatcher<class_2168>)dispatcher);
            UnfriendCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetVillagerStyleCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        BiomeEntryTracker.registerBiomeTracking();
        LOGGER.info("Speaking Villagers mod initialized!");
    }

    private void registerLifecycleEvents() {
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = world;
            if (!SpeakingVillagers.config.enableMod) {
                LOGGER.info("Speaking Villagers mod is disabled via configuration. Skipping world load for: " + String.valueOf(world.method_27983().method_29177()));
                return;
            }
            LOGGER.info("Loading friendships for world: " + String.valueOf(serverWorld.method_27983().method_29177()));
            VillagerFriendshipManager.loadFriendships();
            VillagerStyleManager.loadStyles(world);
            LOGGER.info("Villager styles loaded for world: " + String.valueOf(world.method_27983().method_29177()));
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = world;
            if (!SpeakingVillagers.config.enableMod) {
                LOGGER.info("Skipping villager styles save as mod is disabled for: " + String.valueOf(world.method_27983().method_29177()));
                return;
            }
            LOGGER.info("Saving friendships for world: " + String.valueOf(serverWorld.method_27983().method_29177()));
            VillagerFriendshipManager.saveFriendships(serverWorld);
            VillagerStyleManager.saveStyles(world);
            LOGGER.info("Villager styles saved for world: " + String.valueOf(world.method_27983().method_29177()));
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (SpeakingVillagers.config.enableMod) {
                QuestTracker.loadQuestData();
                VillagerFriendshipManager.loadFriendships(null);
                LOGGER.info("Quest data loaded successfully.");
            } else {
                LOGGER.info("Mod disabled. Skipping quest data load.");
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(stoppingServer -> {
            if (SpeakingVillagers.config.enableMod) {
                QuestTracker.saveQuestData();
                VisualEffectsManager.stopAllEffects();
                LOGGER.info("Server stopping, saving friendships...");
                VillagerFriendshipManager.saveFriendships(null);
                LOGGER.info("Quest data and effects saved successfully.");
                LOGGER.info("Server stopping, shutting down TTS scheduler...");
                TTSHandler.shutdownScheduler();
            } else {
                LOGGER.info("Mod disabled. Skipping.");
            }
        });
    }
}

