/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import speakingvillagers.sv.handlers.AsyncTextAndTTS;
import speakingvillagers.sv.handlers.VillagerFriendshipManager;

public class SpeakCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"speak").then(class_2170.method_9244((String)"input", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            String input = StringArgumentType.getString((CommandContext)context, (String)"input");
            class_3222 player = source.method_44023();
            MinecraftServer server = source.method_9211();
            class_1646 villager = SpeakCommand.findNearestVillager(Objects.requireNonNull(player));
            if (villager != null) {
                AsyncTextAndTTS.generateAndSpeakTextAsync(villager, input, (class_1657)player, server);
                VillagerFriendshipManager.handleSpeaking(villager, player);
                VillagerFriendshipManager.handleReputationCheck(villager, player);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"No villager nearby!"));
            }
            return 1;
        })));
    }

    public static void executeRecognizedSpeech(class_2168 source, String recognizedText) {
        class_3222 player = source.method_44023();
        MinecraftServer server = source.method_9211();
        class_1646 villager = SpeakCommand.findNearestVillager(Objects.requireNonNull(player));
        if (villager != null) {
            AsyncTextAndTTS.generateAndSpeakTextAsync(villager, recognizedText, (class_1657)player, server);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"No villager nearby!"));
        }
    }

    private static class_1646 findNearestVillager(class_3222 player) {
        return player.method_37908().method_8390(class_1646.class, player.method_5829().method_1014(16.0), villager -> true).stream().min((v1, v2) -> Double.compare(v1.method_5858((class_1297)player), v2.method_5858((class_1297)player))).orElse(null);
    }
}

