/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.handlers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;

public class ConversationManager {
    private static final String CONVERSATION_DIR = "speakingvillagersmod/conversations";
    private final Map<String, String> conversationCache = new HashMap<String, String>();

    public ConversationManager() {
        File dir = new File(this.getMinecraftDirectory(), CONVERSATION_DIR);
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("Failed to create conversation directory: " + dir.getAbsolutePath());
        }
    }

    private File getMinecraftDirectory() {
        class_310 client = class_310.method_1551();
        return client != null ? client.field_1697 : new File(System.getProperty("user.dir"));
    }

    public void saveConversation(String villagerId, String input, String generatedText) {
        try {
            File conversationFile = new File(this.getMinecraftDirectory(), CONVERSATION_DIR + File.separator + villagerId + ".txt");
            BufferedWriter writer = new BufferedWriter(new FileWriter(conversationFile, true));
            writer.write("User: " + input + "\n");
            writer.write("Villager: " + generatedText + "\n\n");
            writer.close();
            this.conversationCache.remove(villagerId);
            System.out.println("Conversation saved for villager ID: " + villagerId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getConversationHistory(String villagerId) {
        if (this.conversationCache.containsKey(villagerId)) {
            return this.conversationCache.get(villagerId);
        }
        StringBuilder conversationHistory = new StringBuilder();
        File conversationFile = new File(this.getMinecraftDirectory(), CONVERSATION_DIR + File.separator + villagerId + ".txt");
        if (conversationFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(conversationFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    conversationHistory.append(line).append("\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String history = conversationHistory.toString();
        this.conversationCache.put(villagerId, history);
        System.out.println("Conversation history retrieved for villager ID: " + villagerId);
        return history;
    }
}

