/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.handlers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import speakingvillagers.sv.handlers.VillagerFriendshipManager;
import speakingvillagers.sv.handlers.VisualEffectsManager;

public class TTSHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TTSHandler.class);
    private static ScheduledExecutorService scheduler;
    private final Map<class_1646, ScheduledFuture<?>> activeTasks = new ConcurrentHashMap();
    private final Map<class_3222, class_1646> playerInteractions = new HashMap<class_3222, class_1646>();
    private static final Set<class_1646> activeTTSVillagers;

    private static ScheduledExecutorService getScheduler() {
        if (scheduler == null || scheduler.isShutdown()) {
            scheduler = Executors.newScheduledThreadPool(2);
            LOGGER.info("TTSHandler scheduler initialized.");
        }
        return scheduler;
    }

    public void speakResponse(class_1646 villager, class_3222 player, MinecraftServer server, String text) {
        TTSHandler.setTTSActive(villager, true);
        if (!VillagerFriendshipManager.isFriend(villager, (class_1657)player)) {
            VillagerFriendshipManager.handleSpeaking(villager, player);
        }
        VisualEffectsManager.applyVillagerAura(villager);
        VisualEffectsManager.startSpeakingEffect(villager);
        VisualEffectsManager.startHeadNoddingEffect(villager);
        this.disableVillagerMovement(villager);
        this.startVillagerLook(villager, player);
        this.executeTTSCommand(villager, text, () -> {
            VisualEffectsManager.stopSpeakingEffect(villager);
            VisualEffectsManager.stopHeadNoddingEffect(villager);
            this.enableVillagerMovement(villager);
            this.stopVillagerLook(villager);
            TTSHandler.setTTSActive(villager, false);
        });
    }

    private void stopVillagerEffects(class_1646 villager) {
        VisualEffectsManager.stopSpeakingEffect(villager);
        VisualEffectsManager.stopHeadNoddingEffect(villager);
        this.stopVillagerLook(villager);
        this.enableVillagerMovement(villager);
        TTSHandler.setTTSActive(villager, false);
    }

    private void disableVillagerMovement(class_1646 villager) {
        villager.method_5942().method_6340();
        villager.method_5977(true);
    }

    private void enableVillagerMovement(class_1646 villager) {
        villager.method_5977(false);
    }

    private void startVillagerLook(class_1646 villager, class_3222 player) {
        this.stopVillagerLook(villager);
        ScheduledFuture<?> task = TTSHandler.getScheduler().scheduleAtFixedRate(() -> {
            if (TTSHandler.isTTSActive(villager)) {
                villager.method_5988().method_20248(player.method_23317(), player.method_23320(), player.method_23321());
                villager.method_5988().method_6231();
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
        this.activeTasks.put(villager, task);
    }

    private void stopVillagerLook(class_1646 villager) {
        ScheduledFuture<?> task = this.activeTasks.remove(villager);
        if (task != null) {
            task.cancel(true);
        }
    }

    private void executeTTSCommand(class_1646 villager, String text, Runnable onComplete) {
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                String sanitizedText = this.sanitizeInput(text);
                String voiceName = villager.method_6109() ? "Microsoft Aria Online" : "Microsoft Andrew Online";
                String command = String.format("cmd.exe /c powershell -ExecutionPolicy Bypass -Command \"Add-Type -AssemblyName System.Speech; $speak = New-Object System.Speech.Synthesis.SpeechSynthesizer; $speak.SelectVoice('%s'); $speak.Volume = 80; $speak.Rate = %d; $speak.Speak('%s')\"", voiceName, villager.method_6109() ? 2 : 0, sanitizedText);
                Process process = Runtime.getRuntime().exec(command);
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    LOGGER.info("TTS Command executed successfully.");
                    if (onComplete != null) {
                        onComplete.run();
                    }
                    return;
                }
                LOGGER.error("TTS Command failed with exit code: " + exitCode);
                continue;
            }
            catch (IOException | InterruptedException e) {
                LOGGER.error("Exception in TTS Command attempt {}: {}", new Object[]{attempt, e.getMessage(), e});
            }
        }
        LOGGER.error("TTS Command failed after multiple attempts.");
        if (onComplete != null) {
            onComplete.run();
        }
    }

    private String sanitizeInput(String input) {
        return input.replace("'", "''").replace("\"", "`\"").replace("\n", " ").replace("\r", " ").replace("`", "``");
    }

    private static void setTTSActive(class_1646 villager, boolean active) {
        if (active) {
            activeTTSVillagers.add(villager);
        } else {
            activeTTSVillagers.remove(villager);
        }
    }

    public static boolean isTTSActive(class_1646 villager) {
        return activeTTSVillagers.contains(villager);
    }

    public static void shutdownScheduler() {
        scheduler.shutdownNow();
        LOGGER.info("TTSHandler scheduler shut down successfully.");
    }

    static {
        activeTTSVillagers = ConcurrentHashMap.newKeySet();
    }
}

