/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.handlers;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5819;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import speakingvillagers.sv.config.ModConfig;
import speakingvillagers.sv.config.ModConfigManager;
import speakingvillagers.sv.handlers.VisualEffectsManager;
import speakingvillagers.sv.utils.VillagerUtils;

public class VillagerFriendshipManager {
    private static final String FRIENDSHIP_FILE = "world/speakingvillagersmod/friendships.json";
    private static final Map<UUID, Set<UUID>> friendships = new HashMap<UUID, Set<UUID>>();
    private static final Map<UUID, Map<UUID, Integer>> interactionCounter = new HashMap<UUID, Map<UUID, Integer>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(VillagerFriendshipManager.class);
    private static final class_5819 random = class_5819.method_43047();
    private static final Map<UUID, ScheduledExecutorService> heartEffectSchedulers = new HashMap<UUID, ScheduledExecutorService>();

    public static void sendColoredMessage(class_3222 player, class_1646 villager, String message, class_124 color) {
        String villagerName = VillagerFriendshipManager.getVillagerNameOrProfession(villager);
        String formattedMessage = villagerName + ": " + message;
        player.method_7353((class_2561)class_2561.method_43470((String)formattedMessage).method_27692(color), false);
    }

    public static void unfriendVillager(class_1646 villager, class_3222 player) {
        UUID villagerId = villager.method_5667();
        UUID playerId = player.method_5667();
        if (!friendships.containsKey(villagerId) || !friendships.get(villagerId).contains(playerId)) {
            LOGGER.debug("Player {} is not friends with villager {}, no action needed.", (Object)playerId, (Object)villagerId);
            return;
        }
        friendships.get(villagerId).remove(playerId);
        if (friendships.get(villagerId).isEmpty()) {
            friendships.remove(villagerId);
        }
        VisualEffectsManager.stopVillagerAura(villager);
        VisualEffectsManager.stopHeartEffect(villager);
        VillagerUtils.removeFollowPlayerGoal(villager);
        VillagerFriendshipManager.sendColoredMessage(player, villager, "You are no longer friends with " + villager.method_5477().getString() + ".", class_124.field_1061);
        class_3218 serverWorld = (class_3218)villager.method_37908();
        VillagerFriendshipManager.saveFriendships(serverWorld);
    }

    public static void handleSpeaking(class_1646 villager, class_3222 player) {
        VillagerFriendshipManager.incrementInteractionCount(villager, (class_1657)player);
        if (!VillagerFriendshipManager.isBefriended(villager) && VillagerFriendshipManager.shouldBefriend(villager, (class_1657)player)) {
            VillagerFriendshipManager.addFriendship(villager, (class_1657)player);
        }
    }

    public static boolean isFriend(class_1646 villager, class_1657 player) {
        UUID villagerId = villager.method_5667();
        UUID playerId = player.method_5667();
        return friendships.containsKey(villagerId) && friendships.get(villagerId).contains(playerId);
    }

    public static boolean isBefriended(class_1646 villager) {
        return friendships.containsKey(villager.method_5667()) && !friendships.get(villager.method_5667()).isEmpty();
    }

    public static void addFriendship(class_1646 villager, class_1657 player) {
        UUID villagerId = villager.method_5667();
        UUID playerId = player.method_5667();
        friendships.putIfAbsent(villagerId, new HashSet());
        friendships.get(villagerId).add(playerId);
        VisualEffectsManager.applyHeartEffect(villager);
        VillagerUtils.addFollowPlayerGoal(villager, player);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            VillagerFriendshipManager.sendColoredMessage(serverPlayer, villager, villager.method_5477().getString() + " is now your friend.", class_124.field_1060);
        }
        VillagerFriendshipManager.saveFriendships((class_3218)villager.method_37908());
    }

    public static void removeVillager(class_1646 villager) {
        friendships.remove(villager.method_5667());
        VillagerFriendshipManager.saveFriendships((class_3218)villager.method_37908());
    }

    private static boolean shouldBefriend(class_1646 villager, class_1657 player) {
        ModConfig config = ModConfigManager.getConfig();
        UUID villagerId = villager.method_5667();
        UUID playerId = player.method_5667();
        int interactions = ((Map)interactionCounter.getOrDefault(villagerId, new HashMap())).getOrDefault(playerId, 0);
        int playerReputation = villager.method_20594(player);
        if (!config.enableMod || playerReputation < 0) {
            return false;
        }
        double baseChance = (double)config.baseChancePercentage / 100.0;
        double interactionFactor = (double)config.interactionFactorPercentage / 100.0 * (double)interactions;
        double reputationFactor = (double)config.reputationFactorPercentage / 100.0 * (double)Math.max(playerReputation, 0);
        double totalChance = Math.min(baseChance + interactionFactor + reputationFactor, 0.75);
        LOGGER.info("Calculating befriending chance for villager {}: Interactions={}, Reputation={}, TotalChance={}", new Object[]{villagerId, interactions, playerReputation, totalChance});
        return random.method_43058() < totalChance;
    }

    public static void saveFriendships(class_3218 serverWorld) {
        String filePath = VillagerFriendshipManager.getFriendshipFilePath(serverWorld);
        File file = new File(filePath);
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            if (parentDirectory.mkdirs()) {
                LOGGER.info("Created directory for friendships: " + parentDirectory.getAbsolutePath());
            } else {
                LOGGER.error("Failed to create directory for friendships: " + parentDirectory.getAbsolutePath());
                return;
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            HashMap data = new HashMap();
            for (Map.Entry<UUID, Set<UUID>> entry : friendships.entrySet()) {
                UUID villagerId = entry.getKey();
                List<String> playerIds = entry.getValue().stream().map(UUID::toString).toList();
                HashMap<String, List<String>> villagerData = new HashMap<String, List<String>>();
                villagerData.put("friends", playerIds);
                data.put(villagerId.toString(), villagerData);
            }
            new Gson().toJson(data, (Appendable)writer);
            LOGGER.info("Friendships saved successfully to: " + filePath);
        }
        catch (IOException e) {
            LOGGER.error("Error saving friendships", (Throwable)e);
        }
    }

    public static void loadFriendships() {
        VillagerFriendshipManager.loadFriendships(null);
    }

    public static void loadFriendships(class_3218 serverWorld) {
        String filePath = VillagerFriendshipManager.getFriendshipFilePath(serverWorld);
        File file = new File(filePath);
        if (!file.exists()) {
            LOGGER.info("No existing friendship data found at: " + filePath);
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Map data = (Map)new Gson().fromJson((Reader)reader, Map.class);
            friendships.clear();
            for (Map.Entry entry : data.entrySet()) {
                UUID villagerId = UUID.fromString((String)entry.getKey());
                Object friendsObj = ((Map)entry.getValue()).get("friends");
                if (!(friendsObj instanceof List)) {
                    LOGGER.warn("Invalid 'friends' value for villager: {}", (Object)villagerId);
                    continue;
                }
                List playerIdList = (List)friendsObj;
                HashSet<UUID> friendSet = new HashSet<UUID>();
                for (Object playerId : playerIdList) {
                    try {
                        friendSet.add(UUID.fromString(playerId.toString()));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("Invalid player UUID: {}", playerId, (Object)e);
                    }
                }
                friendships.put(villagerId, friendSet);
            }
            LOGGER.info("Friendships loaded successfully from: " + filePath);
        }
        catch (IOException e) {
            LOGGER.error("Error loading friendships", (Throwable)e);
        }
    }

    private static String getFriendshipFilePath(class_3218 serverWorld) {
        if (serverWorld == null) {
            return FRIENDSHIP_FILE;
        }
        return serverWorld.method_8503().method_27050(class_5218.field_24188).resolve("speakingvillagersmod/friendships.json").toString();
    }

    private static String getVillagerNameOrProfession(class_1646 villager) {
        if (villager.method_16914()) {
            return villager.method_5797().getString();
        }
        return villager.method_7231().method_16924().toString().toLowerCase();
    }

    private static void incrementInteractionCount(class_1646 villager, class_1657 player) {
        UUID villagerId = villager.method_5667();
        UUID playerId = player.method_5667();
        interactionCounter.computeIfAbsent(villagerId, k -> new HashMap()).merge(playerId, 1, Integer::sum);
    }

    public static void handleReputationCheck(class_1646 villager, class_3222 player) {
        try {
            if (villager == null || player == null) {
                LOGGER.error("Villager or Player is null during reputation check");
                return;
            }
            boolean isBefriended = VillagerFriendshipManager.isBefriended(villager);
            int reputation = villager.method_20594((class_1657)player);
            if (reputation < 0 && isBefriended) {
                VillagerFriendshipManager.unfriendVillager(villager, player);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while checking reputation for villager " + String.valueOf(villager.method_5667()) + " and player " + String.valueOf(player.method_5667()), (Throwable)e);
        }
    }
}

