/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.handlers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1646;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3218;

public class VillagerStyleManager {
    private static final Gson GSON = new Gson();
    private static final Random random = new Random();
    private static final Map<String, Map<UUID, VillagerStyleData>> worldStylesCache = new HashMap<String, Map<UUID, VillagerStyleData>>();
    private static final List<WeightedStyle> weightedStyles = new ArrayList<WeightedStyle>();

    private static File getWorldStylesDirectory() {
        File minecraftDir = class_310.method_1551().field_1697;
        return new File(minecraftDir, "speakingvillagersmod/styles");
    }

    private static File getWorldStylesFile(class_3218 world) {
        String worldName = world.method_8503().method_27728().method_150();
        File stylesDir = VillagerStyleManager.getWorldStylesDirectory();
        return new File(stylesDir, worldName + ".json");
    }

    public static void loadStyles(class_3218 world) {
        File stylesFile = VillagerStyleManager.getWorldStylesFile(world);
        if (!stylesFile.exists()) {
            System.out.println("Styles file not found for world: " + stylesFile.getAbsolutePath());
            return;
        }
        try (FileReader reader = new FileReader(stylesFile);){
            Type type = new TypeToken<Map<UUID, VillagerStyleData>>(){}.getType();
            Map worldStyles = (Map)GSON.fromJson((Reader)reader, type);
            if (worldStyles != null) {
                String worldName = world.method_8503().method_27728().method_150();
                worldStylesCache.put(worldName, worldStyles);
                System.out.println("Loaded styles for world: " + worldName);
            } else {
                System.out.println("No styles found in the file for world: " + stylesFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            System.err.println("Error loading styles for world: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void saveStyles(class_3218 world) {
        File stylesFile = VillagerStyleManager.getWorldStylesFile(world);
        if (!stylesFile.getParentFile().exists() && !stylesFile.getParentFile().mkdirs()) {
            System.err.println("Failed to create directory for styles: " + stylesFile.getParentFile().getAbsolutePath());
            return;
        }
        try (FileWriter writer = new FileWriter(stylesFile);){
            String worldName = world.method_8503().method_27728().method_150();
            Map worldStyles = worldStylesCache.getOrDefault(worldName, new HashMap());
            GSON.toJson((Object)worldStyles, (Appendable)writer);
            System.out.println("Saved styles to: " + stylesFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("Error saving styles to file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static String[] getStyle(class_1646 villager, class_3218 world) {
        String worldName = world.method_8503().method_27728().method_150();
        if (!worldStylesCache.containsKey(worldName)) {
            VillagerStyleManager.loadStyles(world);
        }
        UUID villagerId = villager.method_5667();
        Map worldStyles = worldStylesCache.computeIfAbsent(worldName, k -> new HashMap());
        return worldStyles.computeIfAbsent(villagerId, id -> new VillagerStyleData(VillagerStyleManager.getRandomWeightedStyle(), VillagerStyleManager.getVillagerName(villager))).getStyle();
    }

    public static void setStyle(class_1646 villager, class_3218 world, String[] style) {
        String worldName = world.method_8503().method_27728().method_150();
        Map worldStyles = worldStylesCache.getOrDefault(worldName, new HashMap());
        String villagerName = VillagerStyleManager.getVillagerName(villager);
        VillagerStyleData styleData = new VillagerStyleData(style, villagerName);
        worldStyles.put(villager.method_5667(), styleData);
        worldStylesCache.put(worldName, worldStyles);
        VillagerStyleManager.saveStyles(world);
    }

    private static void initializeWeightedStyles() {
        weightedStyles.addAll(Arrays.asList(new WeightedStyle("Standard", new String[]{"You are a no-nonsense villager. You speak plainly and focus on your daily tasks."}, 25), new WeightedStyle("Friendly", new String[]{"You are cheerful and approachable, always eager to chat with anyone who stops by."}, 20), new WeightedStyle("Hardworking", new String[]{"You speak with pride about your work, always striving to achieve perfection in your trade."}, 18), new WeightedStyle("Grumpy", new String[]{"You often complain about the world, using dry humor and sarcastic remarks to get your point across."}, 15), new WeightedStyle("Lazy", new String[]{"You talk in a relaxed, uninterested tone, often commenting about how much effort everything takes."}, 12), new WeightedStyle("Funny", new String[]{"You sprinkle jokes and witty remarks into your conversations, always aiming to make others laugh."}, 18), new WeightedStyle("Musical", new String[]{"You speak in rhymes or songs, always rhyming and making up lyrics on the spot."}, 12), new WeightedStyle("Curious", new String[]{"You ask lots of questions, eagerly seeking to learn more about the world and the player."}, 10), new WeightedStyle("Craftsman", new String[]{"You describe your work with passion, often sharing details about your tools and creations."}, 10), new WeightedStyle("Merchant", new String[]{"You are sharp and business-minded, always seeking to strike a good deal or promote your wares."}, 15), new WeightedStyle("Romantic", new String[]{"You speak with poetic flair, often describing the beauty of life and love in your words."}, 8), new WeightedStyle("Heroic", new String[]{"You use grand language, often framing your words as tales of valor and adventure."}, 7), new WeightedStyle("Shy", new String[]{"You speak softly and briefly, avoiding prolonged conversations or drawing attention to yourself."}, 9), new WeightedStyle("Mysterious", new String[]{"You speak in riddles, often hinting at secrets and deeper meanings in your words."}, 6), new WeightedStyle("Philosopher", new String[]{"You ponder life\u2019s biggest questions, sharing thought-provoking ideas and musings."}, 6), new WeightedStyle("Haunted", new String[]{"Your voice carries an eerie tone, and you occasionally mention ghosts or strange occurrences."}, 5), new WeightedStyle("MadScientist", new String[]{"You ramble excitedly about bizarre experiments and far-fetched ideas."}, 4), new WeightedStyle("Possessed", new String[]{"Your words are cryptic and unsettling, as though they come from another entity."}, 3), new WeightedStyle("Voodoo Priest", new String[]{"You speak of spirits, rituals, and unseen forces with an air of mysticism."}, 3), new WeightedStyle("Visionary", new String[]{"You talk about grand dreams and future possibilities, inspiring those who listen."}, 2), new WeightedStyle("Mischievous", new String[]{"You tease others and playfully twist your words, enjoying harmless pranks."}, 7), new WeightedStyle("Maniacal", new String[]{"You laugh wildly and talk with giddy excitement about chaos and unpredictability."}, 4), new WeightedStyle("Creepy", new String[]{"You say unsettling things in a monotone, leaving others feeling a bit uneasy."}, 3), new WeightedStyle("Paranoid", new String[]{"You whisper about dangers and conspiracies, trusting no one."}, 4), new WeightedStyle("Shadowy", new String[]{"You blend into the background, speaking cryptically and with hidden intent."}, 3), new WeightedStyle("Royal", new String[]{"You carry yourself with grace and authority, speaking as if you rule the village."}, 2), new WeightedStyle("LegendaryHero", new String[]{"You tell epic tales of your deeds, inspiring others with your words."}, 2), new WeightedStyle("Explorer", new String[]{"You share stories of distant lands and encourage others to embrace adventure."}, 5), new WeightedStyle("Nostalgic", new String[]{"You reminisce about the past, often comparing it to the present with a wistful tone."}, 5), new WeightedStyle("CraftsmanElite", new String[]{"You are a master of your craft, speaking with precision and pride about your work."}, 4), new WeightedStyle("Wanderer", new String[]{"You are a wandering soul, always yearning for distant lands and new horizons."}, 8), new WeightedStyle("Storyteller", new String[]{"You weave captivating tales of adventure, both real and imagined, to anyone who will listen."}, 7), new WeightedStyle("TreasureHunter", new String[]{"You have a nose for valuable finds and speak eagerly about hidden loot and treasures."}, 5), new WeightedStyle("Skywatcher", new String[]{"You gaze at the stars and speak poetically about the skies and the mysteries above."}, 5), new WeightedStyle("Eccentric", new String[]{"Your words are odd and whimsical, often straying into strange and unpredictable territory."}, 6), new WeightedStyle("Collector", new String[]{"You obsess over rare items, always talking about your growing collection of oddities."}, 5), new WeightedStyle("Hypochondriac", new String[]{"You constantly worry about your health, frequently mentioning ailments and remedies."}, 4), new WeightedStyle("Gourmet", new String[]{"You speak passionately about food, sharing recipes and opinions on culinary delights."}, 5), new WeightedStyle("Chatterbox", new String[]{"You talk endlessly, often jumping from one topic to another without pause."}, 6), new WeightedStyle("Dreamer", new String[]{"You often talk about visions and dreams, weaving them into your understanding of the world."}, 5), new WeightedStyle("Oracle", new String[]{"You speak cryptically, hinting at future events and destinies yet to unfold."}, 3), new WeightedStyle("Alchemist", new String[]{"You discuss potions and magical experiments, with a fascination for the mystical arts."}, 4), new WeightedStyle("Seer", new String[]{"You appear to sense things others cannot, offering cryptic advice and warnings."}, 4), new WeightedStyle("Ascetic", new String[]{"You speak of simplicity and detachment, focusing on the greater truths of life."}, 3), new WeightedStyle("Punster", new String[]{"You can\u2019t resist making puns, often at the expense of groaning listeners."}, 8), new WeightedStyle("Optimist", new String[]{"You see the bright side of every situation, encouraging others to stay positive."}, 10), new WeightedStyle("Prankster", new String[]{"You enjoy playful mischief, often teasing others with harmless tricks."}, 7), new WeightedStyle("Clumsy", new String[]{"You frequently comment on your own mishaps and accidents with self-deprecating humor."}, 6), new WeightedStyle("Daydreamer", new String[]{"You lose track of conversations, often drifting into unrelated musings or whimsical thoughts."}, 8), new WeightedStyle("Lonely", new String[]{"You crave connection but struggle to express yourself, often speaking hesitantly."}, 5), new WeightedStyle("Melancholy", new String[]{"You speak in a somber tone, reflecting on life\u2019s hardships and bittersweet moments."}, 4), new WeightedStyle("Enigmatic", new String[]{"You answer questions with cryptic statements, keeping others guessing about your intentions."}, 4), new WeightedStyle("Stoic", new String[]{"You are calm and composed, rarely showing emotion in your words or actions."}, 5), new WeightedStyle("Ghostly", new String[]{"You seem distant, often alluding to an otherworldly presence or past."}, 5), new WeightedStyle("Playful", new String[]{"You treat life as a game, often inviting others to join in your fun."}, 6), new WeightedStyle("Imaginative", new String[]{"You invent fantastical stories and speak as if living in a world of your own creation."}, 5), new WeightedStyle("PetEnthusiast", new String[]{"You love animals and speak warmly about any creatures you see or hear about."}, 7), new WeightedStyle("GardenLover", new String[]{"You adore flowers and plants, often commenting on the beauty of nature."}, 6), new WeightedStyle("Dimwitted", new String[]{"You are a extremely dumb villager. Your thoughts often wander, and you sometimes say things that make very little sense."}, 15)));
    }

    private static String[] getRandomWeightedStyle() {
        int totalWeight = weightedStyles.stream().mapToInt(WeightedStyle::getWeight).sum();
        int randomIndex = random.nextInt(totalWeight);
        int currentWeight = 0;
        for (WeightedStyle weightedStyle : weightedStyles) {
            if (randomIndex >= (currentWeight += weightedStyle.getWeight())) continue;
            return weightedStyle.getStyle();
        }
        return weightedStyles.get(0).getStyle();
    }

    public static boolean styleExists(String styleName) {
        return weightedStyles.stream().anyMatch(style -> style.name.equalsIgnoreCase(styleName));
    }

    public static String[] getStyleByName(String styleName) {
        return weightedStyles.stream().filter(style -> style.name.equalsIgnoreCase(styleName)).findFirst().map(WeightedStyle::getStyle).orElse(null);
    }

    private static String getVillagerName(class_1646 villager) {
        return villager.method_16914() ? villager.method_5797().getString() : null;
    }

    public static void applyStyle(class_1646 villager, class_3218 world) {
        String[] style = VillagerStyleManager.getStyle(villager, world);
        if (style != null && style.length > 0) {
            class_2487 nbt = new class_2487();
            villager.method_5647(nbt);
            nbt.method_10582("VillagerStyle", style[0]);
            if (style.length > 1) {
                nbt.method_10582("VillagerDialogue", style[1]);
            } else {
                nbt.method_10582("VillagerDialogue", "");
            }
            villager.method_5651(nbt);
        }
    }

    static {
        VillagerStyleManager.initializeWeightedStyles();
    }

    private static class VillagerStyleData {
        private final String[] style;
        private final String name;

        public VillagerStyleData(String[] style, String name) {
            this.style = style;
            this.name = name;
        }

        public String[] getStyle() {
            return this.style;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class WeightedStyle {
        private final String name;
        private final String[] style;
        private final int weight;

        public WeightedStyle(String name, String[] style, int weight) {
            this.name = name;
            this.style = style;
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }

        public String[] getStyle() {
            return this.style;
        }
    }
}

