/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.handlers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1646;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import speakingvillagers.sv.config.ModConfig;
import speakingvillagers.sv.config.ModConfigManager;

public class VisualEffectsManager {
    private static ScheduledExecutorService auraScheduler;
    private static ScheduledExecutorService noddingScheduler;
    private static final Map<UUID, ScheduledExecutorService> heartEffectSchedulers;
    private static final Map<UUID, ScheduledExecutorService> auraSchedulers;
    private static final Map<UUID, ScheduledExecutorService> speakingSchedulers;
    private static class_1646 activeAuraVillager;
    private static final Map<class_1646, ScheduledExecutorService> noddingSchedulers;

    public static void stopAllEffects() {
        auraSchedulers.values().forEach(scheduler -> {
            if (!scheduler.isShutdown()) {
                scheduler.shutdownNow();
            }
        });
        auraSchedulers.clear();
        speakingSchedulers.values().forEach(scheduler -> {
            if (!scheduler.isShutdown()) {
                scheduler.shutdownNow();
            }
        });
        speakingSchedulers.clear();
        heartEffectSchedulers.values().forEach(scheduler -> {
            if (!scheduler.isShutdown()) {
                scheduler.shutdownNow();
            }
        });
        heartEffectSchedulers.clear();
    }

    public static void applyHeartEffect(class_1646 villager) {
        UUID villagerId = villager.method_5667();
        ModConfig config = ModConfigManager.getConfig();
        if (config.disableVisualEffects) {
            return;
        }
        if (!config.enableHeartEffects) {
            return;
        }
        if (heartEffectSchedulers.containsKey(villagerId)) {
            VisualEffectsManager.stopHeartEffect(villager);
        }
        class_3218 world = (class_3218)villager.method_37908();
        double yOffset = 2.35;
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        heartEffectSchedulers.put(villagerId, scheduler);
        scheduler.scheduleAtFixedRate(() -> {
            if (!villager.method_31481()) {
                class_243 villagerPos = villager.method_19538();
                world.method_14199((class_2394)class_2398.field_11201, villagerPos.field_1352, villagerPos.field_1351 + yOffset, villagerPos.field_1350, 3, 0.0, 0.0, 0.0, 0.02);
            } else {
                VisualEffectsManager.stopHeartEffect(villager);
            }
        }, 0L, 3L, TimeUnit.SECONDS);
    }

    public static void stopHeartEffect(class_1646 villager) {
        UUID villagerId = villager.method_5667();
        ScheduledExecutorService scheduler = heartEffectSchedulers.remove(villagerId);
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
    }

    public static void stopAllHeartEffects() {
        for (ScheduledExecutorService scheduler : heartEffectSchedulers.values()) {
            scheduler.shutdownNow();
        }
        heartEffectSchedulers.clear();
    }

    public static void applyVillagerAura(class_1646 villager) {
        if (activeAuraVillager != null && !activeAuraVillager.equals((Object)villager)) {
            VisualEffectsManager.stopVillagerAura(activeAuraVillager);
        }
        ModConfig config = ModConfigManager.getConfig();
        if (config.disableVisualEffects) {
            return;
        }
        if (!config.enableAuraEffects) {
            return;
        }
        activeAuraVillager = villager;
        class_3218 world = (class_3218)villager.method_37908();
        double radius = 0.5;
        int tickInterval = 10;
        auraScheduler = Executors.newSingleThreadScheduledExecutor();
        auraScheduler.scheduleAtFixedRate(() -> {
            if (!villager.method_31481()) {
                class_243 villagerPos = villager.method_19538();
                for (int i = 0; i < 360; i += 120) {
                    double angle = Math.toRadians(i);
                    double xOffset = radius * Math.cos(angle);
                    double zOffset = radius * Math.sin(angle);
                    world.method_14199((class_2394)class_2398.field_11207, villagerPos.field_1352 + xOffset, villagerPos.field_1351 + 0.4, villagerPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.01);
                }
            } else {
                VisualEffectsManager.stopVillagerAura(villager);
            }
        }, 0L, (long)tickInterval * 50L, TimeUnit.MILLISECONDS);
    }

    public static void stopVillagerAura(class_1646 villager) {
        if (activeAuraVillager != null && activeAuraVillager.equals((Object)villager)) {
            if (auraScheduler != null && !auraScheduler.isShutdown()) {
                auraScheduler.shutdownNow();
            }
            activeAuraVillager = null;
        }
    }

    public static void startHeadNoddingEffect(class_1646 villager) {
        if (noddingSchedulers.containsKey(villager)) {
            return;
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        noddingSchedulers.put(villager, scheduler);
        scheduler.scheduleAtFixedRate(() -> {
            if (!villager.method_31481()) {
                float newPitch = (float)Math.sin((double)System.currentTimeMillis() / 300.0) * 5.0f;
                villager.method_36457(newPitch);
            } else {
                VisualEffectsManager.stopHeadNoddingEffect(villager);
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public static void stopHeadNoddingEffect(class_1646 villager) {
        ScheduledExecutorService scheduler = noddingSchedulers.remove(villager);
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdownNow();
        }
    }

    public static void stopHeadNoddingEffect() {
        if (noddingScheduler != null && !noddingScheduler.isShutdown()) {
            noddingScheduler.shutdownNow();
            noddingScheduler = null;
        }
    }

    public static void startSpeakingEffect(class_1646 villager) {
        UUID villagerId = villager.method_5667();
        VisualEffectsManager.stopSpeakingEffect(villager);
        ModConfig config = ModConfigManager.getConfig();
        if (config.disableVisualEffects) {
            return;
        }
        if (!config.enableSpeakingEffects) {
            return;
        }
        class_3218 world = (class_3218)villager.method_37908();
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        speakingSchedulers.put(villagerId, scheduler);
        scheduler.scheduleAtFixedRate(() -> {
            if (!villager.method_31481()) {
                class_243 vecPos = villager.method_19538();
                world.method_14199((class_2394)class_2398.field_11224, vecPos.field_1352, vecPos.field_1351 + 1.5, vecPos.field_1350, 1, 0.5, 0.5, 0.5, 0.1);
            } else {
                VisualEffectsManager.stopSpeakingEffect(villager);
            }
        }, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    public static void stopSpeakingEffect(class_1646 villager) {
        UUID villagerId = villager.method_5667();
        ScheduledExecutorService scheduler = speakingSchedulers.remove(villagerId);
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdownNow();
        }
    }

    public static void triggerSpeakEffect(class_1646 villager) {
        VisualEffectsManager.startSpeakingEffect(villager);
    }

    static {
        heartEffectSchedulers = new ConcurrentHashMap<UUID, ScheduledExecutorService>();
        auraSchedulers = new ConcurrentHashMap<UUID, ScheduledExecutorService>();
        speakingSchedulers = new ConcurrentHashMap<UUID, ScheduledExecutorService>();
        noddingSchedulers = new ConcurrentHashMap<class_1646, ScheduledExecutorService>();
    }
}

