/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.quest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_3852;
import speakingvillagers.sv.quest.Quest;

public class QuestManager {
    private static final Map<class_3852, List<String>> professionItems = new HashMap<class_3852, List<String>>();
    private static final Map<String, Integer> itemRarity = new HashMap<String, Integer>();
    private static final Map<String, List<String>> rewardTiers = new HashMap<String, List<String>>();
    private static final Random RANDOM = new Random();

    public static Quest generateRandomQuest(class_3852 profession) {
        return QuestManager.generateGatherQuest(profession);
    }

    private static Quest generateGatherQuest(class_3852 profession) {
        List<String> items = professionItems.get(profession);
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("No items found for profession: " + String.valueOf(profession));
        }
        String item = items.get(RANDOM.nextInt(items.size()));
        int rarity = itemRarity.getOrDefault(item, 10);
        int minTargetAmount = Math.max(1, rarity / 2);
        int targetAmount = Math.min(64, minTargetAmount + RANDOM.nextInt(minTargetAmount));
        String rewardTier = QuestManager.determineRewardTier(rarity);
        List<String> rewards = rewardTiers.get(rewardTier);
        if (rewards == null || rewards.isEmpty()) {
            throw new IllegalArgumentException("No rewards found for tier: " + rewardTier);
        }
        String reward = rewards.get(RANDOM.nextInt(rewards.size()));
        return new Quest(item, targetAmount, reward);
    }

    private static String determineRewardTier(int rarity) {
        if (rarity <= 5) {
            return "hard";
        }
        if (rarity <= 15) {
            return "medium";
        }
        return "easy";
    }

    static {
        professionItems.put(class_3852.field_17056, Arrays.asList("minecraft:wheat", "minecraft:carrot", "minecraft:potato", "minecraft:beetroot", "minecraft:melon_slice", "minecraft:pumpkin", "minecraft:sweet_berries", "minecraft:honey_bottle"));
        professionItems.put(class_3852.field_17065, Arrays.asList("minecraft:iron_ingot", "minecraft:coal", "minecraft:gold_ingot", "minecraft:obsidian", "minecraft:flint", "minecraft:blaze_rod", "minecraft:nether_brick", "minecraft:quartz"));
        professionItems.put(class_3852.field_17060, Arrays.asList("minecraft:book", "minecraft:paper", "minecraft:ink_sac", "minecraft:feather", "minecraft:quill", "minecraft:lapis_lazuli", "minecraft:enchanted_book"));
        professionItems.put(class_3852.field_17053, Arrays.asList("minecraft:beef", "minecraft:porkchop", "minecraft:chicken", "minecraft:rabbit", "minecraft:mutton", "minecraft:leather", "minecraft:cooked_beef"));
        professionItems.put(class_3852.field_17058, Arrays.asList("minecraft:arrow", "minecraft:string", "minecraft:feather", "minecraft:flint", "minecraft:stick", "minecraft:bow", "minecraft:crossbow"));
        professionItems.put(class_3852.field_17057, Arrays.asList("minecraft:cod", "minecraft:salmon", "minecraft:tropical_fish", "minecraft:pufferfish", "minecraft:clay_ball", "minecraft:prismarine_shard", "minecraft:prismarine_crystals"));
        professionItems.put(class_3852.field_17061, Arrays.asList("minecraft:clay_ball", "minecraft:bricks", "minecraft:stone", "minecraft:granite", "minecraft:andesite", "minecraft:diorite", "minecraft:nether_brick", "minecraft:red_sandstone", "minecraft:quartz_block"));
        professionItems.put(class_3852.field_17055, Arrays.asList("minecraft:rotten_flesh", "minecraft:spider_eye", "minecraft:nether_wart", "minecraft:redstone", "minecraft:ghast_tear", "minecraft:phantom_membrane", "minecraft:glowstone_dust"));
        professionItems.put(class_3852.field_17062, Arrays.asList("minecraft:dirt", "minecraft:stick", "minecraft:cobblestone", "minecraft:apple"));
        professionItems.put(class_3852.field_17051, Arrays.asList("minecraft:oak_log", "minecraft:sand", "minecraft:gravel", "minecraft:torch", "minecraft:bread", "minecraft:leather", "minecraft:string"));
        itemRarity.put("minecraft:wheat", 20);
        itemRarity.put("minecraft:carrot", 15);
        itemRarity.put("minecraft:potato", 15);
        itemRarity.put("minecraft:beetroot", 10);
        itemRarity.put("minecraft:melon_slice", 8);
        itemRarity.put("minecraft:pumpkin", 5);
        itemRarity.put("minecraft:sweet_berries", 7);
        itemRarity.put("minecraft:honey_bottle", 3);
        itemRarity.put("minecraft:iron_ingot", 10);
        itemRarity.put("minecraft:coal", 12);
        itemRarity.put("minecraft:gold_ingot", 5);
        itemRarity.put("minecraft:obsidian", 3);
        itemRarity.put("minecraft:flint", 15);
        itemRarity.put("minecraft:blaze_rod", 2);
        itemRarity.put("minecraft:nether_brick", 5);
        itemRarity.put("minecraft:quartz", 10);
        itemRarity.put("minecraft:book", 10);
        itemRarity.put("minecraft:paper", 20);
        itemRarity.put("minecraft:ink_sac", 8);
        itemRarity.put("minecraft:feather", 10);
        itemRarity.put("minecraft:quill", 6);
        itemRarity.put("minecraft:lapis_lazuli", 12);
        itemRarity.put("minecraft:enchanted_book", 1);
        itemRarity.put("minecraft:beef", 15);
        itemRarity.put("minecraft:porkchop", 15);
        itemRarity.put("minecraft:chicken", 15);
        itemRarity.put("minecraft:rabbit", 8);
        itemRarity.put("minecraft:mutton", 10);
        itemRarity.put("minecraft:leather", 10);
        itemRarity.put("minecraft:cooked_beef", 12);
        itemRarity.put("minecraft:arrow", 20);
        itemRarity.put("minecraft:string", 15);
        itemRarity.put("minecraft:stick", 25);
        itemRarity.put("minecraft:bow", 10);
        itemRarity.put("minecraft:crossbow", 5);
        itemRarity.put("minecraft:cod", 12);
        itemRarity.put("minecraft:salmon", 10);
        itemRarity.put("minecraft:tropical_fish", 5);
        itemRarity.put("minecraft:pufferfish", 5);
        itemRarity.put("minecraft:clay_ball", 10);
        itemRarity.put("minecraft:prismarine_shard", 4);
        itemRarity.put("minecraft:prismarine_crystals", 3);
        itemRarity.put("minecraft:bricks", 8);
        itemRarity.put("minecraft:stone", 15);
        itemRarity.put("minecraft:granite", 12);
        itemRarity.put("minecraft:andesite", 12);
        itemRarity.put("minecraft:diorite", 12);
        itemRarity.put("minecraft:red_sandstone", 7);
        itemRarity.put("minecraft:quartz_block", 5);
        itemRarity.put("minecraft:rotten_flesh", 20);
        itemRarity.put("minecraft:spider_eye", 10);
        itemRarity.put("minecraft:nether_wart", 5);
        itemRarity.put("minecraft:redstone", 15);
        itemRarity.put("minecraft:ghast_tear", 2);
        itemRarity.put("minecraft:phantom_membrane", 3);
        itemRarity.put("minecraft:glowstone_dust", 8);
        itemRarity.put("minecraft:dirt", 30);
        itemRarity.put("minecraft:cobblestone", 20);
        itemRarity.put("minecraft:apple", 10);
        itemRarity.put("minecraft:oak_log", 15);
        itemRarity.put("minecraft:sand", 20);
        itemRarity.put("minecraft:gravel", 15);
        itemRarity.put("minecraft:torch", 10);
        itemRarity.put("minecraft:bread", 10);
        rewardTiers.put("easy", Arrays.asList("minecraft:iron_ingot", "minecraft:leather", "minecraft:bow", "minecraft:honey_bottle", "minecraft:bread", "minecraft:iron_boots", "minecraft:raw_iron", "minecraft:glowstone_block", "minecraft:lapis_lazuli"));
        rewardTiers.put("medium", Arrays.asList("minecraft:golden_apple", "minecraft:diamond", "minecraft:gold_ingot", "minecraft:ender_pearl", "minecraft:blaze_powder", "minecraft:obsidian", "minecraft:prismarine_shard", "minecraft:slime_ball", "minecraft:ghast_tear", "minecraft:emerald", "minecraft:crossbow"));
        rewardTiers.put("hard", Arrays.asList("minecraft:netherite_ingot", "minecraft:totem_of_undying", "minecraft:enchanted_golden_apple", "minecraft:beacon", "minecraft:heart_of_the_sea", "minecraft:shulker_box", "minecraft:dragon_head", "minecraft:nether_star", "minecraft:trident"));
    }
}

