/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.quest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import speakingvillagers.sv.config.ModConfig;
import speakingvillagers.sv.config.ModConfigManager;
import speakingvillagers.sv.quest.Quest;

public class QuestTracker {
    private static final Map<UUID, Map<UUID, Quest>> questMap = new ConcurrentHashMap<UUID, Map<UUID, Quest>>();
    private static final String QUEST_DATA_DIR = "speakingvillagersmod/questdata";
    private static final String QUEST_DATA_FILE = "quest_data.dat";

    public static void assignQuest(class_3222 player, class_1646 villager, Quest quest) {
        questMap.computeIfAbsent(player.method_5667(), k -> new ConcurrentHashMap()).put(villager.method_5667(), quest);
        QuestTracker.markVillager(villager);
        quest.setMarked(true);
    }

    public static Quest getQuest(class_3222 player, class_1646 villager) {
        Map<UUID, Quest> villagerQuests = questMap.get(player.method_5667());
        if (villagerQuests != null) {
            return villagerQuests.get(villager.method_5667());
        }
        return null;
    }

    public static void removeItemsFromInventory(class_3222 player, String itemId, int amountToRemove) {
        int amountRemoved = 0;
        class_2960 itemIdentifier = class_2960.method_60654((String)itemId);
        class_1792 targetItem = (class_1792)class_7923.field_41178.method_63535(itemIdentifier);
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || !stack.method_7909().equals(targetItem)) continue;
            int stackSize = stack.method_7947();
            int removeAmount = Math.min(stackSize, amountToRemove - amountRemoved);
            stack.method_7934(removeAmount);
            if ((amountRemoved += removeAmount) < amountToRemove) continue;
            break;
        }
    }

    public static boolean checkQuestCompletion(class_3222 player, class_1646 villager) {
        int previousCount;
        int itemCount;
        Quest quest = QuestTracker.getQuest(player, villager);
        if (quest != null && !quest.isCompleted() && (itemCount = QuestTracker.countItemsInInventory(player, quest.getTarget())) > (previousCount = quest.getProgress())) {
            quest.setProgress(itemCount);
            if (itemCount >= quest.getTargetAmount()) {
                quest.setCompleted(true);
                player.method_7353((class_2561)class_2561.method_43470((String)"Quest Completed!"), false);
                QuestTracker.removeItemsFromInventory(player, quest.getTarget(), quest.getTargetAmount());
                QuestTracker.unmarkVillager(villager);
                return true;
            }
        }
        return false;
    }

    public static int countItemsInInventory(class_3222 player, String itemName) {
        int count = 0;
        class_2960 itemId = class_2960.method_60654((String)itemName);
        class_1792 targetItem = (class_1792)class_7923.field_41178.method_63535(itemId);
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || !stack.method_7909().equals(targetItem)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static void giveReward(class_3222 player, class_1646 villager) {
        Quest quest = QuestTracker.getQuest(player, villager);
        if (quest != null && quest.isCompleted()) {
            class_1799 rewardStack = QuestTracker.getRewardItem(quest.getReward());
            player.method_31548().method_7394(rewardStack);
            questMap.get(player.method_5667()).remove(villager.method_5667());
        }
    }

    private static class_1799 getRewardItem(String rewardName) {
        class_2960 rewardId = class_2960.method_60654((String)rewardName);
        class_1792 rewardItem = (class_1792)class_7923.field_41178.method_63535(rewardId);
        return new class_1799((class_1935)rewardItem, 1);
    }

    private static void markVillager(class_1646 villager) {
        ModConfig config = ModConfigManager.getConfig();
        if (config.disableVisualEffects) {
            villager.method_6016(class_1294.field_5912);
            return;
        }
        if (!config.enableQuestEffects) {
            villager.method_6016(class_1294.field_5912);
            return;
        }
        villager.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
    }

    private static void unmarkVillager(class_1646 villager) {
        villager.method_6016(class_1294.field_5912);
    }

    public static void saveQuestData() {
        File dir = new File(QuestTracker.getMinecraftDirectory(), QUEST_DATA_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File tempFile = new File(dir, "quest_data.dat.tmp");
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(tempFile));){
            oos.writeObject(questMap);
            tempFile.renameTo(new File(dir, QUEST_DATA_FILE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadQuestData() {
        File file = new File(QuestTracker.getMinecraftDirectory(), QUEST_DATA_DIR + File.separator + QUEST_DATA_FILE);
        if (!file.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            Map loadedMap = (Map)ois.readObject();
            questMap.clear();
            questMap.putAll(loadedMap);
            loadedMap.forEach((playerUUID, villagerQuests) -> villagerQuests.forEach((villagerUUID, quest) -> {
                class_1646 villager;
                if (quest.isMarked() && (villager = QuestTracker.getVillagerByUUID(villagerUUID)) != null) {
                    QuestTracker.markVillager(villager);
                }
            }));
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static class_1646 getVillagerByUUID(UUID villagerUUID) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1687 == null) {
            return null;
        }
        for (class_1297 entity : client.field_1687.method_18112()) {
            class_1646 villager;
            if (!(entity instanceof class_1646) || !(villager = (class_1646)entity).method_5667().equals(villagerUUID)) continue;
            return villager;
        }
        return null;
    }

    private static File getMinecraftDirectory() {
        return class_310.method_1551().field_1697;
    }
}

