/*
 * Decompiled with CFR 0.152.
 */
package speakingvillagers.sv.textgeneration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import speakingvillagers.sv.config.ModConfig;
import speakingvillagers.sv.config.ModConfigManager;
import speakingvillagers.sv.handlers.ConversationManager;
import speakingvillagers.sv.handlers.VillagerFriendshipManager;
import speakingvillagers.sv.handlers.VillagerStyleManager;
import speakingvillagers.sv.handlers.VisualEffectsManager;
import speakingvillagers.sv.quest.Quest;
import speakingvillagers.sv.quest.QuestManager;
import speakingvillagers.sv.quest.QuestTracker;
import speakingvillagers.sv.textgeneration.BiomeMessages;
import speakingvillagers.sv.textgeneration.RareBlockDetection;
import speakingvillagers.sv.textgeneration.StructureMessages;

public class TextGenerator {
    private static final String API_KEY = System.getenv("OPENAI_API_KEY");
    private static final String API_URL = "https://api.openai.com/v1/chat/completions";
    private final ConversationManager conversationManager;

    private int countItemsInInventory(class_3222 player, String itemName) {
        int count = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || !stack.method_7909().equals(class_7923.field_41178.method_63535(class_2960.method_60654((String)itemName)))) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public TextGenerator(ConversationManager conversationManager) {
        this.conversationManager = conversationManager;
    }

    private String getItemDisplayName(String itemId) {
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemId));
        class_1799 itemStack = new class_1799((class_1935)item);
        return itemStack.method_7964().getString();
    }

    public String generateResponse(String villagerName, class_1646 villager, String input, class_1799 itemInHand, class_3222 player) {
        VisualEffectsManager.triggerSpeakEffect(villager);
        try {
            class_3218 world = (class_3218)villager.method_37908();
            String villagerId = villager.method_5667().toString();
            StringBuilder systemPrompt = new StringBuilder();
            this.appendQuestDetails(systemPrompt, player, villager);
            this.appendVillagerContext(systemPrompt, villagerName, villager, world);
            this.appendPlayerDetails(systemPrompt, player, villager);
            this.appendFriendshipMessage(systemPrompt, villager, player);
            this.appendEnvironmentDetails(systemPrompt, villager, world);
            this.appendNearbyStructureMessage(systemPrompt, world, villager.method_24515());
            this.appendVillagerStyleAndProfession(systemPrompt, villager);
            this.appendTradeOffers(systemPrompt, villager);
            this.appendRareBlocks(systemPrompt, world, villager);
            this.appendNearbyEntities(systemPrompt, villager);
            systemPrompt.append("You should strictly respond to the player in the first person, as if you are speaking directly to them. ").append("Let the player immerse in the world of Minecraft. Be sure to include details about the player's reputation, his state, equipment, environment, and surroundings").append("Respond in no more than 80 words and always use the villager's perspective.");
            JsonObject jsonBody = this.prepareApiRequest(systemPrompt, villagerId, input);
            return this.fetchResponseFromApi(jsonBody, villagerId, input);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Sorry, an error occurred while generating the response.";
        }
    }

    private void appendQuestDetails(StringBuilder systemPrompt, class_3222 player, class_1646 villager) {
        Quest newQuest;
        ModConfig config = ModConfigManager.getConfig();
        double questChance = (double)config.questChancePercentage / 100.0;
        Quest quest = QuestTracker.getQuest(player, villager);
        if (quest != null) {
            int collectedItems = this.countItemsInInventory(player, quest.getTarget());
            int remainingItems = quest.getTargetAmount() - collectedItems;
            String itemDisplayName = this.getItemDisplayName(quest.getTarget());
            String rewardDisplayName = this.getItemDisplayName(quest.getReward());
            if (QuestTracker.checkQuestCompletion(player, villager)) {
                QuestTracker.giveReward(player, villager);
                systemPrompt.append("The player has completed a quest you gave them. ").append("The quest required them to bring ").append(quest.getTargetAmount()).append(" ").append(itemDisplayName).append(". ").append("They successfully brought the required items, and you rewarded them with ").append(rewardDisplayName).append(". ").append("Congratulate the player for their effort.");
            } else {
                systemPrompt.append("The player is currently on a quest you gave them. ").append("The quest requires them to bring ").append(quest.getTargetAmount()).append(" ").append(itemDisplayName).append(". ").append("So far, they have collected ").append(collectedItems).append(". ").append("They still need ").append(remainingItems).append(" more ").append(itemDisplayName).append(". ").append("Once completed, the player will receive ").append(rewardDisplayName).append(". ").append("Encourage the player to keep collecting items.");
            }
        } else if (Math.random() < questChance && (newQuest = QuestManager.generateRandomQuest(villager.method_7231().method_16924())) != null) {
            QuestTracker.assignQuest(player, villager, newQuest);
            String newItemDisplayName = this.getItemDisplayName(newQuest.getTarget());
            String newRewardDisplayName = this.getItemDisplayName(newQuest.getReward());
            systemPrompt.append("You have a new quest for the player. ").append("Ask them to bring ").append(newQuest.getTargetAmount()).append(" ").append(newItemDisplayName).append(". ").append("Let them know that they will receive ").append(newRewardDisplayName).append(" as a reward for completing the quest.");
        }
    }

    private JsonObject prepareApiRequest(StringBuilder systemPrompt, String villagerId, String input) {
        JsonObject jsonBody = new JsonObject();
        jsonBody.addProperty("model", "gpt-4");
        JsonArray messages = new JsonArray();
        JsonObject systemMessage = new JsonObject();
        systemMessage.addProperty("role", "system");
        systemMessage.addProperty("content", systemPrompt.toString());
        messages.add((JsonElement)systemMessage);
        String conversationHistory = this.conversationManager.getConversationHistory(villagerId);
        if (!conversationHistory.isEmpty()) {
            String[] historyLines;
            JsonObject contextMessage = new JsonObject();
            contextMessage.addProperty("role", "system");
            contextMessage.addProperty("content", "This is the past conversation between the player (User) and the villager (Assistant):");
            messages.add((JsonElement)contextMessage);
            for (String line : historyLines = conversationHistory.split("\n")) {
                if (line.startsWith("User: ")) {
                    JsonObject userMessage = new JsonObject();
                    userMessage.addProperty("role", "user");
                    userMessage.addProperty("content", line.replaceFirst("User: ", "").trim());
                    messages.add((JsonElement)userMessage);
                    continue;
                }
                if (!line.startsWith("Villager: ")) continue;
                JsonObject villagerMessage = new JsonObject();
                villagerMessage.addProperty("role", "assistant");
                villagerMessage.addProperty("content", line.replaceFirst("Villager: ", "").trim());
                messages.add((JsonElement)villagerMessage);
            }
        }
        JsonObject userInput = new JsonObject();
        userInput.addProperty("role", "user");
        userInput.addProperty("content", input);
        messages.add((JsonElement)userInput);
        jsonBody.add("messages", (JsonElement)messages);
        jsonBody.addProperty("max_tokens", (Number)150);
        return jsonBody;
    }

    private void appendVillagerContext(StringBuilder systemPrompt, String villagerName, class_1646 villager, class_3218 world) {
        String timeOfDay;
        String professionName = villager.method_7231().method_16924().toString().toLowerCase();
        boolean isDaytime = world.method_8530();
        boolean isRaining = world.method_8419();
        boolean isThundering = world.method_8546();
        boolean isIndoors = !world.method_8311(villager.method_24515());
        String string = timeOfDay = isDaytime ? "daytime" : "nighttime";
        String weatherCondition = isThundering ? "a thunderstorm" : (isRaining ? "raining" : "clear");
        systemPrompt.append("You are a ").append(professionName).append(" villager named ").append(villagerName).append(". It is currently ").append(timeOfDay).append(" and ").append(weatherCondition).append(". ").append(isIndoors ? "You are indoors." : "You are outdoors. ");
    }

    private void appendEnvironmentDetails(StringBuilder systemPrompt, class_1646 villager, class_3218 world) {
        class_1959 biome = (class_1959)world.method_23753(villager.method_24515()).comp_349();
        String biomeMessage = BiomeMessages.getBiomeMessage(world, biome);
        systemPrompt.append(biomeMessage).append(" ");
    }

    private void appendVillagerStyleAndProfession(StringBuilder systemPrompt, class_1646 villager) {
        String[] style = VillagerStyleManager.getStyle(villager, (class_3218)villager.method_37908());
        if (style.length > 0) {
            systemPrompt.append(style[0]).append(". ");
        }
        if (style.length > 1) {
            systemPrompt.append(style[1]).append(". ");
        }
        if (villager.method_6109()) {
            systemPrompt.append("You are a baby villager. You are young, curious and playful and usually do not work or trade. You speak in a simpler language. ");
        }
    }

    private void appendTradeOffers(StringBuilder systemPrompt, class_1646 villager) {
        class_1916 tradeOffers = villager.method_8264();
        if (!tradeOffers.isEmpty()) {
            systemPrompt.append("Your current trade offers are: ");
            int tradeNumber = 1;
            for (class_1914 offer : tradeOffers) {
                class_1799 sellItem = offer.method_8250();
                class_1799 firstBuyItem = offer.method_8246();
                systemPrompt.append(tradeNumber).append(". ").append(firstBuyItem.method_7964().getString()).append(" (").append(firstBuyItem.method_7947()).append(") for ").append(sellItem.method_7964().getString()).append(". ");
                ++tradeNumber;
            }
        } else {
            systemPrompt.append("You currently have no trade offers available.");
        }
    }

    private void appendRareBlocks(StringBuilder systemPrompt, class_3218 world, class_1646 villager) {
        String rareBlockMessage = RareBlockDetection.detectRareBlocks(world, villager, 32);
        systemPrompt.append(rareBlockMessage).append(" ");
    }

    private void appendNearbyStructureMessage(StringBuilder systemPrompt, class_3218 world, class_2338 pos) {
        Map<String, class_6862<class_3195>> structures = StructureMessages.getStructureTags();
        boolean structureFound = false;
        for (Map.Entry<String, class_6862<class_3195>> entry : structures.entrySet()) {
            String structureName = entry.getKey();
            class_6862<class_3195> structureTag = entry.getValue();
            class_2338 nearestStructurePos = world.method_8487(structureTag, pos, 200, false);
            if (nearestStructurePos == null) continue;
            structureFound = true;
            double distance = Math.sqrt(pos.method_10262((class_2382)nearestStructurePos));
            if (distance < 80.0) {
                systemPrompt.append("You are in ").append(structureName).append(". ");
                continue;
            }
            if (!(distance < 130.0)) continue;
            systemPrompt.append("You are close to ").append(structureName).append(". ");
        }
        if (!structureFound) {
            systemPrompt.append("No significant structures nearby. ");
        }
    }

    private void appendNearbyEntities(StringBuilder systemPrompt, class_1646 villager) {
        List nearbyEntities = villager.method_5770().method_8390(class_1297.class, villager.method_5829().method_1014(32.0), entity -> entity instanceof class_1309 && this.isEntityVisible(villager, (class_1297)entity));
        for (class_1297 entity2 : nearbyEntities) {
            if (entity2 instanceof class_1646) {
                class_1646 nearbyVillager = (class_1646)entity2;
                this.appendNearbyVillager(systemPrompt, nearbyVillager);
                continue;
            }
            String entityType = entity2.method_5864().method_5897().getString();
            String entityName = entity2.method_16914() ? entity2.method_5797().getString() : entityType;
            systemPrompt.append(entityName).append(" (").append(entityType).append(") is nearby. ");
        }
    }

    private void appendNearbyVillager(StringBuilder systemPrompt, class_1646 nearbyVillager) {
        String professionName = nearbyVillager.method_7231().method_16924().toString().toLowerCase();
        String[] style = VillagerStyleManager.getStyle(nearbyVillager, (class_3218)nearbyVillager.method_37908());
        systemPrompt.append("A ").append(professionName).append(" villager ");
        if (nearbyVillager.method_16914()) {
            systemPrompt.append("named ").append(nearbyVillager.method_5797().getString()).append(" ");
        }
        if (style.length > 0) {
            systemPrompt.append("with a ").append(style[0]).append(" personality. ");
        }
    }

    private void appendPlayerDetails(StringBuilder systemPrompt, class_3222 player, class_1646 villager) {
        class_1934 gameMode = player.field_13974.method_14257();
        systemPrompt.append("The player is in ").append(gameMode.method_8381()).append(" mode. ");
        if (gameMode == class_1934.field_9215) {
            float health = player.method_6032();
            String healthCondition = health <= 3.0f ? "barely holding on, with just a sliver of life left." : (health <= 7.0f ? "seriously wounded and needs care." : (health <= 9.0f ? "slightly scratched but capable of continuing." : "in peak condition with full vitality."));
            systemPrompt.append("The player is ").append(healthCondition).append(" ");
            int foodLevel = player.method_7344().method_7586();
            String foodCondition = foodLevel <= 3 ? "starving and needs immediate sustenance." : (foodLevel <= 7 ? "hungry and losing energy." : (foodLevel <= 9 ? "satisfied with enough food to maintain energy." : "fully nourished with peak energy."));
            systemPrompt.append("and is ").append(foodCondition).append(". ");
        }
        this.appendArmorDetails(systemPrompt, player);
        this.appendHotbarDetails(systemPrompt, player);
        this.appendReputationDetails(systemPrompt, player, villager);
        this.appendPotionEffects(systemPrompt, player);
    }

    private void appendArmorDetails(StringBuilder systemPrompt, class_3222 player) {
        systemPrompt.append("The player is wearing: ");
        class_2371 armor = player.method_31548().field_7548;
        boolean hasArmor = false;
        if (!((class_1799)armor.get(3)).method_7960()) {
            systemPrompt.append(((class_1799)armor.get(3)).method_7964().getString()).append(" (helmet), ");
            hasArmor = true;
        }
        if (!((class_1799)armor.get(2)).method_7960()) {
            systemPrompt.append(((class_1799)armor.get(2)).method_7964().getString()).append(" (chestplate), ");
            hasArmor = true;
        }
        if (!((class_1799)armor.get(1)).method_7960()) {
            systemPrompt.append(((class_1799)armor.get(1)).method_7964().getString()).append(" (leggings), ");
            hasArmor = true;
        }
        if (!((class_1799)armor.get(0)).method_7960()) {
            systemPrompt.append(((class_1799)armor.get(0)).method_7964().getString()).append(" (boots). ");
            hasArmor = true;
        }
        if (!hasArmor) {
            systemPrompt.append("no armor. ");
        }
    }

    private void appendHotbarDetails(StringBuilder systemPrompt, class_3222 player) {
        systemPrompt.append("The player carries the following items: ");
        for (int i = 0; i < 9; ++i) {
            class_1799 item = player.method_31548().method_5438(i);
            if (item.method_7960()) continue;
            systemPrompt.append(item.method_7964().getString()).append(", ");
        }
    }

    private void appendReputationDetails(StringBuilder systemPrompt, class_3222 player, class_1646 villager) {
        int reputation = villager.method_20594((class_1657)player);
        if (reputation >= 10) {
            systemPrompt.append("The player is revered as a hero and savior of the village. We owe them everything. ");
        } else if (reputation > 0) {
            systemPrompt.append("The player is respected, though not without skepticism. They have earned some trust, but we remain watchful. ");
        } else if (reputation == 0) {
            systemPrompt.append("The player is just another outsider. They haven't proven themselves, and we don't owe them any kindness. ");
        } else if (reputation > -5) {
            systemPrompt.append("The player is not welcome. Their actions are suspicious, and they walk a thin line with us. ");
        } else if (reputation > -10) {
            systemPrompt.append("The player is a menace to our village. We whisper warnings to each other about their treachery. ");
        } else {
            systemPrompt.append("The player is our mortal enemy, a bringer of ruin and despair. They are unwelcome, and we wish them gone forever. ");
        }
    }

    private void appendPotionEffects(StringBuilder systemPrompt, class_3222 player) {
        Collection effects = player.method_6026();
        if (!effects.isEmpty()) {
            systemPrompt.append("The player is affected by: ");
            for (class_1293 effect : effects) {
                String effectName = ((class_1291)effect.method_5579().comp_349()).method_5567();
                int amplifier = effect.method_5578() + 1;
                systemPrompt.append(effectName).append(" (Level ").append(amplifier).append("), ");
            }
        }
    }

    private String fetchResponseFromApi(JsonObject jsonBody, String villagerId, String input) {
        try {
            JsonObject choice;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL)).header("Content-Type", "application/json").header("Authorization", "Bearer " + API_KEY).POST(HttpRequest.BodyPublishers.ofString(jsonBody.toString())).build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject jsonResponse = JsonParser.parseString((String)response.body()).getAsJsonObject();
            if (jsonResponse.has("choices") && !jsonResponse.getAsJsonArray("choices").isEmpty() && (choice = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject()).has("message") && choice.getAsJsonObject("message").has("content")) {
                String generatedText = choice.getAsJsonObject("message").get("content").getAsString().trim();
                this.conversationManager.saveConversation(villagerId, input, generatedText);
                return generatedText;
            }
            System.out.println("Invalid API response: " + response.body());
            return "Sorry, I can't respond right now.";
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return "Sorry, an error occurred while generating the response.";
        }
    }

    private boolean isEntityVisible(class_1646 villager, class_1297 entity) {
        class_243 entityPos;
        class_243 villagerPos;
        class_3218 world = (class_3218)villager.method_37908();
        class_3965 result = world.method_17742(new class_3959(villagerPos = villager.method_19538().method_1031(0.0, (double)villager.method_5751(), 0.0), entityPos = entity.method_19538().method_1031(0.0, (double)entity.method_18381(entity.method_18376()), 0.0), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)villager));
        return result.method_17783() == class_239.class_240.field_1333;
    }

    private void appendFriendshipMessage(StringBuilder systemPrompt, class_1646 villager, class_3222 player) {
        boolean isBefriended = VillagerFriendshipManager.isBefriended(villager);
        int playerReputation = villager.method_20594((class_1657)player);
        if (isBefriended) {
            systemPrompt.append("You have formed a strong bond with this player. They are your trusted friend. ").append("You are following the player on their journey by their side. ");
        } else if (playerReputation < 0) {
            systemPrompt.append("This player has harmed you or your village, making friendship impossible. ");
        }
    }
}

